/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.ddlgeneration.platform;

import com.avaje.ebean.dbmigration.ddlgeneration.DdlBuffer;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlWrite;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.DbTriggerBasedHistoryDdl;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.HistoryTableUpdate;
import com.avaje.ebean.dbmigration.model.MTable;
import java.io.IOException;
import java.util.List;

public class MySqlHistoryDdl
extends DbTriggerBasedHistoryDdl {
    @Override
    protected void dropTriggers(DdlBuffer buffer, String baseTable) throws IOException {
        buffer.append("drop trigger ").append(this.updateTriggerName(baseTable)).endOfStatement();
        buffer.append("drop trigger ").append(this.deleteTriggerName(baseTable)).endOfStatement();
    }

    @Override
    protected void createTriggers(DdlWrite writer, MTable table) throws IOException {
        String baseTableName = table.getName();
        String historyTableName = this.historyTableName(baseTableName);
        List<String> includedColumns = this.includedColumnNames(table);
        DdlBuffer apply = writer.applyHistory();
        this.addBeforeUpdate(apply, this.updateTriggerName(baseTableName), baseTableName, historyTableName, includedColumns);
        this.addBeforeDelete(apply, this.deleteTriggerName(baseTableName), baseTableName, historyTableName, includedColumns);
    }

    @Override
    protected void regenerateHistoryTriggers(DdlWrite writer, MTable table, HistoryTableUpdate update) throws IOException {
        String baseTableName = table.getName();
        String historyTableName = this.historyTableName(baseTableName);
        List<String> includedColumns = this.includedColumnNames(table);
        DdlBuffer apply = writer.applyHistory();
        apply.append("-- Regenerated ").newLine();
        apply.append("-- changes: ").append(update.description()).newLine();
        apply.append("lock tables ").append(baseTableName).append(" write").endOfStatement();
        this.dropTriggers(apply, baseTableName);
        this.addBeforeUpdate(apply, this.updateTriggerName(baseTableName), baseTableName, historyTableName, includedColumns);
        this.addBeforeDelete(apply, this.deleteTriggerName(baseTableName), baseTableName, historyTableName, includedColumns);
        apply.append("unlock tables").endOfStatement();
        update.toRevertedColumns(includedColumns);
        DdlBuffer rollback = writer.rollback();
        rollback.append("-- Revert regenerated ").newLine();
        rollback.append("-- revert changes: ").append(update.description()).newLine();
        rollback.append("lock tables ").append(baseTableName).append(" write").endOfStatement();
        this.dropTriggers(rollback, baseTableName);
        this.addBeforeUpdate(rollback, this.updateTriggerName(baseTableName), baseTableName, historyTableName, includedColumns);
        this.addBeforeDelete(rollback, this.deleteTriggerName(baseTableName), baseTableName, historyTableName, includedColumns);
        rollback.append("unlock tables").endOfStatement();
    }

    private void addBeforeUpdate(DdlBuffer apply, String triggerName, String baseTable, String historyTable, List<String> includedColumns) throws IOException {
        apply.append("delimiter $$").newLine().append("create trigger ").append(triggerName).append(" before update on ").append(baseTable).append(" for each row begin").newLine();
        this.appendInsertIntoHistory(apply, historyTable, includedColumns);
        apply.append("    set NEW.").append(this.sysPeriod).append("_start = now(6)").endOfStatement().append("end$$").newLine();
    }

    private void addBeforeDelete(DdlBuffer apply, String triggerName, String baseTable, String historyTable, List<String> includedColumns) throws IOException {
        apply.append("delimiter $$").newLine().append("create trigger ").append(triggerName).append(" before delete on ").append(baseTable).append(" for each row begin").newLine();
        this.appendInsertIntoHistory(apply, historyTable, includedColumns);
        apply.append("end$$").newLine();
    }
}

