/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.ddlgeneration.platform;

import com.avaje.ebean.config.DbConstraintNaming;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DbIdentity;
import com.avaje.ebean.config.dbplatform.DbTypeMap;
import com.avaje.ebean.config.dbplatform.IdType;
import com.avaje.ebean.dbmigration.ddlgeneration.BaseDdlHandler;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlBuffer;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlHandler;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlWrite;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.HistoryTableUpdate;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.NoHistorySupportDdl;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.PlatformHistoryDdl;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.util.PlatformTypeConverter;
import com.avaje.ebean.dbmigration.migration.AddHistoryTable;
import com.avaje.ebean.dbmigration.migration.AlterColumn;
import com.avaje.ebean.dbmigration.migration.Column;
import com.avaje.ebean.dbmigration.migration.DropHistoryTable;
import com.avaje.ebean.dbmigration.migration.IdentityType;
import com.avaje.ebean.dbmigration.model.MTable;
import java.io.IOException;
import java.util.List;

public class PlatformDdl {
    protected PlatformHistoryDdl historyDdl = new NoHistorySupportDdl();
    private final PlatformTypeConverter typeConverter;
    private final DbIdentity dbIdentity;
    protected String dropTableIfExists = "drop table if exists ";
    protected String dropTableCascade = "";
    protected String dropSequenceIfExists = "drop sequence if exists ";
    protected String foreignKeyRestrict = "on delete restrict on update restrict";
    protected String identitySuffix = " auto_increment";
    protected String dropConstraintIfExists = "drop constraint if exists";
    protected String dropIndexIfExists = "drop index if exists ";
    protected String alterColumn = "alter column";
    protected String dropUniqueConstraint = "drop constraint";
    protected String columnSetType = "";
    protected String columnSetDefault = "set default";
    protected String columnDropDefault = "drop default";
    protected String columnSetNotnull = "set not null";
    protected String columnSetNull = "set null";
    protected boolean inlineUniqueOneToOne = true;
    protected DbConstraintNaming naming;

    public PlatformDdl(DbTypeMap platformTypes, DbIdentity dbIdentity) {
        this.dbIdentity = dbIdentity;
        this.typeConverter = new PlatformTypeConverter(platformTypes);
    }

    public void configure(ServerConfig serverConfig) {
        this.historyDdl.configure(serverConfig, this);
        this.naming = serverConfig.getConstraintNaming();
    }

    public DdlHandler createDdlHandler(ServerConfig serverConfig) {
        return new BaseDdlHandler(serverConfig, this);
    }

    public IdType useIdentityType(IdentityType modelIdentityType) {
        return this.dbIdentity.useIdentityType(modelIdentityType);
    }

    public String asIdentityColumn(String columnDefn) {
        return columnDefn + this.identitySuffix;
    }

    public void writeTableColumns(DdlBuffer apply, List<Column> columns, boolean useIdentity) throws IOException {
        for (int i = 0; i < columns.size(); ++i) {
            apply.newLine();
            this.writeColumnDefinition(apply, columns.get(i), useIdentity);
            if (i >= columns.size() - 1) continue;
            apply.append(",");
        }
    }

    protected void writeColumnDefinition(DdlBuffer buffer, Column column, boolean useIdentity) throws IOException {
        boolean identityColumn = useIdentity && this.isTrue(column.isPrimaryKey());
        String platformType = this.convert(column.getType(), identityColumn);
        buffer.append("  ");
        buffer.append(this.lowerColumnName(column.getName()), 29);
        buffer.append(platformType);
        if (this.isTrue(column.isNotnull()) || this.isTrue(column.isPrimaryKey())) {
            buffer.append(" not null");
        }
    }

    public String alterTableDropForeignKey(String tableName, String fkName) {
        return "alter table " + tableName + " " + this.dropConstraintIfExists + " " + fkName;
    }

    public String convert(String type, boolean identity) {
        String platformType = this.typeConverter.convert(type);
        return identity ? this.asIdentityColumn(platformType) : platformType;
    }

    public void createWithHistory(DdlWrite writer, MTable table) throws IOException {
        this.historyDdl.createWithHistory(writer, table);
    }

    public void dropHistoryTable(DdlWrite writer, DropHistoryTable dropHistoryTable) throws IOException {
        this.historyDdl.dropHistoryTable(writer, dropHistoryTable);
    }

    public void addHistoryTable(DdlWrite writer, AddHistoryTable addHistoryTable) throws IOException {
        this.historyDdl.addHistoryTable(writer, addHistoryTable);
    }

    public void regenerateHistoryTriggers(DdlWrite write, HistoryTableUpdate update) throws IOException {
        this.historyDdl.regenerateHistoryTriggers(write, update);
    }

    public String createSequence(String sequenceName, int initialValue, int allocationSize) {
        StringBuilder sb = new StringBuilder("create sequence ");
        sb.append(sequenceName);
        if (initialValue > 1) {
            sb.append(" start with ").append(initialValue);
        }
        if (allocationSize > 0 && allocationSize != 50) {
            sb.append(" increment by ").append(allocationSize);
        }
        sb.append(";");
        return sb.toString();
    }

    public String dropSequence(String sequenceName) {
        return this.dropSequenceIfExists + sequenceName;
    }

    public String dropTable(String tableName) {
        return this.dropTableIfExists + tableName + this.dropTableCascade;
    }

    public String dropIndex(String indexName, String tableName) {
        return this.dropIndexIfExists + indexName;
    }

    public String createIndex(String indexName, String tableName, String[] columns) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("create index ").append(indexName).append(" on ").append(tableName);
        this.appendColumns(columns, buffer);
        return buffer.toString();
    }

    public String alterTableAddForeignKey(String tableName, String fkName, String[] columns, String refTable, String[] refColumns) {
        StringBuilder buffer = new StringBuilder(90);
        buffer.append("alter table ").append(tableName).append(" add constraint ").append(fkName).append(" foreign key");
        this.appendColumns(columns, buffer);
        buffer.append(" references ").append(this.lowerTableName(refTable));
        this.appendColumns(refColumns, buffer);
        this.appendWithSpace(this.foreignKeyRestrict, buffer);
        return buffer.toString();
    }

    public String alterTableDropUniqueConstraint(String tableName, String uniqueConstraintName) {
        return "alter table " + tableName + " " + this.dropUniqueConstraint + " " + uniqueConstraintName;
    }

    public String alterTableAddUniqueConstraint(String tableName, String uqName, String[] columns) {
        StringBuilder buffer = new StringBuilder(90);
        buffer.append("alter table ").append(tableName).append(" add constraint ").append(uqName).append(" unique ");
        this.appendColumns(columns, buffer);
        return buffer.toString();
    }

    public boolean isInlineUniqueOneToOne() {
        return this.inlineUniqueOneToOne;
    }

    public String alterColumnType(String tableName, String columnName, String type) {
        return "alter table " + tableName + " " + this.alterColumn + " " + columnName + " " + this.columnSetType + type;
    }

    public String alterColumnNotnull(String tableName, String columnName, boolean notnull) {
        String suffix = notnull ? this.columnSetNotnull : this.columnSetNull;
        return "alter table " + tableName + " " + this.alterColumn + " " + columnName + " " + suffix;
    }

    public boolean isDropDefault(String defaultValue) {
        return "DROP DEFAULT".equals(defaultValue);
    }

    public String alterColumnDefaultValue(String tableName, String columnName, String defaultValue) {
        String suffix = this.isDropDefault(defaultValue) ? this.columnDropDefault : this.columnSetDefault + " " + defaultValue;
        return "alter table " + tableName + " " + this.alterColumn + " " + columnName + " " + suffix;
    }

    public String alterColumnBaseAttributes(AlterColumn alter) {
        return null;
    }

    protected void appendColumns(String[] columns, StringBuilder buffer) {
        buffer.append(" (");
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(this.lowerColumnName(columns[i].trim()));
        }
        buffer.append(")");
    }

    protected void appendWithSpace(String content, StringBuilder buffer) {
        if (content != null && !content.isEmpty()) {
            buffer.append(" ").append(content);
        }
    }

    protected String lowerTableName(String name) {
        return this.naming.lowerTableName(name);
    }

    protected String lowerColumnName(String name) {
        return this.naming.lowerColumnName(name);
    }

    protected boolean isTrue(Boolean value) {
        return Boolean.TRUE.equals(value);
    }
}

