/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.model;

import com.avaje.ebean.dbmigration.migration.ForeignKey;
import java.util.ArrayList;
import java.util.List;

public class MCompoundForeignKey {
    private final String name;
    private final String referenceTable;
    private final List<String> columns = new ArrayList<String>();
    private final List<String> referenceColumns = new ArrayList<String>();
    private String indexName;

    public MCompoundForeignKey(String name, String referenceTable, String indexName) {
        this.name = name;
        this.referenceTable = referenceTable;
        this.indexName = indexName;
    }

    public void addColumnPair(String dbCol, String refColumn) {
        this.columns.add(dbCol);
        this.referenceColumns.add(refColumn);
    }

    public ForeignKey createForeignKey() {
        ForeignKey fk = new ForeignKey();
        fk.setName(this.name);
        fk.setIndexName(this.indexName);
        fk.setColumnNames(this.toColumnNames(this.columns));
        fk.setRefColumnNames(this.toColumnNames(this.referenceColumns));
        fk.setRefTableName(this.referenceTable);
        return fk;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    private String toColumnNames(List<String> columns) {
        StringBuilder sb = new StringBuilder(40);
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(columns.get(i));
        }
        return sb.toString();
    }
}

