/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.model;

import com.avaje.ebean.dbmigration.migration.CreateIndex;
import com.avaje.ebean.dbmigration.migration.DropIndex;
import com.avaje.ebean.dbmigration.model.ModelDiff;
import java.util.ArrayList;
import java.util.List;

public class MIndex {
    private String tableName;
    private String indexName;
    private List<String> columns = new ArrayList<String>();

    public MIndex(String indexName, String tableName, String columnName) {
        this.tableName = tableName;
        this.indexName = indexName;
        this.columns.add(columnName);
    }

    public MIndex(String indexName, String tableName, String[] columnNames) {
        this.tableName = tableName;
        this.indexName = indexName;
        for (int i = 0; i < columnNames.length; ++i) {
            this.columns.add(columnNames[i]);
        }
    }

    public MIndex(CreateIndex createIndex) {
        this.indexName = createIndex.getIndexName();
        this.tableName = createIndex.getTableName();
        this.columns = this.split(createIndex.getColumns());
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public CreateIndex createIndex() {
        CreateIndex create = new CreateIndex();
        create.setIndexName(this.indexName);
        create.setTableName(this.tableName);
        create.setColumns(this.join());
        return create;
    }

    public DropIndex dropIndex() {
        DropIndex dropIndex = new DropIndex();
        dropIndex.setIndexName(this.indexName);
        dropIndex.setTableName(this.tableName);
        return dropIndex;
    }

    public void compare(ModelDiff modelDiff, MIndex newIndex) {
        if (this.changed(newIndex)) {
            modelDiff.addDropIndex(this.dropIndex());
            modelDiff.addCreateIndex(newIndex.createIndex());
        }
    }

    private boolean changed(MIndex newIndex) {
        if (!this.tableName.equals(newIndex.getTableName())) {
            return true;
        }
        List<String> newColumns = newIndex.getColumns();
        if (this.columns.size() != newColumns.size()) {
            return true;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            if (this.columns.get(i).equals(newColumns.get(i))) continue;
            return true;
        }
        return false;
    }

    private List<String> split(String columns) {
        ArrayList<String> colList = new ArrayList<String>();
        String[] cols = columns.split(",");
        for (int i = 0; i < cols.length; ++i) {
            colList.add(cols[i]);
        }
        return colList;
    }

    private String join() {
        StringBuilder sb = new StringBuilder(50);
        for (int i = 0; i < this.columns.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.columns.get(i));
        }
        return sb.toString();
    }
}

