/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.model;

import com.avaje.ebean.dbmigration.migration.AddColumn;
import com.avaje.ebean.dbmigration.migration.AddHistoryTable;
import com.avaje.ebean.dbmigration.migration.AlterColumn;
import com.avaje.ebean.dbmigration.migration.Column;
import com.avaje.ebean.dbmigration.migration.CreateTable;
import com.avaje.ebean.dbmigration.migration.DropColumn;
import com.avaje.ebean.dbmigration.migration.DropHistoryTable;
import com.avaje.ebean.dbmigration.migration.DropTable;
import com.avaje.ebean.dbmigration.migration.IdentityType;
import com.avaje.ebean.dbmigration.migration.UniqueConstraint;
import com.avaje.ebean.dbmigration.model.MColumn;
import com.avaje.ebean.dbmigration.model.MCompoundForeignKey;
import com.avaje.ebean.dbmigration.model.MCompoundUniqueConstraint;
import com.avaje.ebean.dbmigration.model.ModelDiff;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class MTable {
    private final String name;
    private String pkName;
    private String comment;
    private String tablespace;
    private String indexTablespace;
    private IdentityType identityType;
    private String sequenceName;
    private int sequenceInitial;
    private int sequenceAllocate;
    private boolean withHistory;
    private Map<String, MColumn> columns = new LinkedHashMap<String, MColumn>();
    private List<MCompoundUniqueConstraint> compoundUniqueConstraints = new ArrayList<MCompoundUniqueConstraint>();
    private List<MCompoundForeignKey> compoundKeys = new ArrayList<MCompoundForeignKey>();
    private String whenCreatedColumn;
    private AddColumn addColumn;

    public MTable(CreateTable createTable) {
        this.name = createTable.getName();
        this.pkName = createTable.getPkName();
        this.comment = createTable.getComment();
        this.tablespace = createTable.getTablespace();
        this.indexTablespace = createTable.getIndexTablespace();
        this.withHistory = Boolean.TRUE.equals(createTable.isWithHistory());
        this.sequenceName = createTable.getSequenceName();
        this.sequenceInitial = this.toInt(createTable.getSequenceInitial());
        this.sequenceAllocate = this.toInt(createTable.getSequenceAllocate());
        List<Column> cols = createTable.getColumn();
        for (Column column : cols) {
            this.addColumn(column);
        }
    }

    public MTable(String name) {
        this.name = name;
    }

    public DropTable dropTable() {
        DropTable dropTable = new DropTable();
        dropTable.setName(this.name);
        return dropTable;
    }

    public CreateTable createTable() {
        CreateTable createTable = new CreateTable();
        createTable.setName(this.name);
        createTable.setPkName(this.pkName);
        createTable.setComment(this.comment);
        createTable.setTablespace(this.tablespace);
        createTable.setIndexTablespace(this.indexTablespace);
        createTable.setSequenceName(this.sequenceName);
        createTable.setSequenceInitial(this.toBigInteger(this.sequenceInitial));
        createTable.setSequenceAllocate(this.toBigInteger(this.sequenceAllocate));
        createTable.setIdentityType(this.identityType);
        if (this.withHistory) {
            createTable.setWithHistory(Boolean.TRUE);
        }
        for (MColumn column : this.columns.values()) {
            createTable.getColumn().add(column.createColumn());
        }
        for (MCompoundForeignKey compoundKey : this.compoundKeys) {
            createTable.getForeignKey().add(compoundKey.createForeignKey());
        }
        for (MCompoundUniqueConstraint constraint : this.compoundUniqueConstraints) {
            UniqueConstraint uq = new UniqueConstraint();
            uq.setName(constraint.getName());
            String[] columns = constraint.getColumns();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < columns.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(columns[i]);
            }
            uq.setColumnNames(sb.toString());
            createTable.getUniqueConstraint().add(uq);
        }
        return createTable;
    }

    public void compare(ModelDiff modelDiff, MTable newTable) {
        if (this.withHistory != newTable.withHistory) {
            if (this.withHistory) {
                DropHistoryTable dropHistoryTable = new DropHistoryTable();
                dropHistoryTable.setBaseTable(this.name);
                modelDiff.addDropHistoryTable(dropHistoryTable);
            } else {
                AddHistoryTable addHistoryTable = new AddHistoryTable();
                addHistoryTable.setBaseTable(this.name);
                modelDiff.addAddHistoryTable(addHistoryTable);
            }
        }
        this.addColumn = null;
        LinkedHashSet<String> mappedColumns = new LinkedHashSet<String>();
        Collection<MColumn> newColumns = newTable.getColumns().values();
        for (MColumn newColumn : newColumns) {
            MColumn localColumn = this.columns.get(newColumn.getName());
            if (localColumn == null) {
                this.diffNewColumn(newColumn);
                continue;
            }
            localColumn.compare(modelDiff, this, newColumn);
            mappedColumns.add(newColumn.getName());
        }
        Collection<MColumn> existingColumns = this.columns.values();
        for (MColumn existingColumn : existingColumns) {
            if (mappedColumns.contains(existingColumn.getName())) continue;
            this.diffDropColumn(modelDiff, existingColumn);
        }
        if (this.addColumn != null) {
            modelDiff.addAddColumn(this.addColumn);
        }
    }

    public void apply(AddColumn addColumn) {
        this.checkTableName(addColumn.getTableName());
        for (Column column : addColumn.getColumn()) {
            this.addColumn(column);
        }
    }

    public void apply(AlterColumn alterColumn) {
        this.checkTableName(alterColumn.getTableName());
        String columnName = alterColumn.getColumnName();
        MColumn existingColumn = this.columns.get(columnName);
        if (existingColumn == null) {
            throw new IllegalStateException("Column [" + columnName + "] does not exist for AlterColumn change?");
        }
        existingColumn.apply(alterColumn);
    }

    public void apply(DropColumn dropColumn) {
        this.checkTableName(dropColumn.getTableName());
        this.columns.remove(dropColumn.getColumnName());
    }

    public String getName() {
        return this.name;
    }

    public String getPkName() {
        return this.pkName;
    }

    public void setPkName(String pkName) {
        this.pkName = pkName;
    }

    public String getComment() {
        return this.comment;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public String getIndexTablespace() {
        return this.indexTablespace;
    }

    public boolean isWithHistory() {
        return this.withHistory;
    }

    public void setWithHistory(boolean withHistory) {
        this.withHistory = withHistory;
    }

    public Map<String, MColumn> getColumns() {
        return this.columns;
    }

    public List<MCompoundUniqueConstraint> getCompoundUniqueConstraints() {
        return this.compoundUniqueConstraints;
    }

    public List<MCompoundForeignKey> getCompoundKeys() {
        return this.compoundKeys;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public int getSequenceInitial() {
        return this.sequenceInitial;
    }

    public void setSequenceInitial(int sequenceInitial) {
        this.sequenceInitial = sequenceInitial;
    }

    public int getSequenceAllocate() {
        return this.sequenceAllocate;
    }

    public void setSequenceAllocate(int sequenceAllocate) {
        this.sequenceAllocate = sequenceAllocate;
    }

    public void setWhenCreatedColumn(String whenCreatedColumn) {
        this.whenCreatedColumn = whenCreatedColumn;
    }

    public String getWhenCreatedColumn() {
        return this.whenCreatedColumn;
    }

    public void setIdentityType(IdentityType identityType) {
        this.identityType = identityType;
    }

    public IdentityType getIdentityType() {
        return this.identityType;
    }

    public List<MColumn> primaryKeyColumns() {
        ArrayList<MColumn> pk = new ArrayList<MColumn>(3);
        for (MColumn column : this.columns.values()) {
            if (!column.isPrimaryKey()) continue;
            pk.add(column);
        }
        return pk;
    }

    private void checkTableName(String tableName) {
        if (!this.name.equals(tableName)) {
            throw new IllegalArgumentException("addColumn tableName [" + tableName + "] does not match [" + this.name + "]");
        }
    }

    private void addColumn(Column column) {
        this.columns.put(column.getName(), new MColumn(column));
    }

    public void addColumn(MColumn column) {
        this.columns.put(column.getName(), column);
    }

    public void addCompoundUniqueConstraint(String[] columns, boolean oneToOne, String constraintName) {
        this.compoundUniqueConstraints.add(new MCompoundUniqueConstraint(columns, oneToOne, constraintName));
    }

    public void addCompoundUniqueConstraint(List<MColumn> columns, boolean oneToOne, String constraintName) {
        String[] cols = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            cols[i] = columns.get(i).getName();
        }
        this.addCompoundUniqueConstraint(cols, oneToOne, constraintName);
    }

    public void addForeignKey(MCompoundForeignKey compoundKey) {
        this.compoundKeys.add(compoundKey);
    }

    public MColumn addColumn(String dbCol, String columnDefn, boolean notnull) {
        MColumn existingColumn = this.columns.get(dbCol);
        if (existingColumn != null) {
            if (notnull) {
                existingColumn.setNotnull(true);
            }
            return existingColumn;
        }
        MColumn newCol = new MColumn(dbCol, columnDefn, notnull);
        this.addColumn(newCol);
        return newCol;
    }

    private void diffNewColumn(MColumn newColumn) {
        if (this.addColumn == null) {
            this.addColumn = new AddColumn();
            this.addColumn.setTableName(this.name);
            if (this.withHistory) {
                this.addColumn.setWithHistory(Boolean.TRUE);
            }
        }
        this.addColumn.getColumn().add(newColumn.createColumn());
    }

    private void diffDropColumn(ModelDiff modelDiff, MColumn existingColumn) {
        DropColumn dropColumn = new DropColumn();
        dropColumn.setTableName(this.name);
        dropColumn.setColumnName(existingColumn.getName());
        if (this.withHistory) {
            dropColumn.setWithHistory(Boolean.TRUE);
        }
        modelDiff.addDropColumn(dropColumn);
    }

    private int toInt(BigInteger value) {
        return value == null ? 0 : value.intValue();
    }

    private BigInteger toBigInteger(int value) {
        return value == 0 ? null : BigInteger.valueOf(value);
    }
}

