/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.model;

import com.avaje.ebean.dbmigration.migration.AddColumn;
import com.avaje.ebean.dbmigration.migration.AddHistoryTable;
import com.avaje.ebean.dbmigration.migration.AlterColumn;
import com.avaje.ebean.dbmigration.migration.ChangeSet;
import com.avaje.ebean.dbmigration.migration.CreateIndex;
import com.avaje.ebean.dbmigration.migration.CreateTable;
import com.avaje.ebean.dbmigration.migration.DropColumn;
import com.avaje.ebean.dbmigration.migration.DropHistoryTable;
import com.avaje.ebean.dbmigration.migration.DropIndex;
import com.avaje.ebean.dbmigration.migration.DropTable;
import com.avaje.ebean.dbmigration.migration.Migration;
import com.avaje.ebean.dbmigration.model.MIndex;
import com.avaje.ebean.dbmigration.model.MTable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModelContainer {
    private Map<String, MTable> tables = new LinkedHashMap<String, MTable>();
    private Map<String, MIndex> indexes = new LinkedHashMap<String, MIndex>();

    public Map<String, MTable> getTables() {
        return this.tables;
    }

    public Map<String, MIndex> getIndexes() {
        return this.indexes;
    }

    public MTable getTable(String tableName) {
        return this.tables.get(tableName);
    }

    public MIndex getIndex(String indexName) {
        return this.indexes.get(indexName);
    }

    public void apply(Migration migration) {
        List<ChangeSet> changeSets = migration.getChangeSet();
        for (ChangeSet changeSet : changeSets) {
            this.applyChangeSet(changeSet);
        }
    }

    protected void applyChangeSet(ChangeSet changeSet) {
        List<Object> changeSetChildren = changeSet.getChangeSetChildren();
        for (Object change : changeSetChildren) {
            if (change instanceof CreateTable) {
                this.applyChange((CreateTable)change);
                continue;
            }
            if (change instanceof DropTable) {
                this.applyChange((DropTable)change);
                continue;
            }
            if (change instanceof AlterColumn) {
                this.applyChange((AlterColumn)change);
                continue;
            }
            if (change instanceof AddColumn) {
                this.applyChange((AddColumn)change);
                continue;
            }
            if (change instanceof DropColumn) {
                this.applyChange((DropColumn)change);
                continue;
            }
            if (change instanceof CreateIndex) {
                this.applyChange((CreateIndex)change);
                continue;
            }
            if (change instanceof DropIndex) {
                this.applyChange((DropIndex)change);
                continue;
            }
            if (change instanceof AddHistoryTable) {
                this.applyChange((AddHistoryTable)change);
                continue;
            }
            if (!(change instanceof DropHistoryTable)) continue;
            this.applyChange((DropHistoryTable)change);
        }
    }

    private void applyChange(AddHistoryTable change) {
        MTable table = this.tables.get(change.getBaseTable());
        if (table == null) {
            throw new IllegalStateException("Table [" + change.getBaseTable() + "] does not exist in model?");
        }
        table.setWithHistory(true);
    }

    private void applyChange(DropHistoryTable change) {
        MTable table = this.tables.get(change.getBaseTable());
        if (table == null) {
            throw new IllegalStateException("Table [" + change.getBaseTable() + "] does not exist in model?");
        }
        table.setWithHistory(false);
    }

    protected void applyChange(CreateTable createTable) {
        String tableName = createTable.getName();
        if (this.tables.containsKey(tableName)) {
            throw new IllegalStateException("Table [" + tableName + "] already exists in model?");
        }
        MTable table = new MTable(createTable);
        this.tables.put(tableName, table);
    }

    protected void applyChange(DropTable dropTable) {
        String tableName = dropTable.getName();
        if (!this.tables.containsKey(tableName)) {
            throw new IllegalStateException("Table [" + tableName + "] does not exists in model?");
        }
        this.tables.remove(tableName);
    }

    protected void applyChange(CreateIndex createIndex) {
        String indexName = createIndex.getIndexName();
        if (this.indexes.containsKey(indexName)) {
            throw new IllegalStateException("Index [" + indexName + "] already exists in model?");
        }
        MIndex index = new MIndex(createIndex);
        this.indexes.put(createIndex.getIndexName(), index);
    }

    protected void applyChange(DropIndex dropIndex) {
        String name = dropIndex.getIndexName();
        if (!this.indexes.containsKey(name)) {
            throw new IllegalStateException("Index [" + name + "] does not exist in model?");
        }
        this.indexes.remove(name);
    }

    protected void applyChange(AddColumn addColumn) {
        MTable table = this.tables.get(addColumn.getTableName());
        if (table == null) {
            throw new IllegalStateException("Table [" + addColumn.getTableName() + "] does not exist in model?");
        }
        table.apply(addColumn);
    }

    protected void applyChange(AlterColumn alterColumn) {
        MTable table = this.tables.get(alterColumn.getTableName());
        if (table == null) {
            throw new IllegalStateException("Table [" + alterColumn.getTableName() + "] does not exist in model?");
        }
        table.apply(alterColumn);
    }

    protected void applyChange(DropColumn dropColumn) {
        MTable table = this.tables.get(dropColumn.getTableName());
        if (table == null) {
            throw new IllegalStateException("Table [" + dropColumn.getTableName() + "] does not exist in model?");
        }
        table.apply(dropColumn);
    }

    public void addTable(MTable table) {
        this.tables.put(table.getName(), table);
    }

    public void addIndex(String indexName, String tableName, String columnName) {
        this.indexes.put(indexName, new MIndex(indexName, tableName, columnName));
    }

    public void addIndex(String indexName, String tableName, String[] columnNames) {
        this.indexes.put(indexName, new MIndex(indexName, tableName, columnNames));
    }
}

