/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.model;

import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlHandler;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlWrite;
import com.avaje.ebean.dbmigration.migration.ChangeSet;
import com.avaje.ebean.dbmigration.migration.Migration;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class PlatformDdlWriter {
    private final ServerConfig serverConfig;
    private final DatabasePlatform platform;
    private final String platformPrefix;

    public PlatformDdlWriter(DatabasePlatform platform, ServerConfig serverConfig) {
        this(platform, serverConfig, "");
    }

    public PlatformDdlWriter(DatabasePlatform platform, ServerConfig serverConfig, String platformPrefix) {
        this.platform = platform;
        this.serverConfig = serverConfig;
        this.platformPrefix = platformPrefix;
    }

    public void processMigration(Migration dbMigration, DdlWrite write, File writePath, int nextMajorVersion) throws IOException {
        DdlHandler handler = this.handler();
        List<ChangeSet> changeSets = dbMigration.getChangeSet();
        for (ChangeSet changeSet : changeSets) {
            if (changeSet.getChangeSetChildren().isEmpty()) continue;
            handler.generate(write, changeSet);
        }
        handler.generateExtra(write);
        this.writePlatformDdl(write, writePath, nextMajorVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writePlatformDdl(DdlWrite write, File resourcePath, int migrationVersion) throws IOException {
        if (!write.isApplyEmpty()) {
            FileWriter applyWriter = this.createWriter(resourcePath, migrationVersion, "apply.sql");
            try {
                this.writeApplyDdl(applyWriter, write);
                applyWriter.flush();
            }
            finally {
                applyWriter.close();
            }
            if (!write.isApplyRollbackEmpty()) {
                FileWriter applyRollbackWriter = this.createWriter(resourcePath, migrationVersion, "applyRollback.sql");
                try {
                    this.writeApplyRollbackDdl(applyRollbackWriter, write);
                    applyRollbackWriter.flush();
                }
                finally {
                    applyRollbackWriter.close();
                }
            }
        }
        if (!write.isDropEmpty()) {
            FileWriter dropWriter = this.createWriter(resourcePath, migrationVersion, "drop.sql");
            try {
                this.writeDropDdl(dropWriter, write);
                dropWriter.flush();
            }
            finally {
                dropWriter.close();
            }
        }
    }

    protected FileWriter createWriter(File resourcePath, int migrationVersion, String suffix) throws IOException {
        File applyFile = new File(resourcePath, "v" + migrationVersion + ".0-" + this.platformPrefix + suffix);
        return new FileWriter(applyFile);
    }

    protected void writeApplyDdl(Writer writer, DdlWrite write) throws IOException {
        writer.append(write.apply().getBuffer());
        writer.append(write.applyForeignKeys().getBuffer());
        writer.append(write.applyHistory().getBuffer());
    }

    protected void writeApplyRollbackDdl(Writer writer, DdlWrite write) throws IOException {
        writer.append(write.rollbackForeignKeys().getBuffer());
        writer.append(write.rollback().getBuffer());
    }

    protected void writeDropDdl(Writer writer, DdlWrite write) throws IOException {
        writer.append(write.dropHistory().getBuffer());
        writer.append(write.drop().getBuffer());
    }

    protected DdlHandler handler() {
        return this.platform.createDdlHandler(this.serverConfig);
    }
}

