/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.model.build;

import com.avaje.ebean.config.dbplatform.DbType;
import com.avaje.ebean.config.dbplatform.IdType;
import com.avaje.ebean.dbmigration.migration.IdentityType;
import com.avaje.ebean.dbmigration.model.MColumn;
import com.avaje.ebean.dbmigration.model.MTable;
import com.avaje.ebean.dbmigration.model.build.ModelBuildContext;
import com.avaje.ebean.dbmigration.model.build.ModelBuildPropertyVisitor;
import com.avaje.ebean.dbmigration.model.visitor.BeanPropertyVisitor;
import com.avaje.ebean.dbmigration.model.visitor.BeanVisitor;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.InheritInfo;

public class ModelBuildBeanVisitor
implements BeanVisitor {
    private final ModelBuildContext ctx;

    public ModelBuildBeanVisitor(ModelBuildContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public BeanPropertyVisitor visitBean(BeanDescriptor<?> descriptor) {
        if (!descriptor.isInheritanceRoot()) {
            return null;
        }
        MTable table = new MTable(descriptor.getBaseTable());
        if (descriptor.isHistorySupport()) {
            table.setWithHistory(true);
            BeanProperty whenCreated = descriptor.findWhenCreatedProperty();
            if (whenCreated != null) {
                table.setWhenCreatedColumn(whenCreated.getDbColumn());
            }
        }
        this.setIdentity(descriptor, table);
        this.ctx.addTable(table);
        InheritInfo inheritInfo = descriptor.getInheritInfo();
        if (inheritInfo != null && inheritInfo.isRoot()) {
            String discColumn = inheritInfo.getDiscriminatorColumn();
            DbType dbType = this.ctx.getDbTypeMap().get(inheritInfo.getDiscriminatorType());
            String discDbType = dbType.renderType(inheritInfo.getDiscriminatorLength(), 0);
            table.addColumn(new MColumn(discColumn, discDbType, true));
        }
        return new ModelBuildPropertyVisitor(this.ctx, table, descriptor.getCompoundUniqueConstraints());
    }

    private void setIdentity(BeanDescriptor<?> descriptor, MTable table) {
        if (IdType.GENERATOR == descriptor.getIdType()) {
            table.setIdentityType(IdentityType.GENERATOR);
            return;
        }
        if (IdType.EXTERNAL == descriptor.getIdType()) {
            table.setIdentityType(IdentityType.EXTERNAL);
            return;
        }
        int initialValue = descriptor.getSequenceInitialValue();
        int allocationSize = descriptor.getSequenceAllocationSize();
        if (!descriptor.isIdTypePlatformDefault() || initialValue > 0 || allocationSize > 0) {
            if (IdType.IDENTITY == descriptor.getIdType()) {
                table.setIdentityType(IdentityType.IDENTITY);
            } else {
                table.setIdentityType(IdentityType.SEQUENCE);
                table.setSequenceName(descriptor.getSequenceName());
                table.setSequenceInitial(initialValue);
                table.setSequenceAllocate(allocationSize);
            }
        }
    }
}

