/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.api;

import com.avaje.ebean.TransactionCallback;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebean.config.PersistBatch;
import com.avaje.ebean.event.changelog.BeanChange;
import com.avaje.ebean.event.changelog.ChangeSet;
import com.avaje.ebeaninternal.api.DerivedRelationshipData;
import com.avaje.ebeaninternal.api.ScopeTrans;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.api.TransactionEvent;
import com.avaje.ebeaninternal.server.core.PersistRequest;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.persist.BatchControl;
import java.io.IOException;
import java.sql.Connection;
import java.util.List;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;

public class ScopedTransaction
implements SpiTransaction {
    final ScopeTrans scopeTrans;
    final SpiTransaction transaction;
    boolean committed;

    public ScopedTransaction(ScopeTrans scopeTrans) {
        this.scopeTrans = scopeTrans;
        this.transaction = scopeTrans.getTransaction();
    }

    @Override
    public void commit() throws RollbackException {
        this.scopeTrans.commitTransaction();
        this.committed = true;
    }

    @Override
    public void rollback() throws PersistenceException {
        this.scopeTrans.rollback(null);
    }

    @Override
    public void rollback(Throwable e) throws PersistenceException {
        this.scopeTrans.rollback(e);
    }

    @Override
    public void end() throws PersistenceException {
        try {
            if (!this.committed) {
                this.scopeTrans.rollback(null);
            }
        }
        finally {
            this.scopeTrans.restoreSuspended();
        }
    }

    @Override
    public String getLogPrefix() {
        return this.transaction.getLogPrefix();
    }

    @Override
    public boolean isLogSql() {
        return this.transaction.isLogSql();
    }

    @Override
    public boolean isLogSummary() {
        return this.transaction.isLogSummary();
    }

    @Override
    public void logSql(String msg) {
        this.transaction.logSql(msg);
    }

    @Override
    public void logSummary(String msg) {
        this.transaction.logSummary(msg);
    }

    @Override
    public void addBeanChange(BeanChange beanChange) {
        this.transaction.addBeanChange(beanChange);
    }

    @Override
    public void sendChangeLog(ChangeSet changes) {
        this.transaction.sendChangeLog(changes);
    }

    @Override
    public void registerDerivedRelationship(DerivedRelationshipData assocBean) {
        this.transaction.registerDerivedRelationship(assocBean);
    }

    @Override
    public List<DerivedRelationshipData> getDerivedRelationship(Object bean) {
        return this.transaction.getDerivedRelationship(bean);
    }

    @Override
    public void registerDeleteBean(Integer hash) {
        this.transaction.registerDeleteBean(hash);
    }

    @Override
    public void unregisterDeleteBean(Integer hash) {
        this.transaction.unregisterDeleteBean(hash);
    }

    @Override
    public boolean isRegisteredDeleteBean(Integer hash) {
        return this.transaction.isRegisteredDeleteBean(hash);
    }

    @Override
    public void unregisterBean(Object bean) {
        this.transaction.unregisterBean(bean);
    }

    @Override
    public boolean isRegisteredBean(Object bean) {
        return this.transaction.isRegisteredBean(bean);
    }

    @Override
    public String getId() {
        return this.transaction.getId();
    }

    @Override
    public void register(TransactionCallback callback) {
        this.transaction.register(callback);
    }

    @Override
    public boolean isReadOnly() {
        return this.transaction.isReadOnly();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.transaction.setReadOnly(readOnly);
    }

    @Override
    public boolean isActive() {
        return this.transaction.isActive();
    }

    @Override
    public void setPersistCascade(boolean persistCascade) {
        this.transaction.setPersistCascade(persistCascade);
    }

    @Override
    public void setUpdateAllLoadedProperties(boolean updateAllLoaded) {
        this.transaction.setUpdateAllLoadedProperties(updateAllLoaded);
    }

    @Override
    public Boolean isUpdateAllLoadedProperties() {
        return this.transaction.isUpdateAllLoadedProperties();
    }

    @Override
    public void setBatchMode(boolean useBatch) {
        this.transaction.setBatchMode(useBatch);
    }

    @Override
    public void setBatch(PersistBatch persistBatchMode) {
        this.transaction.setBatch(persistBatchMode);
    }

    @Override
    public PersistBatch getBatch() {
        return this.transaction.getBatch();
    }

    @Override
    public void setBatchOnCascade(PersistBatch batchOnCascadeMode) {
        this.transaction.setBatchOnCascade(batchOnCascadeMode);
    }

    @Override
    public PersistBatch getBatchOnCascade() {
        return this.transaction.getBatchOnCascade();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.transaction.setBatchSize(batchSize);
    }

    @Override
    public int getBatchSize() {
        return this.transaction.getBatchSize();
    }

    @Override
    public void setBatchGetGeneratedKeys(boolean getGeneratedKeys) {
        this.transaction.setBatchGetGeneratedKeys(getGeneratedKeys);
    }

    @Override
    public void setBatchFlushOnMixed(boolean batchFlushOnMixed) {
        this.transaction.setBatchFlushOnMixed(batchFlushOnMixed);
    }

    @Override
    public void setBatchFlushOnQuery(boolean batchFlushOnQuery) {
        this.transaction.setBatchFlushOnQuery(batchFlushOnQuery);
    }

    @Override
    public boolean isBatchFlushOnQuery() {
        return this.transaction.isBatchFlushOnQuery();
    }

    @Override
    public void flushBatch() throws PersistenceException {
        this.transaction.flushBatch();
    }

    @Override
    public Connection getConnection() {
        return this.transaction.getConnection();
    }

    @Override
    public void addModification(String tableName, boolean inserts, boolean updates, boolean deletes) {
        this.transaction.addModification(tableName, inserts, updates, deletes);
    }

    @Override
    public void putUserObject(String name, Object value) {
        this.transaction.putUserObject(name, value);
    }

    @Override
    public Object getUserObject(String name) {
        return this.transaction.getUserObject(name);
    }

    @Override
    public void depth(int diff) {
        this.transaction.depth();
    }

    @Override
    public int depth() {
        return this.transaction.depth();
    }

    @Override
    public boolean isExplicit() {
        return this.transaction.isExplicit();
    }

    @Override
    public TransactionEvent getEvent() {
        return this.transaction.getEvent();
    }

    @Override
    public boolean isPersistCascade() {
        return this.transaction.isPersistCascade();
    }

    @Override
    public boolean isBatchThisRequest(PersistRequest.Type type) {
        return this.transaction.isBatchThisRequest(type);
    }

    @Override
    public BatchControl getBatchControl() {
        return this.transaction.getBatchControl();
    }

    @Override
    public void setBatchControl(BatchControl control) {
        this.transaction.setBatchControl(control);
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.transaction.getPersistenceContext();
    }

    @Override
    public void setPersistenceContext(PersistenceContext context) {
        this.transaction.setPersistenceContext(context);
    }

    @Override
    public Connection getInternalConnection() {
        return this.transaction.getInternalConnection();
    }

    @Override
    public boolean isSaveAssocManyIntersection(String intersectionTable, String beanName) {
        return this.transaction.isSaveAssocManyIntersection(intersectionTable, beanName);
    }

    @Override
    public boolean checkBatchEscalationOnCascade(PersistRequestBean<?> request) {
        return this.transaction.checkBatchEscalationOnCascade(request);
    }

    @Override
    public void flushBatchOnCascade() {
        this.transaction.flushBatchOnCascade();
    }

    @Override
    public void markNotQueryOnly() {
        this.transaction.markNotQueryOnly();
    }

    @Override
    public void checkBatchEscalationOnCollection() {
        this.transaction.checkBatchEscalationOnCollection();
    }

    @Override
    public void flushBatchOnCollection() {
        this.transaction.flushBatchOnCollection();
    }

    @Override
    public void close() throws IOException {
        this.transaction.close();
    }
}

