/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cluster;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.config.ContainerConfig;
import com.avaje.ebeaninternal.server.cluster.ClusterBroadcast;
import com.avaje.ebeaninternal.server.cluster.mcast.McastClusterManager;
import com.avaje.ebeaninternal.server.cluster.socket.SocketClusterBroadcast;
import com.avaje.ebeaninternal.server.transaction.RemoteTransactionEvent;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterManager {
    private static final Logger logger = LoggerFactory.getLogger(ClusterManager.class);
    private final ConcurrentHashMap<String, EbeanServer> serverMap = new ConcurrentHashMap();
    private final Object monitor = new Object();
    private final ClusterBroadcast broadcast;
    private boolean started;

    public ClusterManager(ContainerConfig containerConfig) {
        ContainerConfig.ClusterMode mode = containerConfig.getMode();
        try {
            switch (mode) {
                case SOCKET: {
                    this.broadcast = new SocketClusterBroadcast(containerConfig);
                    break;
                }
                case MULTICAST: {
                    this.broadcast = new McastClusterManager(containerConfig);
                    break;
                }
                default: {
                    this.broadcast = null;
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error initialising ClusterManager type [" + (Object)((Object)mode) + "]", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServer(EbeanServer server) {
        Object object = this.monitor;
        synchronized (object) {
            this.serverMap.put(server.getName(), server);
            if (!this.started) {
                this.startup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EbeanServer getServer(String name) {
        Object object = this.monitor;
        synchronized (object) {
            return this.serverMap.get(name);
        }
    }

    private void startup() {
        this.started = true;
        if (this.broadcast != null) {
            this.broadcast.startup(this);
        }
    }

    public boolean isClustering() {
        return this.broadcast != null;
    }

    public void broadcast(RemoteTransactionEvent remoteTransEvent) {
        if (this.broadcast != null) {
            this.broadcast.broadcast(remoteTransEvent);
        }
    }

    public void shutdown() {
        if (this.broadcast != null) {
            logger.info("ClusterManager shutdown ");
            this.broadcast.shutdown();
        }
    }
}

