/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cluster;

import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.cluster.DataHolder;
import com.avaje.ebeaninternal.server.cluster.Packet;
import com.avaje.ebeaninternal.server.cluster.PacketTransactionEvent;
import com.avaje.ebeaninternal.server.cluster.PacketWriter;
import com.avaje.ebeaninternal.server.transaction.RemoteTransactionEvent;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SerialiseTransactionHelper {
    private static final Logger logger = LoggerFactory.getLogger(SerialiseTransactionHelper.class);
    private final PacketWriter packetWriter = new PacketWriter(Integer.MAX_VALUE);

    public abstract SpiEbeanServer getEbeanServer(String var1);

    public DataHolder createDataHolder(RemoteTransactionEvent transEvent) throws IOException {
        List<Packet> packetList = this.packetWriter.write(transEvent);
        if (packetList.size() != 1) {
            throw new RuntimeException("Always expecting 1 Packet but got " + packetList.size());
        }
        byte[] data = packetList.get(0).getBytes();
        return new DataHolder(data);
    }

    public RemoteTransactionEvent read(DataHolder dataHolder) throws IOException {
        ByteArrayInputStream bi = new ByteArrayInputStream(dataHolder.getData());
        DataInputStream dataInput = new DataInputStream(bi);
        Packet header = Packet.readHeader(dataInput);
        SpiEbeanServer server = this.getEbeanServer(header.getServerName());
        if (server == null) {
            logger.error("server [{}] not found/registered?", (Object)header.getServerName());
        }
        PacketTransactionEvent tranEventPacket = PacketTransactionEvent.forRead(header, server);
        tranEventPacket.read(dataInput);
        return tranEventPacket.getEvent();
    }
}

