/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cluster.socket;

import com.avaje.ebean.config.ContainerConfig;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.cluster.ClusterBroadcast;
import com.avaje.ebeaninternal.server.cluster.ClusterManager;
import com.avaje.ebeaninternal.server.cluster.DataHolder;
import com.avaje.ebeaninternal.server.cluster.SerialiseTransactionHelper;
import com.avaje.ebeaninternal.server.cluster.socket.SocketClient;
import com.avaje.ebeaninternal.server.cluster.socket.SocketClusterListener;
import com.avaje.ebeaninternal.server.cluster.socket.SocketClusterMessage;
import com.avaje.ebeaninternal.server.cluster.socket.SocketClusterStatus;
import com.avaje.ebeaninternal.server.cluster.socket.SocketConnection;
import com.avaje.ebeaninternal.server.transaction.RemoteTransactionEvent;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketClusterBroadcast
implements ClusterBroadcast {
    private static final Logger logger = LoggerFactory.getLogger(SocketClusterBroadcast.class);
    private final SocketClient local;
    private final HashMap<String, SocketClient> clientMap;
    private final SocketClusterListener listener;
    private final SocketClient[] members;
    private ClusterManager clusterManager;
    private final TxnSerialiseHelper txnSerialiseHelper = new TxnSerialiseHelper();
    private final AtomicInteger txnOutgoing = new AtomicInteger();
    private final AtomicInteger txnIncoming = new AtomicInteger();

    public SocketClusterBroadcast(ContainerConfig containerConfig) {
        ContainerConfig.SocketConfig socketConfig = containerConfig.getSocketConfig();
        String localHostPort = socketConfig.getLocalHostPort();
        List<String> members = socketConfig.getMembers();
        logger.info("Clustering using Sockets local[" + localHostPort + "] members[" + members + "]");
        this.local = new SocketClient(this.parseFullName(localHostPort));
        this.clientMap = new HashMap();
        for (String memberHostPort : members) {
            InetSocketAddress member = this.parseFullName(memberHostPort);
            SocketClient client = new SocketClient(member);
            if (this.local.getHostPort().equalsIgnoreCase(client.getHostPort())) continue;
            this.clientMap.put(client.getHostPort(), client);
        }
        this.members = this.clientMap.values().toArray(new SocketClient[this.clientMap.size()]);
        this.listener = new SocketClusterListener(this, this.local.getPort(), socketConfig.getCoreThreads(), socketConfig.getMaxThreads(), socketConfig.getThreadPoolName());
    }

    public String getHostPort() {
        return this.local.getHostPort();
    }

    public SocketClusterStatus getStatus() {
        int currentGroupSize = 0;
        for (int i = 0; i < this.members.length; ++i) {
            if (!this.members[i].isOnline()) continue;
            ++currentGroupSize;
        }
        int txnIn = this.txnIncoming.get();
        int txnOut = this.txnOutgoing.get();
        return new SocketClusterStatus(currentGroupSize, txnIn, txnOut);
    }

    @Override
    public void startup(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
        this.listener.startListening();
        this.register();
    }

    @Override
    public void shutdown() {
        this.deregister();
        this.listener.shutdown();
    }

    private void register() {
        SocketClusterMessage h = SocketClusterMessage.register(this.local.getHostPort(), true);
        for (int i = 0; i < this.members.length; ++i) {
            boolean online = this.members[i].register(h);
            logger.info("Cluster Member [{}] online[{}]", (Object)this.members[i].getHostPort(), (Object)online);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMemberOnline(String fullName, boolean online) throws IOException {
        HashMap<String, SocketClient> hashMap = this.clientMap;
        synchronized (hashMap) {
            logger.info("Cluster Member [{}] online[{}]", (Object)fullName, (Object)online);
            SocketClient member = this.clientMap.get(fullName);
            member.setOnline(online);
        }
    }

    private void send(SocketClient client, SocketClusterMessage msg) {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("... send to member {} broadcast msg: {}", (Object)client, (Object)msg);
            }
            client.send(msg);
        }
        catch (Exception ex) {
            logger.error("Error sending message", (Throwable)ex);
            try {
                client.reconnect();
            }
            catch (IOException e) {
                logger.error("Error trying to reconnect", (Throwable)ex);
            }
        }
    }

    @Override
    public void broadcast(RemoteTransactionEvent remoteTransEvent) {
        try {
            this.txnOutgoing.incrementAndGet();
            DataHolder dataHolder = this.txnSerialiseHelper.createDataHolder(remoteTransEvent);
            SocketClusterMessage msg = SocketClusterMessage.transEvent(dataHolder);
            this.broadcast(msg);
        }
        catch (Exception e) {
            logger.error("Error sending RemoteTransactionEvent " + remoteTransEvent + " to cluster members.", (Throwable)e);
        }
    }

    protected void broadcast(SocketClusterMessage msg) {
        if (logger.isTraceEnabled()) {
            logger.trace("... broadcast msg: " + msg);
        }
        for (int i = 0; i < this.members.length; ++i) {
            this.send(this.members[i], msg);
        }
    }

    private void deregister() {
        SocketClusterMessage h = SocketClusterMessage.register(this.local.getHostPort(), false);
        this.broadcast(h);
        for (int i = 0; i < this.members.length; ++i) {
            this.members[i].disconnect();
        }
    }

    protected boolean process(SocketConnection request) throws ClassNotFoundException {
        try {
            SocketClusterMessage h = (SocketClusterMessage)request.readObject();
            if (logger.isTraceEnabled()) {
                logger.trace("... received msg: {}", (Object)h);
            }
            if (h.isRegisterEvent()) {
                this.setMemberOnline(h.getRegisterHost(), h.isRegister());
            } else {
                this.txnIncoming.incrementAndGet();
                DataHolder dataHolder = h.getDataHolder();
                RemoteTransactionEvent transEvent = this.txnSerialiseHelper.read(dataHolder);
                transEvent.run();
            }
            return h.isRegisterEvent() && !h.isRegister();
        }
        catch (InterruptedIOException e) {
            logger.info("Timeout waiting for message", (Throwable)e);
            try {
                request.disconnect();
            }
            catch (IOException ex) {
                logger.info("Error disconnecting after timeout", (Throwable)ex);
            }
            return true;
        }
        catch (EOFException e) {
            logger.info("EOF disconnecting");
            return true;
        }
        catch (IOException e) {
            logger.info("IO Error waiting/reading message", (Throwable)e);
            return true;
        }
    }

    private InetSocketAddress parseFullName(String hostAndPort) {
        try {
            hostAndPort = hostAndPort.trim();
            int colonPos = hostAndPort.indexOf(":");
            if (colonPos == -1) {
                String msg = "No colon \":\" in " + hostAndPort;
                throw new IllegalArgumentException(msg);
            }
            String host = hostAndPort.substring(0, colonPos);
            String sPort = hostAndPort.substring(colonPos + 1, hostAndPort.length());
            int port = Integer.parseInt(sPort);
            return new InetSocketAddress(host, port);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error parsing [" + hostAndPort + "] for the form [host:port]", ex);
        }
    }

    class TxnSerialiseHelper
    extends SerialiseTransactionHelper {
        TxnSerialiseHelper() {
        }

        @Override
        public SpiEbeanServer getEbeanServer(String serverName) {
            return (SpiEbeanServer)SocketClusterBroadcast.this.clusterManager.getServer(serverName);
        }
    }
}

