/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cluster.socket;

import com.avaje.ebeaninternal.server.cluster.socket.RequestProcessor;
import com.avaje.ebeaninternal.server.cluster.socket.SocketClusterBroadcast;
import com.avaje.ebeaninternal.server.lib.DaemonThreadPool;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SocketClusterListener
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SocketClusterListener.class);
    private final ServerSocket serverListenSocket;
    private final Thread listenerThread;
    private final DaemonThreadPool threadPool;
    private final SocketClusterBroadcast owner;
    boolean doingShutdown;
    boolean isActive;

    public SocketClusterListener(SocketClusterBroadcast owner, int port, int coreThreads, int maxThreads, String poolName) {
        this.owner = owner;
        this.threadPool = new DaemonThreadPool(coreThreads, maxThreads, 60L, 30, poolName);
        try {
            this.serverListenSocket = new ServerSocket(port);
            this.serverListenSocket.setSoTimeout(60000);
            this.listenerThread = new Thread((Runnable)this, "EbeanClusterListener");
        }
        catch (IOException e) {
            String msg = "Error starting cluster socket listener on port " + port;
            throw new RuntimeException(msg, e);
        }
    }

    public void startListening() {
        logger.trace("... startListening()");
        this.listenerThread.setDaemon(true);
        this.listenerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.doingShutdown = true;
        try {
            if (this.isActive) {
                Thread thread = this.listenerThread;
                synchronized (thread) {
                    try {
                        this.listenerThread.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.listenerThread.interrupt();
            this.serverListenSocket.close();
        }
        catch (IOException e) {
            logger.error("Error shutting down listener", (Throwable)e);
        }
        this.threadPool.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.doingShutdown) {
            try {
                Thread thread = this.listenerThread;
                synchronized (thread) {
                    Socket clientSocket = this.serverListenSocket.accept();
                    this.isActive = true;
                    RequestProcessor request = new RequestProcessor(this.owner, clientSocket);
                    this.threadPool.execute(request);
                    this.isActive = false;
                }
            }
            catch (SocketException e) {
                if (this.doingShutdown) {
                    logger.info("doingShutdown and accept threw:" + e.getMessage());
                    continue;
                }
                logger.error("Error while listening", (Throwable)e);
            }
            catch (InterruptedIOException e) {
                logger.debug("Possibly expected due to accept timeout? {}", (Object)e.getMessage());
            }
            catch (IOException e) {
                logger.error("IOException processing cluster message", (Throwable)e);
            }
        }
    }
}

