/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.config.CompoundType;
import com.avaje.ebean.config.ScalarTypeConverter;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.event.BeanFindController;
import com.avaje.ebean.event.BeanPersistController;
import com.avaje.ebean.event.BeanPersistListener;
import com.avaje.ebean.event.BeanPostLoad;
import com.avaje.ebean.event.BeanQueryAdapter;
import com.avaje.ebean.event.ServerConfigStartup;
import com.avaje.ebean.event.TransactionEventListener;
import com.avaje.ebean.event.changelog.ChangeLogListener;
import com.avaje.ebean.event.changelog.ChangeLogPrepare;
import com.avaje.ebean.event.changelog.ChangeLogRegister;
import com.avaje.ebean.event.readaudit.ReadAuditLogger;
import com.avaje.ebean.event.readaudit.ReadAuditPrepare;
import com.avaje.ebeaninternal.server.type.ScalarType;
import com.avaje.ebeaninternal.server.util.ClassPathSearchMatcher;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootupClasses
implements ClassPathSearchMatcher {
    private static final Logger logger = LoggerFactory.getLogger(BootupClasses.class);
    private final List<Class<?>> embeddableList = new ArrayList();
    private final List<Class<?>> entityList = new ArrayList();
    private final List<Class<?>> scalarTypeList = new ArrayList();
    private final List<Class<?>> scalarConverterList = new ArrayList();
    private final List<Class<?>> compoundTypeList = new ArrayList();
    private final List<Class<?>> beanControllerList = new ArrayList();
    private final List<Class<?>> beanPostLoadList = new ArrayList();
    private final List<Class<?>> transactionEventListenerList = new ArrayList();
    private final List<Class<?>> beanFindControllerList = new ArrayList();
    private final List<Class<?>> beanQueryAdapterList = new ArrayList();
    private final List<Class<?>> beanListenerList = new ArrayList();
    private final List<Class<?>> serverConfigStartupList = new ArrayList();
    private final List<ServerConfigStartup> serverConfigStartupInstances = new ArrayList<ServerConfigStartup>();
    private final List<BeanFindController> findControllerInstances = new ArrayList<BeanFindController>();
    private final List<BeanPersistController> persistControllerInstances = new ArrayList<BeanPersistController>();
    private final List<BeanPostLoad> beanPostLoadInstances = new ArrayList<BeanPostLoad>();
    private final List<BeanPersistListener> persistListenerInstances = new ArrayList<BeanPersistListener>();
    private final List<BeanQueryAdapter> queryAdapterInstances = new ArrayList<BeanQueryAdapter>();
    private final List<TransactionEventListener> transactionEventListenerInstances = new ArrayList<TransactionEventListener>();
    private Class<?> changeLogPrepareClass;
    private Class<?> changeLogListenerClass;
    private Class<?> changeLogRegisterClass;
    private Class<?> readAuditPrepareClass;
    private Class<?> readAuditLoggerClass;
    private ChangeLogPrepare changeLogPrepare;
    private ChangeLogListener changeLogListener;
    private ChangeLogRegister changeLogRegister;
    private ReadAuditPrepare readAuditPrepare;
    private ReadAuditLogger readAuditLogger;

    public BootupClasses() {
    }

    public BootupClasses(List<Class<?>> list) {
        if (list != null) {
            for (Class<?> cls : list) {
                this.isMatch(cls);
            }
        }
    }

    public void runServerConfigStartup(ServerConfig serverConfig) {
        for (Class<?> cls : this.serverConfigStartupList) {
            try {
                ServerConfigStartup newInstance = (ServerConfigStartup)cls.newInstance();
                newInstance.onStart(serverConfig);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error running ServerConfigStartup " + cls, e);
            }
        }
        for (ServerConfigStartup startup : this.serverConfigStartupInstances) {
            try {
                startup.onStart(serverConfig);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error running ServerConfigStartup " + startup.getClass(), e);
            }
        }
    }

    public void addQueryAdapters(List<BeanQueryAdapter> queryAdapterInstances) {
        if (queryAdapterInstances != null) {
            for (BeanQueryAdapter a : queryAdapterInstances) {
                this.queryAdapterInstances.add(a);
                this.beanQueryAdapterList.remove(a.getClass());
            }
        }
    }

    public void addPersistControllers(List<BeanPersistController> beanControllerInstances) {
        if (beanControllerInstances != null) {
            for (BeanPersistController c : beanControllerInstances) {
                this.persistControllerInstances.add(c);
                this.beanControllerList.remove(c.getClass());
            }
        }
    }

    public void addPostLoaders(List<BeanPostLoad> postLoadInstances) {
        if (postLoadInstances != null) {
            for (BeanPostLoad c : postLoadInstances) {
                this.beanPostLoadInstances.add(c);
                this.beanPostLoadList.remove(c.getClass());
            }
        }
    }

    public void addFindControllers(List<BeanFindController> findControllers) {
        if (findControllers != null) {
            for (BeanFindController c : findControllers) {
                this.findControllerInstances.add(c);
                this.beanFindControllerList.remove(c.getClass());
            }
        }
    }

    public void addTransactionEventListeners(List<TransactionEventListener> transactionEventListeners) {
        if (transactionEventListeners != null) {
            for (TransactionEventListener c : transactionEventListeners) {
                this.transactionEventListenerInstances.add(c);
                this.transactionEventListenerList.remove(c.getClass());
            }
        }
    }

    public void addPersistListeners(List<BeanPersistListener> listenerInstances) {
        if (listenerInstances != null) {
            for (BeanPersistListener l : listenerInstances) {
                this.persistListenerInstances.add(l);
                this.beanListenerList.remove(l.getClass());
            }
        }
    }

    public void addServerConfigStartup(List<ServerConfigStartup> startupInstances) {
        if (startupInstances != null) {
            for (ServerConfigStartup l : startupInstances) {
                this.serverConfigStartupInstances.add(l);
                this.serverConfigStartupList.remove(l.getClass());
            }
        }
    }

    public void addChangeLogInstances(ServerConfig serverConfig) {
        this.readAuditPrepare = serverConfig.getReadAuditPrepare();
        this.readAuditLogger = serverConfig.getReadAuditLogger();
        if (this.readAuditPrepare == null && this.readAuditPrepareClass != null) {
            this.readAuditPrepare = (ReadAuditPrepare)this.create(this.readAuditPrepareClass, false);
        }
        if (this.readAuditLogger == null && this.readAuditLoggerClass != null) {
            this.readAuditLogger = (ReadAuditLogger)this.create(this.readAuditLoggerClass, false);
        }
        this.changeLogListener = serverConfig.getChangeLogListener();
        this.changeLogRegister = serverConfig.getChangeLogRegister();
        this.changeLogPrepare = serverConfig.getChangeLogPrepare();
        if (this.changeLogPrepare == null && this.changeLogPrepareClass != null) {
            this.changeLogPrepare = (ChangeLogPrepare)this.create(this.changeLogPrepareClass, false);
        }
        if (this.changeLogListener == null && this.changeLogListenerClass != null) {
            this.changeLogListener = (ChangeLogListener)this.create(this.changeLogListenerClass, false);
        }
        if (this.changeLogRegister == null && this.changeLogRegisterClass != null) {
            this.changeLogRegister = (ChangeLogRegister)this.create(this.changeLogRegisterClass, false);
        }
    }

    private Object create(Class<?> cls, boolean logOnException) {
        try {
            Constructor<?> constructor = cls.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            logger.debug("Ignore/expected - no default constructor", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            if (logOnException) {
                logger.error("Error creating " + cls, (Throwable)e);
                return null;
            }
            throw new IllegalStateException("Error creating " + cls, e);
        }
    }

    private <T> void createAdd(Class<?> cls, List<T> instances) {
        Object newInstance = this.create(cls, true);
        if (newInstance != null) {
            instances.add(newInstance);
        }
    }

    public ChangeLogPrepare getChangeLogPrepare() {
        return this.changeLogPrepare;
    }

    public ChangeLogListener getChangeLogListener() {
        return this.changeLogListener;
    }

    public ChangeLogRegister getChangeLogRegister() {
        return this.changeLogRegister;
    }

    public ReadAuditPrepare getReadAuditPrepare() {
        return this.readAuditPrepare;
    }

    public ReadAuditLogger getReadAuditLogger() {
        return this.readAuditLogger;
    }

    public List<BeanQueryAdapter> getBeanQueryAdapters() {
        for (Class<?> cls : this.beanQueryAdapterList) {
            this.createAdd(cls, this.queryAdapterInstances);
        }
        return this.queryAdapterInstances;
    }

    public List<BeanFindController> getBeanFindControllers() {
        for (Class<?> cls : this.beanFindControllerList) {
            this.createAdd(cls, this.findControllerInstances);
        }
        return this.findControllerInstances;
    }

    public List<BeanPersistListener> getBeanPersistListeners() {
        for (Class<?> cls : this.beanListenerList) {
            this.createAdd(cls, this.persistListenerInstances);
        }
        return this.persistListenerInstances;
    }

    public List<BeanPersistController> getBeanPersistControllers() {
        for (Class<?> cls : this.beanControllerList) {
            this.createAdd(cls, this.persistControllerInstances);
        }
        return this.persistControllerInstances;
    }

    public List<BeanPostLoad> getBeanPostLoaders() {
        for (Class<?> cls : this.beanPostLoadList) {
            this.createAdd(cls, this.beanPostLoadInstances);
        }
        return this.beanPostLoadInstances;
    }

    public List<TransactionEventListener> getTransactionEventListeners() {
        for (Class<?> cls : this.transactionEventListenerList) {
            this.createAdd(cls, this.transactionEventListenerInstances);
        }
        return this.transactionEventListenerInstances;
    }

    public List<Class<?>> getEmbeddables() {
        return this.embeddableList;
    }

    public List<Class<?>> getEntities() {
        return this.entityList;
    }

    public List<Class<?>> getScalarTypes() {
        return this.scalarTypeList;
    }

    public List<Class<?>> getScalarConverters() {
        return this.scalarConverterList;
    }

    public List<Class<?>> getCompoundTypes() {
        return this.compoundTypeList;
    }

    @Override
    public boolean isMatch(Class<?> cls) {
        if (this.isEmbeddable(cls)) {
            this.embeddableList.add(cls);
        } else if (this.isEntity(cls)) {
            this.entityList.add(cls);
        } else {
            return this.isInterestingInterface(cls);
        }
        return true;
    }

    private boolean isInterestingInterface(Class<?> cls) {
        if (Modifier.isAbstract(cls.getModifiers())) {
            return false;
        }
        boolean interesting = false;
        if (BeanPersistController.class.isAssignableFrom(cls)) {
            this.beanControllerList.add(cls);
            interesting = true;
        }
        if (BeanPostLoad.class.isAssignableFrom(cls)) {
            this.beanPostLoadList.add(cls);
            interesting = true;
        }
        if (TransactionEventListener.class.isAssignableFrom(cls)) {
            this.transactionEventListenerList.add(cls);
            interesting = true;
        }
        if (ScalarType.class.isAssignableFrom(cls)) {
            this.scalarTypeList.add(cls);
            interesting = true;
        }
        if (ScalarTypeConverter.class.isAssignableFrom(cls)) {
            this.scalarConverterList.add(cls);
            interesting = true;
        }
        if (CompoundType.class.isAssignableFrom(cls)) {
            this.compoundTypeList.add(cls);
            interesting = true;
        }
        if (BeanFindController.class.isAssignableFrom(cls)) {
            this.beanFindControllerList.add(cls);
            interesting = true;
        }
        if (BeanPersistListener.class.isAssignableFrom(cls)) {
            this.beanListenerList.add(cls);
            interesting = true;
        }
        if (BeanQueryAdapter.class.isAssignableFrom(cls)) {
            this.beanQueryAdapterList.add(cls);
            interesting = true;
        }
        if (ServerConfigStartup.class.isAssignableFrom(cls)) {
            this.serverConfigStartupList.add(cls);
            interesting = true;
        }
        if (ChangeLogListener.class.isAssignableFrom(cls)) {
            this.changeLogListenerClass = cls;
            interesting = true;
        }
        if (ChangeLogRegister.class.isAssignableFrom(cls)) {
            this.changeLogRegisterClass = cls;
            interesting = true;
        }
        if (ChangeLogPrepare.class.isAssignableFrom(cls)) {
            this.changeLogPrepareClass = cls;
            interesting = true;
        }
        if (ReadAuditPrepare.class.isAssignableFrom(cls)) {
            this.readAuditPrepareClass = cls;
            interesting = true;
        }
        if (ReadAuditLogger.class.isAssignableFrom(cls)) {
            this.readAuditLoggerClass = cls;
            interesting = true;
        }
        return interesting;
    }

    private boolean isEntity(Class<?> cls) {
        Entity ann = cls.getAnnotation(Entity.class);
        if (ann != null) {
            return true;
        }
        ann = cls.getAnnotation(Table.class);
        return ann != null;
    }

    private boolean isEmbeddable(Class<?> cls) {
        Embeddable ann = cls.getAnnotation(Embeddable.class);
        return ann != null;
    }
}

