/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.AutoTune;
import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.BeanState;
import com.avaje.ebean.CallableSql;
import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.ExpressionFactory;
import com.avaje.ebean.Filter;
import com.avaje.ebean.FutureIds;
import com.avaje.ebean.FutureList;
import com.avaje.ebean.FutureRowCount;
import com.avaje.ebean.PagedList;
import com.avaje.ebean.PersistenceContextScope;
import com.avaje.ebean.Query;
import com.avaje.ebean.QueryEachConsumer;
import com.avaje.ebean.QueryEachWhileConsumer;
import com.avaje.ebean.QueryIterator;
import com.avaje.ebean.SqlFutureList;
import com.avaje.ebean.SqlQuery;
import com.avaje.ebean.SqlRow;
import com.avaje.ebean.SqlUpdate;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.TransactionCallback;
import com.avaje.ebean.TxCallable;
import com.avaje.ebean.TxIsolation;
import com.avaje.ebean.TxRunnable;
import com.avaje.ebean.TxScope;
import com.avaje.ebean.TxType;
import com.avaje.ebean.Update;
import com.avaje.ebean.ValuePair;
import com.avaje.ebean.Version;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.CallStack;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebean.bean.ObjectGraphNode;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebean.cache.ServerCacheManager;
import com.avaje.ebean.config.EncryptKeyManager;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.dbmigration.DdlGenerator;
import com.avaje.ebean.event.BeanPersistController;
import com.avaje.ebean.event.BeanQueryAdapter;
import com.avaje.ebean.event.readaudit.ReadAuditLogger;
import com.avaje.ebean.event.readaudit.ReadAuditPrepare;
import com.avaje.ebean.meta.MetaInfoManager;
import com.avaje.ebean.plugin.SpiBeanType;
import com.avaje.ebean.plugin.SpiServer;
import com.avaje.ebean.plugin.SpiServerPlugin;
import com.avaje.ebean.text.csv.CsvReader;
import com.avaje.ebean.text.json.JsonContext;
import com.avaje.ebeaninternal.api.LoadBeanRequest;
import com.avaje.ebeaninternal.api.LoadManyRequest;
import com.avaje.ebeaninternal.api.ScopeTrans;
import com.avaje.ebeaninternal.api.ScopedTransaction;
import com.avaje.ebeaninternal.api.SpiBackgroundExecutor;
import com.avaje.ebeaninternal.api.SpiEbeanPlugin;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.api.SpiSqlQuery;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.api.TransactionEventTable;
import com.avaje.ebeaninternal.server.autotune.AutoTuneService;
import com.avaje.ebeaninternal.server.core.CObjectGraphNodeStatistics;
import com.avaje.ebeaninternal.server.core.CallStackFactory;
import com.avaje.ebeaninternal.server.core.DefaultBeanLoader;
import com.avaje.ebeaninternal.server.core.DefaultBeanState;
import com.avaje.ebeaninternal.server.core.DefaultCallStackFactory;
import com.avaje.ebeaninternal.server.core.DefaultCallableSql;
import com.avaje.ebeaninternal.server.core.DefaultMetaInfoManager;
import com.avaje.ebeaninternal.server.core.DefaultSqlUpdate;
import com.avaje.ebeaninternal.server.core.DiffHelp;
import com.avaje.ebeaninternal.server.core.InternalConfiguration;
import com.avaje.ebeaninternal.server.core.Message;
import com.avaje.ebeaninternal.server.core.OrmQueryEngine;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.core.Persister;
import com.avaje.ebeaninternal.server.core.RelationalQueryEngine;
import com.avaje.ebeaninternal.server.core.RelationalQueryRequest;
import com.avaje.ebeaninternal.server.core.SpiOrmQueryRequest;
import com.avaje.ebeaninternal.server.core.TransWrapper;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorManager;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.DNativeQuery;
import com.avaje.ebeaninternal.server.deploy.DeployNamedQuery;
import com.avaje.ebeaninternal.server.deploy.DeployNamedUpdate;
import com.avaje.ebeaninternal.server.deploy.InheritInfo;
import com.avaje.ebeaninternal.server.el.ElFilter;
import com.avaje.ebeaninternal.server.lib.ShutdownManager;
import com.avaje.ebeaninternal.server.query.CQuery;
import com.avaje.ebeaninternal.server.query.CQueryEngine;
import com.avaje.ebeaninternal.server.query.CallableQueryIds;
import com.avaje.ebeaninternal.server.query.CallableQueryList;
import com.avaje.ebeaninternal.server.query.CallableQueryRowCount;
import com.avaje.ebeaninternal.server.query.CallableSqlQueryList;
import com.avaje.ebeaninternal.server.query.LimitOffsetPagedList;
import com.avaje.ebeaninternal.server.query.QueryFutureIds;
import com.avaje.ebeaninternal.server.query.QueryFutureList;
import com.avaje.ebeaninternal.server.query.QueryFutureRowCount;
import com.avaje.ebeaninternal.server.query.SqlQueryFutureList;
import com.avaje.ebeaninternal.server.querydefn.DefaultOrmQuery;
import com.avaje.ebeaninternal.server.querydefn.DefaultOrmUpdate;
import com.avaje.ebeaninternal.server.querydefn.DefaultRelationalQuery;
import com.avaje.ebeaninternal.server.text.csv.TCsvReader;
import com.avaje.ebeaninternal.server.transaction.DefaultPersistenceContext;
import com.avaje.ebeaninternal.server.transaction.RemoteTransactionEvent;
import com.avaje.ebeaninternal.server.transaction.TransactionManager;
import com.avaje.ebeaninternal.server.transaction.TransactionScopeManager;
import com.avaje.ebeaninternal.util.ParamTypeHelper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultServer
implements SpiServer,
SpiEbeanServer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultServer.class);
    private static final int IGNORE_LEADING_ELEMENTS = 5;
    private static final String COM_AVAJE_EBEAN = "com.avaje.ebean";
    private static final String ORG_AVAJE_EBEAN = "org.avaje.ebean";
    private final ServerConfig serverConfig;
    private final String serverName;
    private final DatabasePlatform databasePlatform;
    private final TransactionManager transactionManager;
    private final TransactionScopeManager transactionScopeManager;
    private final CallStackFactory callStackFactory = new DefaultCallStackFactory();
    private final int maxCallStack;
    private final boolean rollbackOnChecked;
    private final Persister persister;
    private final OrmQueryEngine queryEngine;
    private final RelationalQueryEngine relationalQueryEngine;
    private final ServerCacheManager serverCacheManager;
    private final BeanDescriptorManager beanDescriptorManager;
    private final AutoTuneService autoTuneService;
    private final ReadAuditPrepare readAuditPrepare;
    private final ReadAuditLogger readAuditLogger;
    private final CQueryEngine cqueryEngine;
    private final List<SpiServerPlugin> serverPlugins;
    private DdlGenerator ddlGenerator;
    private final ExpressionFactory expressionFactory;
    private final SpiBackgroundExecutor backgroundExecutor;
    private final DefaultBeanLoader beanLoader;
    private final EncryptKeyManager encryptKeyManager;
    private final JsonContext jsonContext;
    private final MetaInfoManager metaInfoManager;
    private final PersistenceContextScope defaultPersistenceContextScope;
    private boolean shutdown;
    private final int lazyLoadBatchSize;
    private final int queryBatchSize;
    private List<SpiEbeanPlugin> ebeanPlugins;
    private final boolean updateAllPropertiesInBatch;
    private final boolean collectQueryOrigins;
    private final boolean collectQueryStatsByNode;
    protected final ConcurrentHashMap<ObjectGraphNode, CObjectGraphNodeStatistics> objectGraphStats;

    public DefaultServer(InternalConfiguration config, ServerCacheManager cache) {
        this.serverConfig = config.getServerConfig();
        this.objectGraphStats = new ConcurrentHashMap();
        this.metaInfoManager = new DefaultMetaInfoManager(this);
        this.serverCacheManager = cache;
        this.databasePlatform = config.getDatabasePlatform();
        this.backgroundExecutor = config.getBackgroundExecutor();
        this.serverName = this.serverConfig.getName();
        this.lazyLoadBatchSize = this.serverConfig.getLazyLoadBatchSize();
        this.queryBatchSize = this.serverConfig.getQueryBatchSize();
        this.cqueryEngine = config.getCQueryEngine();
        this.expressionFactory = config.getExpressionFactory();
        this.encryptKeyManager = this.serverConfig.getEncryptKeyManager();
        this.defaultPersistenceContextScope = this.serverConfig.getPersistenceContextScope();
        this.beanDescriptorManager = config.getBeanDescriptorManager();
        this.beanDescriptorManager.setEbeanServer(this);
        this.updateAllPropertiesInBatch = this.serverConfig.isUpdateAllPropertiesInBatch();
        this.collectQueryOrigins = this.serverConfig.isCollectQueryOrigins();
        this.collectQueryStatsByNode = this.serverConfig.isCollectQueryStatsByNode();
        this.maxCallStack = this.serverConfig.getMaxCallStack();
        this.rollbackOnChecked = this.serverConfig.isTransactionRollbackOnChecked();
        this.transactionManager = config.getTransactionManager();
        this.transactionScopeManager = config.getTransactionScopeManager();
        this.persister = config.createPersister(this);
        this.queryEngine = config.createOrmQueryEngine();
        this.relationalQueryEngine = config.createRelationalQueryEngine();
        this.autoTuneService = config.createAutoTuneService(this);
        this.readAuditPrepare = config.getReadAuditPrepare();
        this.readAuditLogger = config.getReadAuditLogger();
        this.beanLoader = new DefaultBeanLoader(this);
        this.jsonContext = config.createJsonContext(this);
        this.serverPlugins = config.getPlugins();
        this.loadAndInitializePlugins(config.getServerConfig());
        this.configureServerPlugins();
        ShutdownManager.registerEbeanServer(this);
    }

    private void configureServerPlugins() {
        this.autoTuneService.startup();
        for (SpiServerPlugin plugin : this.serverPlugins) {
            plugin.configure(this);
        }
    }

    protected void loadAndInitializePlugins(ServerConfig config) {
        ArrayList<SpiEbeanPlugin> spiPlugins = new ArrayList<SpiEbeanPlugin>();
        for (SpiEbeanPlugin plugin : ServiceLoader.load(SpiEbeanPlugin.class)) {
            spiPlugins.add(plugin);
            plugin.setup(this, config);
            if (!(plugin instanceof DdlGenerator)) continue;
            this.ddlGenerator = (DdlGenerator)plugin;
        }
        if (this.ddlGenerator == null) {
            this.ddlGenerator = new DdlGenerator();
            spiPlugins.add(this.ddlGenerator);
            this.ddlGenerator.setup(this, config);
        }
        this.ebeanPlugins = Collections.unmodifiableList(spiPlugins);
    }

    public List<SpiEbeanPlugin> getSpiEbeanPlugins() {
        return this.ebeanPlugins;
    }

    public void executePlugins(boolean online) {
        for (SpiEbeanPlugin spiEbeanPlugin : this.ebeanPlugins) {
            spiEbeanPlugin.execute(online);
        }
        for (SpiServerPlugin spiServerPlugin : this.serverPlugins) {
            spiServerPlugin.online(online);
        }
    }

    @Override
    public boolean isCollectQueryOrigins() {
        return this.collectQueryOrigins;
    }

    @Override
    public boolean isUpdateAllPropertiesInBatch() {
        return this.updateAllPropertiesInBatch;
    }

    @Override
    public int getLazyLoadBatchSize() {
        return this.lazyLoadBatchSize;
    }

    @Override
    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    @Override
    public DatabasePlatform getDatabasePlatform() {
        return this.databasePlatform;
    }

    @Override
    public MetaInfoManager getMetaInfoManager() {
        return this.metaInfoManager;
    }

    @Override
    public SpiServer getPluginApi() {
        return this;
    }

    @Override
    public BackgroundExecutor getBackgroundExecutor() {
        return this.backgroundExecutor;
    }

    @Override
    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    @Override
    public DdlGenerator getDdlGenerator() {
        return this.ddlGenerator;
    }

    @Override
    public AutoTune getAutoTune() {
        return this.autoTuneService;
    }

    @Override
    public ReadAuditPrepare getReadAuditPrepare() {
        return this.readAuditPrepare;
    }

    @Override
    public ReadAuditLogger getReadAuditLogger() {
        return this.readAuditLogger;
    }

    public void initialise() {
        if (this.encryptKeyManager != null) {
            this.encryptKeyManager.initialise();
        }
        List<BeanDescriptor<?>> list = this.beanDescriptorManager.getBeanDescriptorList();
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).cacheInitialise();
        }
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownManaged() {
        DefaultServer defaultServer = this;
        synchronized (defaultServer) {
            this.shutdownInternal(true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean shutdownDataSource, boolean deregisterDriver) {
        DefaultServer defaultServer = this;
        synchronized (defaultServer) {
            ShutdownManager.unregisterEbeanServer(this);
            this.shutdownInternal(shutdownDataSource, deregisterDriver);
        }
    }

    private void shutdownInternal(boolean shutdownDataSource, boolean deregisterDriver) {
        logger.debug("Shutting down EbeanServer " + this.getName());
        if (this.shutdown) {
            return;
        }
        this.shutdownPlugins();
        this.autoTuneService.shutdown();
        this.backgroundExecutor.shutdown();
        this.transactionManager.shutdown(shutdownDataSource, deregisterDriver);
        this.shutdown = true;
    }

    private void shutdownPlugins() {
        for (SpiServerPlugin plugin : this.serverPlugins) {
            try {
                plugin.shutdown();
            }
            catch (Throwable e) {
                logger.error("Error when shutting down plugin", e);
            }
        }
    }

    @Override
    public String getName() {
        return this.serverName;
    }

    @Override
    public BeanState getBeanState(Object bean) {
        if (bean instanceof EntityBean) {
            return new DefaultBeanState((EntityBean)bean);
        }
        return null;
    }

    @Override
    public void runCacheWarming() {
        List<BeanDescriptor<?>> descList = this.beanDescriptorManager.getBeanDescriptorList();
        for (int i = 0; i < descList.size(); ++i) {
            descList.get(i).runCacheWarming();
        }
    }

    @Override
    public void runCacheWarming(Class<?> beanType) {
        BeanDescriptor<?> desc = this.beanDescriptorManager.getBeanDescriptor(beanType);
        if (desc == null) {
            String msg = "Is " + beanType + " an entity? Could not find a BeanDescriptor";
            throw new PersistenceException(msg);
        }
        desc.runCacheWarming();
    }

    @Override
    public <T> CQuery<T> compileQuery(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> qr = this.createQueryRequest(SpiQuery.Type.SUBQUERY, query, t);
        OrmQueryRequest orm = (OrmQueryRequest)qr;
        return this.cqueryEngine.buildQuery(orm);
    }

    @Override
    public CQueryEngine getQueryEngine() {
        return this.cqueryEngine;
    }

    @Override
    public ServerCacheManager getServerCacheManager() {
        return this.serverCacheManager;
    }

    public void refreshMany(Object parentBean, String propertyName, Transaction t) {
        this.beanLoader.refreshMany(this.checkEntityBean(parentBean), propertyName, t);
    }

    @Override
    public void refreshMany(Object parentBean, String propertyName) {
        this.beanLoader.refreshMany(this.checkEntityBean(parentBean), propertyName);
    }

    @Override
    public void loadMany(LoadManyRequest loadRequest) {
        this.beanLoader.loadMany(loadRequest);
    }

    @Override
    public void loadMany(BeanCollection<?> bc, boolean onlyIds) {
        this.beanLoader.loadMany(bc, onlyIds);
    }

    @Override
    public void refresh(Object bean) {
        this.beanLoader.refresh(this.checkEntityBean(bean));
    }

    @Override
    public void loadBean(LoadBeanRequest loadRequest) {
        this.beanLoader.loadBean(loadRequest);
    }

    @Override
    public void loadBean(EntityBeanIntercept ebi) {
        this.beanLoader.loadBean(ebi);
    }

    @Override
    public Map<String, ValuePair> diff(Object a, Object b) {
        if (a == null) {
            return null;
        }
        BeanDescriptor<?> desc = this.getBeanDescriptor(a.getClass());
        return DiffHelp.diff(a, b, desc);
    }

    @Override
    public void externalModification(TransactionEventTable tableEvent) {
        SpiTransaction t = this.transactionScopeManager.get();
        if (t != null) {
            t.getEvent().add(tableEvent);
        } else {
            this.transactionManager.externalModification(tableEvent);
        }
    }

    @Override
    public void externalModification(String tableName, boolean inserts, boolean updates, boolean deletes) {
        TransactionEventTable evt = new TransactionEventTable();
        evt.add(tableName, inserts, updates, deletes);
        this.externalModification(evt);
    }

    @Override
    public void clearQueryStatistics() {
        for (BeanDescriptor<?> desc : this.getBeanDescriptors()) {
            desc.clearQueryStatistics();
        }
    }

    @Override
    public <T> T createEntityBean(Class<T> type) {
        BeanDescriptor<T> desc = this.getBeanDescriptor(type);
        return (T)desc.createEntityBean();
    }

    @Override
    public <T> T getReference(Class<T> type, Object id) {
        if (id == null) {
            throw new NullPointerException("The id is null");
        }
        BeanDescriptor<T> desc = this.getBeanDescriptor(type);
        id = desc.convertId(id);
        Object ref = null;
        PersistenceContext ctx = null;
        SpiTransaction t = this.transactionScopeManager.get();
        if (t != null) {
            ctx = t.getPersistenceContext();
            ref = ctx.get(type, id);
        }
        if (ref == null) {
            InheritInfo inheritInfo = desc.getInheritInfo();
            if (inheritInfo != null) {
                BeanProperty idProp = desc.getIdProperty();
                if (idProp == null) {
                    throw new PersistenceException("No ID properties for this type? " + desc);
                }
                Query<T> query = this.createQuery(type);
                query.select(idProp.getName()).setId(id);
                ref = query.findUnique();
            } else {
                ref = desc.createReference(null, id);
            }
            if (ctx != null && ref instanceof EntityBean) {
                ctx.put(id, ref);
            }
        }
        return (T)ref;
    }

    @Override
    public void register(TransactionCallback transactionCallback) {
        Transaction transaction = this.currentTransaction();
        if (transaction == null) {
            throw new PersistenceException("Not currently active transaction when trying to register transactionCallback");
        }
        transaction.register(transactionCallback);
    }

    @Override
    public Transaction createTransaction() {
        return this.transactionManager.createTransaction(true, -1);
    }

    @Override
    public Transaction createTransaction(TxIsolation isolation) {
        return this.transactionManager.createTransaction(true, isolation.getLevel());
    }

    @Override
    public <T> T execute(TxCallable<T> c) {
        return this.execute(null, c);
    }

    @Override
    public <T> T execute(TxScope scope, TxCallable<T> c) {
        ScopeTrans scopeTrans = this.createScopeTrans(scope);
        try {
            T t = c.call();
            return t;
        }
        catch (Error e) {
            throw scopeTrans.caughtError(e);
        }
        catch (RuntimeException e) {
            throw scopeTrans.caughtThrowable(e);
        }
        finally {
            scopeTrans.onFinally();
        }
    }

    @Override
    public void execute(TxRunnable r) {
        this.execute(null, r);
    }

    @Override
    public void execute(TxScope scope, TxRunnable r) {
        ScopeTrans scopeTrans = this.createScopeTrans(scope);
        try {
            r.run();
        }
        catch (Error e) {
            throw scopeTrans.caughtError(e);
        }
        catch (RuntimeException e) {
            throw scopeTrans.caughtThrowable(e);
        }
        finally {
            scopeTrans.onFinally();
        }
    }

    private boolean createNewTransaction(SpiTransaction t, TxScope scope) {
        TxType type = scope.getType();
        switch (type) {
            case REQUIRED: {
                return t == null;
            }
            case REQUIRES_NEW: {
                return true;
            }
            case MANDATORY: {
                if (t == null) {
                    throw new PersistenceException("Transaction missing when MANDATORY");
                }
                return true;
            }
            case NEVER: {
                if (t != null) {
                    throw new PersistenceException("Transaction exists for Transactional NEVER");
                }
                return false;
            }
            case SUPPORTS: {
                return false;
            }
            case NOT_SUPPORTED: {
                throw new RuntimeException("NOT_SUPPORTED should already be handled?");
            }
        }
        throw new RuntimeException("Should never get here?");
    }

    @Override
    public ScopeTrans createScopeTrans(TxScope txScope) {
        boolean newTransaction;
        if (txScope == null) {
            txScope = new TxScope();
        }
        SpiTransaction suspended = null;
        SpiTransaction t = this.transactionScopeManager.get();
        if (txScope.getType().equals((Object)TxType.NOT_SUPPORTED)) {
            newTransaction = false;
            suspended = t;
            t = null;
        } else {
            newTransaction = this.createNewTransaction(t, txScope);
            if (newTransaction) {
                suspended = t;
                int isoLevel = -1;
                TxIsolation isolation = txScope.getIsolation();
                if (isolation != null) {
                    isoLevel = isolation.getLevel();
                }
                t = this.transactionManager.createTransaction(true, isoLevel);
            }
        }
        this.transactionScopeManager.replace(t);
        return new ScopeTrans(this.rollbackOnChecked, newTransaction, t, txScope, suspended, this.transactionScopeManager);
    }

    @Override
    public SpiTransaction getCurrentServerTransaction() {
        return this.transactionScopeManager.get();
    }

    @Override
    public Transaction beginTransaction() {
        return this.beginTransaction(TxScope.required());
    }

    @Override
    public Transaction beginTransaction(TxScope scope) {
        ScopeTrans scopeTrans = this.createScopeTrans(scope);
        return new ScopedTransaction(scopeTrans);
    }

    @Override
    public Transaction beginTransaction(TxIsolation isolation) {
        SpiTransaction t = this.transactionManager.createTransaction(true, isolation.getLevel());
        this.transactionScopeManager.set(t);
        return t;
    }

    @Override
    public Transaction currentTransaction() {
        return this.transactionScopeManager.get();
    }

    @Override
    public void commitTransaction() {
        this.transactionScopeManager.commit();
    }

    @Override
    public void rollbackTransaction() {
        this.transactionScopeManager.rollback();
    }

    @Override
    public void endTransaction() {
        this.transactionScopeManager.end();
    }

    @Override
    public Object nextId(Class<?> beanType) {
        BeanDescriptor<?> desc = this.getBeanDescriptor(beanType);
        return desc.nextId(null);
    }

    @Override
    public <T> void sort(List<T> list, String sortByClause) {
        if (list == null) {
            throw new NullPointerException("list is null");
        }
        if (sortByClause == null) {
            throw new NullPointerException("sortByClause is null");
        }
        if (list.size() == 0) {
            return;
        }
        Class<?> beanType = list.get(0).getClass();
        BeanDescriptor<?> beanDescriptor = this.getBeanDescriptor(beanType);
        if (beanDescriptor == null) {
            String m = "BeanDescriptor not found, is [" + beanType + "] an entity bean?";
            throw new PersistenceException(m);
        }
        beanDescriptor.sort(list, sortByClause);
    }

    @Override
    public <T> Query<T> createQuery(Class<T> beanType) throws PersistenceException {
        return this.createQuery(beanType, null);
    }

    @Override
    public <T> Query<T> createNamedQuery(Class<T> beanType, String namedQuery) throws PersistenceException {
        BeanDescriptor<T> desc = this.getBeanDescriptor(beanType);
        if (desc == null) {
            throw new PersistenceException("Is " + beanType.getName() + " an Entity Bean? BeanDescriptor not found?");
        }
        DeployNamedQuery deployQuery = desc.getNamedQuery(namedQuery);
        if (deployQuery == null) {
            throw new PersistenceException("named query " + namedQuery + " was not found for " + desc.getFullName());
        }
        return new DefaultOrmQuery<T>(beanType, (EbeanServer)this, this.expressionFactory, deployQuery);
    }

    @Override
    public <T> Filter<T> filter(Class<T> beanType) {
        BeanDescriptor<T> desc = this.getBeanDescriptor(beanType);
        if (desc == null) {
            String m = beanType.getName() + " is NOT an Entity Bean registered with this server?";
            throw new PersistenceException(m);
        }
        return new ElFilter<T>(desc);
    }

    @Override
    public <T> CsvReader<T> createCsvReader(Class<T> beanType) {
        BeanDescriptor<T> descriptor = this.getBeanDescriptor(beanType);
        if (descriptor == null) {
            throw new NullPointerException("BeanDescriptor for " + beanType.getName() + " not found");
        }
        return new TCsvReader<T>(this, descriptor);
    }

    @Override
    public <T> Query<T> find(Class<T> beanType) {
        return this.createQuery(beanType);
    }

    @Override
    public <T> Query<T> createQuery(Class<T> beanType, String query) {
        BeanDescriptor<T> desc = this.getBeanDescriptor(beanType);
        if (desc == null) {
            String m = beanType.getName() + " is NOT an Entity Bean registered with this server?";
            throw new PersistenceException(m);
        }
        switch (desc.getEntityType()) {
            case SQL: {
                if (query != null) {
                    throw new PersistenceException("You must used Named queries for this Entity " + desc.getFullName());
                }
                DeployNamedQuery defaultSqlSelect = desc.getNamedQuery("default");
                return new DefaultOrmQuery<T>(beanType, (EbeanServer)this, this.expressionFactory, defaultSqlSelect);
            }
        }
        return new DefaultOrmQuery<T>(beanType, (EbeanServer)this, this.expressionFactory, query);
    }

    @Override
    public <T> Update<T> createNamedUpdate(Class<T> beanType, String namedUpdate) {
        BeanDescriptor<T> desc = this.getBeanDescriptor(beanType);
        if (desc == null) {
            String m = beanType.getName() + " is NOT an Entity Bean registered with this server?";
            throw new PersistenceException(m);
        }
        DeployNamedUpdate deployUpdate = desc.getNamedUpdate(namedUpdate);
        if (deployUpdate == null) {
            throw new PersistenceException("named update " + namedUpdate + " was not found for " + desc.getFullName());
        }
        return new DefaultOrmUpdate(beanType, (EbeanServer)this, desc.getBaseTable(), deployUpdate);
    }

    @Override
    public <T> Update<T> createUpdate(Class<T> beanType, String ormUpdate) {
        BeanDescriptor<T> desc = this.getBeanDescriptor(beanType);
        if (desc == null) {
            String m = beanType.getName() + " is NOT an Entity Bean registered with this server?";
            throw new PersistenceException(m);
        }
        return new DefaultOrmUpdate(beanType, (EbeanServer)this, desc.getBaseTable(), ormUpdate);
    }

    @Override
    public SqlQuery createSqlQuery(String sql) {
        return new DefaultRelationalQuery(this, sql);
    }

    @Override
    public SqlQuery createNamedSqlQuery(String namedQuery) {
        DNativeQuery nq = this.beanDescriptorManager.getNativeQuery(namedQuery);
        if (nq == null) {
            throw new PersistenceException("SqlQuery " + namedQuery + " not found.");
        }
        return new DefaultRelationalQuery(this, nq.getQuery());
    }

    @Override
    public SqlUpdate createSqlUpdate(String sql) {
        return new DefaultSqlUpdate(this, sql);
    }

    @Override
    public CallableSql createCallableSql(String sql) {
        return new DefaultCallableSql(this, sql);
    }

    @Override
    public SqlUpdate createNamedSqlUpdate(String namedQuery) {
        DNativeQuery nq = this.beanDescriptorManager.getNativeQuery(namedQuery);
        if (nq == null) {
            throw new PersistenceException("SqlUpdate " + namedQuery + " not found.");
        }
        return new DefaultSqlUpdate(this, nq.getQuery());
    }

    @Override
    public <T> T find(Class<T> beanType, Object uid) {
        return this.find(beanType, uid, null);
    }

    @Override
    public <T> T find(Class<T> beanType, Object id, Transaction t) {
        if (id == null) {
            throw new NullPointerException("The id is null");
        }
        Query<T> query = this.createQuery(beanType).setId(id);
        return this.findId(query, t);
    }

    private <T> SpiOrmQueryRequest<T> createQueryRequest(SpiQuery.Type type, Query<T> query, Transaction t) {
        SpiQuery spiQuery = (SpiQuery)query;
        spiQuery.setType(type);
        BeanDescriptor desc = this.beanDescriptorManager.getBeanDescriptor(spiQuery.getBeanType());
        spiQuery.setBeanDescriptor(desc);
        return this.createQueryRequest(desc, spiQuery, t);
    }

    @Override
    public <T> SpiOrmQueryRequest<T> createQueryRequest(BeanDescriptor<T> desc, SpiQuery<T> query, Transaction t) {
        if (desc.isAutoTunable() && !query.isSqlSelect() && !this.autoTuneService.tuneQuery(query)) {
            query.setDefaultSelectClause();
        }
        if (query.selectAllForLazyLoadProperty() && logger.isDebugEnabled()) {
            logger.debug("Using selectAllForLazyLoadProperty");
        }
        if (query.getParentNode() == null) {
            query.setOrigin(this.createCallStack());
        }
        if (query.initManyWhereJoins()) {
            query.setSqlDistinct(true);
        }
        boolean allowOneManyFetch = true;
        if (SpiQuery.Mode.LAZYLOAD_MANY.equals((Object)query.getMode())) {
            allowOneManyFetch = false;
        } else if (query.hasMaxRowsOrFirstRow() && !query.isRawSql() && !query.isSqlSelect()) {
            allowOneManyFetch = false;
        }
        query.convertManyFetchJoinsToQueryJoins(allowOneManyFetch, this.queryBatchSize);
        SpiTransaction serverTrans = (SpiTransaction)t;
        OrmQueryRequest<T> request = new OrmQueryRequest<T>(this, this.queryEngine, query, desc, serverTrans);
        BeanQueryAdapter queryAdapter = desc.getQueryAdapter();
        if (queryAdapter != null) {
            queryAdapter.preQuery(request);
        }
        request.calculateQueryPlanHash();
        return request;
    }

    private <T> T findIdCheckPersistenceContextAndCache(Transaction transaction, BeanDescriptor<T> beanDescriptor, SpiQuery<T> query) {
        PersistenceContext.WithOption o;
        SpiTransaction t = (SpiTransaction)transaction;
        if (t == null) {
            t = this.getCurrentServerTransaction();
        }
        PersistenceContext context = null;
        if (t != null && this.useTransactionPersistenceContext(query) && (context = t.getPersistenceContext()) != null && (o = context.getWithOption(beanDescriptor.getBeanType(), query.getId())) != null) {
            if (o.isDeleted()) {
                return null;
            }
            return (T)o.getBean();
        }
        if (!beanDescriptor.calculateUseCache(query.isUseBeanCache())) {
            return null;
        }
        return beanDescriptor.cacheBeanGet(query, context);
    }

    private <T> boolean useTransactionPersistenceContext(SpiQuery<T> query) {
        return PersistenceContextScope.TRANSACTION.equals((Object)this.getPersistenceContextScope(query));
    }

    @Override
    public PersistenceContextScope getPersistenceContextScope(SpiQuery<?> query) {
        PersistenceContextScope scope = query.getPersistenceContextScope();
        return scope != null ? scope : this.defaultPersistenceContextScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T findId(Query<T> query, Transaction t) {
        Object bean;
        SpiQuery spiQuery = (SpiQuery)query;
        spiQuery.setType(SpiQuery.Type.BEAN);
        BeanDescriptor desc = this.beanDescriptorManager.getBeanDescriptor(spiQuery.getBeanType());
        spiQuery.setBeanDescriptor(desc);
        if (SpiQuery.Mode.NORMAL.equals((Object)spiQuery.getMode()) && !spiQuery.isLoadBeanCache() && (bean = this.findIdCheckPersistenceContextAndCache(t, desc, spiQuery)) != null) {
            return bean;
        }
        SpiOrmQueryRequest request = this.createQueryRequest(desc, spiQuery, t);
        try {
            request.initTransIfRequired();
            Object object = request.findId();
            return (T)object;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    @Override
    public <T> T findUnique(Query<T> query, Transaction t) {
        Object id = query.getId();
        if (id != null) {
            return this.findId(query, t);
        }
        BeanDescriptor<T> desc = this.beanDescriptorManager.getBeanDescriptor(query.getBeanType());
        T bean = desc.cacheNaturalKeyLookup((SpiQuery)query, (SpiTransaction)t);
        if (bean != null) {
            return bean;
        }
        List<T> list = this.findList(query, t);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw new PersistenceException("Unique expecting 0 or 1 rows but got [" + list.size() + "]");
        }
        return list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Set<T> findSet(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.SET, query, t);
        BeanCollection<T> result = request.getFromQueryCache();
        if (result != null) {
            return (Set)((Object)result);
        }
        try {
            request.initTransIfRequired();
            Set<?> set = request.findSet();
            return set;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<?, T> findMap(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.MAP, query, t);
        BeanCollection<T> result = request.getFromQueryCache();
        if (result != null) {
            return (Map)((Object)result);
        }
        try {
            request.initTransIfRequired();
            Map<?, ?> map = request.findMap();
            return map;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    @Override
    public <T> int findRowCount(Query<T> query, Transaction t) {
        SpiQuery copy = ((SpiQuery)query).copy();
        return this.findRowCountWithCopy(copy, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int findRowCountWithCopy(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.ROWCOUNT, query, t);
        try {
            request.initTransIfRequired();
            int n = request.findRowCount();
            return n;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    @Override
    public <T> List<Object> findIds(Query<T> query, Transaction t) {
        SpiQuery copy = ((SpiQuery)query).copy();
        return this.findIdsWithCopy(copy, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Object> findIdsWithCopy(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.ID_LIST, query, t);
        try {
            request.initTransIfRequired();
            List<Object> list = request.findIds();
            return list;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int delete(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.DELETE, query, t);
        try {
            request.initTransIfRequired();
            request.markNotQueryOnly();
            int n = request.delete();
            return n;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    @Override
    public <T> FutureRowCount<T> findFutureRowCount(Query<T> q, Transaction t) {
        SpiQuery copy = ((SpiQuery)q).copy();
        copy.setFutureFetch(true);
        Transaction newTxn = this.createTransaction();
        CallableQueryRowCount call = new CallableQueryRowCount(this, copy, newTxn);
        QueryFutureRowCount queryFuture = new QueryFutureRowCount(call);
        this.backgroundExecutor.execute(queryFuture.getFutureTask());
        return queryFuture;
    }

    @Override
    public <T> FutureIds<T> findFutureIds(Query<T> query, Transaction t) {
        SpiQuery copy = ((SpiQuery)query).copy();
        copy.setFutureFetch(true);
        List<Object> idList = Collections.synchronizedList(new ArrayList());
        copy.setIdList(idList);
        Transaction newTxn = this.createTransaction();
        CallableQueryIds call = new CallableQueryIds(this, copy, newTxn);
        QueryFutureIds queryFuture = new QueryFutureIds(call);
        this.backgroundExecutor.execute(queryFuture.getFutureTask());
        return queryFuture;
    }

    @Override
    public <T> FutureList<T> findFutureList(Query<T> query, Transaction t) {
        SpiQuery spiQuery = (SpiQuery)query;
        spiQuery.setFutureFetch(true);
        spiQuery.setPersistenceContext(new DefaultPersistenceContext());
        if (!spiQuery.isDisableReadAudit()) {
            BeanDescriptor desc = this.beanDescriptorManager.getBeanDescriptor(spiQuery.getBeanType());
            desc.readAuditFutureList(spiQuery);
        }
        Transaction newTxn = this.createTransaction();
        CallableQueryList call = new CallableQueryList(this, spiQuery, newTxn);
        QueryFutureList queryFuture = new QueryFutureList(call);
        this.backgroundExecutor.execute(queryFuture.getFutureTask());
        return queryFuture;
    }

    @Override
    public <T> PagedList<T> findPagedList(Query<T> query, Transaction transaction, int pageIndex, int pageSize) {
        return new LimitOffsetPagedList(this, (SpiQuery)query, pageIndex, pageSize);
    }

    @Override
    public <T> void findEach(Query<T> query, QueryEachConsumer<T> consumer, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.ITERATE, query, t);
        request.initTransIfRequired();
        request.findEach(consumer);
    }

    @Override
    public <T> void findEachWhile(Query<T> query, QueryEachWhileConsumer<T> consumer, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.ITERATE, query, t);
        request.initTransIfRequired();
        request.findEachWhile(consumer);
    }

    @Override
    public <T> QueryIterator<T> findIterate(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.ITERATE, query, t);
        try {
            request.initTransIfRequired();
            return request.findIterate();
        }
        catch (RuntimeException ex) {
            request.endTransIfRequired();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Version<T>> findVersions(Query<T> query, Transaction transaction) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.LIST, query, transaction);
        try {
            request.initTransIfRequired();
            List<Version<T>> list = request.findVersions();
            return list;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> findList(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.LIST, query, t);
        BeanCollection<T> result = request.getFromQueryCache();
        if (result != null) {
            return (List)((Object)result);
        }
        try {
            request.initTransIfRequired();
            List<T> list = request.findList();
            return list;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    @Override
    public SqlRow findUnique(SqlQuery query, Transaction t) {
        List<SqlRow> list = this.findList(query, t);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            String m = "Unique expecting 0 or 1 rows but got [" + list.size() + "]";
            throw new PersistenceException(m);
        }
        return list.get(0);
    }

    @Override
    public SqlFutureList findFutureList(SqlQuery query, Transaction t) {
        SpiSqlQuery spiQuery = (SpiSqlQuery)query;
        spiQuery.setFutureFetch(true);
        Transaction newTxn = this.createTransaction();
        CallableSqlQueryList call = new CallableSqlQueryList(this, query, newTxn);
        FutureTask<List<SqlRow>> futureTask = new FutureTask<List<SqlRow>>(call);
        this.backgroundExecutor.execute(futureTask);
        return new SqlQueryFutureList(query, futureTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SqlRow> findList(SqlQuery query, Transaction t) {
        RelationalQueryRequest request = new RelationalQueryRequest(this, this.relationalQueryEngine, query, t);
        try {
            request.initTransIfRequired();
            List<SqlRow> list = request.findList();
            return list;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SqlRow> findSet(SqlQuery query, Transaction t) {
        RelationalQueryRequest request = new RelationalQueryRequest(this, this.relationalQueryEngine, query, t);
        try {
            request.initTransIfRequired();
            Set<SqlRow> set = request.findSet();
            return set;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<?, SqlRow> findMap(SqlQuery query, Transaction t) {
        RelationalQueryRequest request = new RelationalQueryRequest(this, this.relationalQueryEngine, query, t);
        try {
            request.initTransIfRequired();
            Map<?, SqlRow> map = request.findMap();
            return map;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    @Override
    public void save(Object bean) {
        this.save(bean, null);
    }

    @Override
    public void save(Object bean, Transaction t) {
        this.persister.save(this.checkEntityBean(bean), t);
    }

    @Override
    public void markAsDirty(Object bean) {
        if (!(bean instanceof EntityBean)) {
            throw new IllegalArgumentException("This bean is not an EntityBean?");
        }
        ((EntityBean)bean)._ebean_getIntercept().setDirty(true);
    }

    @Override
    public void update(Object bean) {
        this.update(bean, null);
    }

    @Override
    public void update(Object bean, Transaction t) {
        this.persister.update(this.checkEntityBean(bean), t);
    }

    @Override
    public void update(Object bean, Transaction t, boolean deleteMissingChildren) {
        this.persister.update(this.checkEntityBean(bean), t, deleteMissingChildren);
    }

    @Override
    public void updateAll(Collection<?> beans) throws OptimisticLockException {
        this.updateAll(beans, null);
    }

    @Override
    public void updateAll(Collection<?> beans, Transaction t) {
        if (beans == null || beans.isEmpty()) {
            return;
        }
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            SpiTransaction trans = wrap.transaction;
            for (Object bean : beans) {
                this.update(this.checkEntityBean(bean), trans);
            }
            wrap.commitIfCreated();
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public void insert(Object bean) {
        this.insert(bean, null);
    }

    @Override
    public void insert(Object bean, Transaction t) {
        this.persister.insert(this.checkEntityBean(bean), t);
    }

    @Override
    public void insertAll(Collection<?> beans) {
        this.insertAll(beans, null);
    }

    @Override
    public void insertAll(Collection<?> beans, Transaction t) {
        if (beans == null || beans.isEmpty()) {
            return;
        }
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            SpiTransaction trans = wrap.transaction;
            for (Object bean : beans) {
                this.persister.insert(this.checkEntityBean(bean), trans);
            }
            wrap.commitIfCreated();
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    private EntityBean checkEntityBean(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException(Message.msg("bean.isnull"));
        }
        if (!(bean instanceof EntityBean)) {
            throw new IllegalArgumentException("Was expecting an EntityBean but got a " + bean.getClass());
        }
        return (EntityBean)bean;
    }

    @Override
    public int deleteManyToManyAssociations(Object ownerBean, String propertyName) {
        return this.deleteManyToManyAssociations(ownerBean, propertyName, null);
    }

    @Override
    public int deleteManyToManyAssociations(Object ownerBean, String propertyName, Transaction t) {
        EntityBean owner = this.checkEntityBean(ownerBean);
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            SpiTransaction trans = wrap.transaction;
            int rc = this.persister.deleteManyToManyAssociations(owner, propertyName, trans);
            wrap.commitIfCreated();
            return rc;
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public void saveManyToManyAssociations(Object ownerBean, String propertyName) {
        this.saveManyToManyAssociations(ownerBean, propertyName, null);
    }

    @Override
    public void saveManyToManyAssociations(Object ownerBean, String propertyName, Transaction t) {
        EntityBean owner = this.checkEntityBean(ownerBean);
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            SpiTransaction trans = wrap.transaction;
            this.persister.saveManyToManyAssociations(owner, propertyName, trans);
            wrap.commitIfCreated();
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public void saveAssociation(Object ownerBean, String propertyName) {
        this.saveAssociation(ownerBean, propertyName, null);
    }

    @Override
    public void saveAssociation(Object ownerBean, String propertyName, Transaction t) {
        EntityBean owner = this.checkEntityBean(ownerBean);
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            SpiTransaction trans = wrap.transaction;
            this.persister.saveAssociation(owner, propertyName, trans);
            wrap.commitIfCreated();
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public int saveAll(Collection<?> beans, Transaction transaction) throws OptimisticLockException {
        return this.saveAllInternal(beans.iterator(), transaction);
    }

    @Override
    public int saveAll(Collection<?> beans) throws OptimisticLockException {
        return this.saveAllInternal(beans.iterator(), null);
    }

    public int saveAllInternal(Iterator<?> it, Transaction t) {
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            wrap.batchEscalateOnCollection();
            SpiTransaction trans = wrap.transaction;
            int saveCount = 0;
            while (it.hasNext()) {
                EntityBean bean = this.checkEntityBean(it.next());
                this.persister.save(bean, trans);
                ++saveCount;
            }
            wrap.commitIfCreated();
            wrap.flushBatchOnCollection();
            return saveCount;
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public int delete(Class<?> beanType, Object id) {
        return this.delete(beanType, id, null);
    }

    @Override
    public int delete(Class<?> beanType, Object id, Transaction t) {
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            SpiTransaction trans = wrap.transaction;
            int rowCount = this.persister.delete(beanType, id, trans);
            wrap.commitIfCreated();
            return rowCount;
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public void deleteAll(Class<?> beanType, Collection<?> ids) {
        this.deleteAll(beanType, ids, null);
    }

    @Override
    public void deleteAll(Class<?> beanType, Collection<?> ids, Transaction t) {
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            SpiTransaction trans = wrap.transaction;
            this.persister.deleteMany(beanType, ids, trans);
            wrap.commitIfCreated();
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public void delete(Object bean) {
        this.delete(bean, null);
    }

    @Override
    public void delete(Object bean, Transaction t) {
        this.persister.delete(this.checkEntityBean(bean), t);
    }

    @Override
    public int deleteAll(Collection<?> beans) {
        return this.deleteAllInternal(beans.iterator(), null);
    }

    @Override
    public int deleteAll(Collection<?> beans, Transaction t) {
        return this.deleteAllInternal(beans.iterator(), t);
    }

    private int deleteAllInternal(Iterator<?> it, Transaction t) {
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            wrap.batchEscalateOnCollection();
            SpiTransaction trans = wrap.transaction;
            int deleteCount = 0;
            while (it.hasNext()) {
                EntityBean bean = this.checkEntityBean(it.next());
                this.persister.delete(bean, trans);
                ++deleteCount;
            }
            wrap.commitIfCreated();
            wrap.flushBatchOnCollection();
            return deleteCount;
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public int execute(CallableSql callSql, Transaction t) {
        return this.persister.executeCallable(callSql, t);
    }

    @Override
    public int execute(CallableSql callSql) {
        return this.execute(callSql, null);
    }

    @Override
    public int execute(SqlUpdate updSql, Transaction t) {
        return this.persister.executeSqlUpdate(updSql, t);
    }

    @Override
    public int execute(SqlUpdate updSql) {
        return this.execute(updSql, null);
    }

    @Override
    public int execute(Update<?> update, Transaction t) {
        return this.persister.executeOrmUpdate(update, t);
    }

    @Override
    public int execute(Update<?> update) {
        return this.execute(update, null);
    }

    @Override
    public List<BeanDescriptor<?>> getBeanDescriptors() {
        return this.beanDescriptorManager.getBeanDescriptorList();
    }

    public void register(BeanPersistController c) {
        List<BeanDescriptor<?>> list = this.beanDescriptorManager.getBeanDescriptorList();
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).register(c);
        }
    }

    public void deregister(BeanPersistController c) {
        List<BeanDescriptor<?>> list = this.beanDescriptorManager.getBeanDescriptorList();
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).deregister(c);
        }
    }

    @Override
    public boolean isSupportedType(Type genericType) {
        ParamTypeHelper.TypeInfo typeInfo = ParamTypeHelper.getTypeInfo(genericType);
        return typeInfo != null && this.getBeanDescriptor(typeInfo.getBeanType()) != null;
    }

    @Override
    public Object getBeanId(Object bean) {
        EntityBean eb = this.checkEntityBean(bean);
        BeanDescriptor<?> desc = this.getBeanDescriptor(bean.getClass());
        if (desc == null) {
            String m = bean.getClass().getName() + " is NOT an Entity Bean registered with this server?";
            throw new PersistenceException(m);
        }
        return desc.getId(eb);
    }

    @Override
    public <T> BeanDescriptor<T> getBeanDescriptor(Class<T> beanClass) {
        return this.beanDescriptorManager.getBeanDescriptor(beanClass);
    }

    @Override
    public List<BeanDescriptor<?>> getBeanDescriptors(String tableName) {
        return this.beanDescriptorManager.getBeanDescriptors(tableName);
    }

    @Override
    public List<? extends SpiBeanType<?>> getBeanTypes() {
        return this.getBeanDescriptors();
    }

    @Override
    public List<? extends SpiBeanType<?>> getBeanTypes(String tableName) {
        return this.beanDescriptorManager.getBeanTypes(tableName);
    }

    @Override
    public <T> SpiBeanType<T> getBeanType(Class<T> beanType) {
        return this.getBeanDescriptor(beanType);
    }

    @Override
    public BeanDescriptor<?> getBeanDescriptorById(String beanClassName) {
        return this.beanDescriptorManager.getBeanDescriptorByClassName(beanClassName);
    }

    @Override
    public void remoteTransactionEvent(RemoteTransactionEvent event) {
        this.transactionManager.remoteTransactionEvent(event);
    }

    TransWrapper initTransIfRequired(Transaction t) {
        if (t != null) {
            return new TransWrapper((SpiTransaction)t, false);
        }
        boolean wasCreated = false;
        SpiTransaction trans = this.transactionScopeManager.get();
        if (trans == null) {
            trans = this.transactionManager.createTransaction(false, -1);
            wasCreated = true;
        }
        return new TransWrapper(trans, wasCreated);
    }

    @Override
    public SpiTransaction createServerTransaction(boolean isExplicit, int isolationLevel) {
        return this.transactionManager.createTransaction(isExplicit, isolationLevel);
    }

    @Override
    public SpiTransaction createQueryTransaction() {
        return this.transactionManager.createQueryTransaction();
    }

    @Override
    public CallStack createCallStack() {
        int startIndex;
        Object[] stackTrace = Thread.currentThread().getStackTrace();
        for (startIndex = 5; startIndex < stackTrace.length && stackTrace[startIndex].getClassName().startsWith(COM_AVAJE_EBEAN); ++startIndex) {
        }
        while (startIndex < stackTrace.length && stackTrace[startIndex].getClassName().startsWith(ORG_AVAJE_EBEAN)) {
            ++startIndex;
        }
        int stackLength = stackTrace.length - startIndex;
        if (stackLength > this.maxCallStack) {
            stackLength = this.maxCallStack;
        }
        StackTraceElement[] finalTrace = new StackTraceElement[stackLength];
        System.arraycopy(stackTrace, startIndex, finalTrace, 0, stackLength);
        if (stackLength < 1) {
            throw new RuntimeException("StackTraceElement size 0?  stack: " + Arrays.toString(stackTrace));
        }
        return this.callStackFactory.createCallStack(finalTrace);
    }

    @Override
    public JsonContext json() {
        return this.jsonContext;
    }

    @Override
    public void collectQueryStats(ObjectGraphNode node, long loadedBeanCount, long timeMicros) {
        if (this.collectQueryStatsByNode) {
            CObjectGraphNodeStatistics nodeStatistics = this.objectGraphStats.get(node);
            if (nodeStatistics == null) {
                nodeStatistics = new CObjectGraphNodeStatistics(node);
                this.objectGraphStats.put(node, nodeStatistics);
            }
            nodeStatistics.add(loadedBeanCount, timeMicros);
        }
    }
}

