/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.core.JsonExpressionHandler;
import com.avaje.ebeaninternal.server.expression.Op;

public class PostgresJsonExpression
implements JsonExpressionHandler {
    @Override
    public void addSql(SpiExpressionRequest request, String propName, String path, Op operator, Object value) {
        StringBuilder sb = new StringBuilder(50);
        String[] paths = path.split("\\.");
        if (paths.length == 1) {
            sb.append("(").append(propName).append(" ->> '").append(path).append("')");
        } else {
            sb.append("(").append(propName).append(" #>> '{");
            for (int i = 0; i < paths.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(paths[i]);
            }
            sb.append("}')");
        }
        request.append(this.castType(sb.toString(), value));
        request.append(operator.bind());
    }

    private String castType(String expression, Object value) {
        if (value == null) {
            return expression;
        }
        if (this.isIntegerType(value)) {
            return expression + "::INTEGER";
        }
        if (this.isNumberType(value)) {
            return expression + "::DECIMAL";
        }
        if (this.isBooleanType(value)) {
            return expression + "::BOOLEAN";
        }
        return expression;
    }

    private boolean isBooleanType(Object value) {
        return value instanceof Boolean;
    }

    private boolean isIntegerType(Object value) {
        return value instanceof Integer || value instanceof Long;
    }

    private boolean isNumberType(Object value) {
        return value instanceof Number;
    }
}

