/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.OrderBy;
import com.avaje.ebean.SqlUpdate;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.ValuePair;
import com.avaje.ebean.annotation.ConcurrencyMode;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebean.config.EncryptKey;
import com.avaje.ebean.config.dbplatform.IdGenerator;
import com.avaje.ebean.config.dbplatform.IdType;
import com.avaje.ebean.event.BeanFindController;
import com.avaje.ebean.event.BeanPersistController;
import com.avaje.ebean.event.BeanPersistListener;
import com.avaje.ebean.event.BeanPostLoad;
import com.avaje.ebean.event.BeanQueryAdapter;
import com.avaje.ebean.event.changelog.BeanChange;
import com.avaje.ebean.event.changelog.ChangeLogFilter;
import com.avaje.ebean.event.changelog.ChangeType;
import com.avaje.ebean.event.readaudit.ReadAuditLogger;
import com.avaje.ebean.event.readaudit.ReadAuditPrepare;
import com.avaje.ebean.event.readaudit.ReadEvent;
import com.avaje.ebean.meta.MetaBeanInfo;
import com.avaje.ebean.meta.MetaQueryPlanStatistic;
import com.avaje.ebean.plugin.SpiBeanType;
import com.avaje.ebeaninternal.api.HashQueryPlan;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.api.SpiUpdatePlan;
import com.avaje.ebeaninternal.api.TransactionEventTable;
import com.avaje.ebeaninternal.server.cache.CachedBeanData;
import com.avaje.ebeaninternal.server.core.CacheOptions;
import com.avaje.ebeaninternal.server.core.DefaultSqlUpdate;
import com.avaje.ebeaninternal.server.core.DiffHelp;
import com.avaje.ebeaninternal.server.core.InternString;
import com.avaje.ebeaninternal.server.core.PersistRequest;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorCacheHelp;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorJsonHelp;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorMap;
import com.avaje.ebeaninternal.server.deploy.BeanFkeyProperty;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssoc;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyCompound;
import com.avaje.ebeaninternal.server.deploy.ChainedBeanPersistController;
import com.avaje.ebeaninternal.server.deploy.ChainedBeanPersistListener;
import com.avaje.ebeaninternal.server.deploy.CompoundUniqueConstraint;
import com.avaje.ebeaninternal.server.deploy.DeployNamedQuery;
import com.avaje.ebeaninternal.server.deploy.DeployNamedUpdate;
import com.avaje.ebeaninternal.server.deploy.DeployPropertyParser;
import com.avaje.ebeaninternal.server.deploy.DeployUpdateParser;
import com.avaje.ebeaninternal.server.deploy.InheritInfo;
import com.avaje.ebeaninternal.server.deploy.TableJoin;
import com.avaje.ebeaninternal.server.deploy.id.IdBinder;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanPropertyLists;
import com.avaje.ebeaninternal.server.el.ElComparator;
import com.avaje.ebeaninternal.server.el.ElComparatorCompound;
import com.avaje.ebeaninternal.server.el.ElComparatorProperty;
import com.avaje.ebeaninternal.server.el.ElPropertyChainBuilder;
import com.avaje.ebeaninternal.server.el.ElPropertyDeploy;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.persist.DmlUtil;
import com.avaje.ebeaninternal.server.query.CQueryPlan;
import com.avaje.ebeaninternal.server.query.CQueryPlanStats;
import com.avaje.ebeaninternal.server.query.SplitName;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryDetail;
import com.avaje.ebeaninternal.server.text.json.ReadJson;
import com.avaje.ebeaninternal.server.text.json.WriteJson;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.util.SortByClause;
import com.avaje.ebeaninternal.util.SortByClauseParser;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanDescriptor<T>
implements MetaBeanInfo,
SpiBeanType<T> {
    private static final Logger logger = LoggerFactory.getLogger(BeanDescriptor.class);
    private final ConcurrentHashMap<Integer, SpiUpdatePlan> updatePlanCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<HashQueryPlan, CQueryPlan> queryPlanCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ElPropertyValue> elCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ElPropertyDeploy> elDeployCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ElComparator<T>> comparatorCache = new ConcurrentHashMap();
    private final String serverName;
    private final EntityType entityType;
    private final IdType idType;
    private final boolean idTypePlatformDefault;
    private final IdGenerator idGenerator;
    private final String sequenceName;
    private final int sequenceInitialValue;
    private final int sequenceAllocationSize;
    private final String selectLastInsertedId;
    private final boolean autoTunable;
    private final ConcurrencyMode concurrencyMode;
    private final CompoundUniqueConstraint[] compoundUniqueConstraints;
    private final String baseTable;
    private final String baseTableAsOf;
    private final String baseTableVersionsBetween;
    private final boolean historySupport;
    private final boolean readAuditing;
    private final LinkedHashMap<String, BeanProperty> propMap;
    private final Class<T> beanType;
    private final BeanDescriptorMap owner;
    private final String[] properties;
    private final int propertyCount;
    private volatile BeanPersistController persistController;
    private final BeanPostLoad beanPostLoad;
    private volatile BeanPersistListener persistListener;
    private final BeanQueryAdapter queryAdapter;
    private final BeanFindController beanFinder;
    private final ChangeLogFilter changeLogFilter;
    private final TableJoin[] derivedTableJoins;
    protected final InheritInfo inheritInfo;
    protected final BeanProperty idProperty;
    private final int idPropertyIndex;
    private final BeanProperty versionProperty;
    private final int versionPropertyIndex;
    private final int[] unloadProperties;
    private final BeanProperty[] propertiesLocal;
    private final BeanProperty[] propertiesMutable;
    private final BeanPropertyAssocOne<?> unidirectional;
    private final BeanProperty[] propertiesNonMany;
    private final BeanPropertyAssocMany<?>[] propertiesMany;
    private final BeanPropertyAssocMany<?>[] propertiesManySave;
    private final BeanPropertyAssocMany<?>[] propertiesManyDelete;
    private final BeanPropertyAssocMany<?>[] propertiesManyToMany;
    private final BeanPropertyAssocOne<?>[] propertiesOne;
    private final BeanPropertyAssocOne<?>[] propertiesOneImported;
    private final BeanPropertyAssocOne<?>[] propertiesOneImportedSave;
    private final BeanPropertyAssocOne<?>[] propertiesOneImportedDelete;
    private final BeanPropertyAssocOne<?>[] propertiesOneExportedSave;
    private final BeanPropertyAssocOne<?>[] propertiesOneExportedDelete;
    private final BeanPropertyAssocOne<?>[] propertiesEmbedded;
    private final BeanProperty[] propertiesBaseScalar;
    private final BeanPropertyCompound[] propertiesBaseCompound;
    private final BeanProperty[] propertiesTransient;
    private final BeanProperty[] propertiesNonTransient;
    private final String fullName;
    private final Map<String, DeployNamedQuery> namedQueries;
    private final Map<String, DeployNamedUpdate> namedUpdates;
    private boolean saveRecurseSkippable;
    private boolean deleteRecurseSkippable;
    private final EntityBean prototypeEntityBean;
    private final IdBinder idBinder;
    private String idBinderInLHSSql;
    private String idBinderIdSql;
    private String deleteByIdSql;
    private String deleteByIdInSql;
    private final String name;
    private final String baseTableAlias;
    private final boolean updateChangesOnly;
    private final boolean cacheSharableBeans;
    private final BeanDescriptorCacheHelp<T> cacheHelp;
    private final BeanDescriptorJsonHelp<T> jsonHelp;
    private final String defaultSelectClause;
    private final Set<String> defaultSelectClauseSet;
    private SpiEbeanServer ebeanServer;

    public BeanDescriptor(BeanDescriptorMap owner, DeployBeanDescriptor<T> deploy) {
        this.owner = owner;
        this.serverName = owner.getServerName();
        this.entityType = deploy.getEntityType();
        this.properties = deploy.getProperties();
        this.propertyCount = this.properties.length;
        this.name = InternString.intern(deploy.getName());
        this.baseTableAlias = "t0";
        this.fullName = InternString.intern(deploy.getFullName());
        this.beanType = deploy.getBeanType();
        this.prototypeEntityBean = this.createPrototypeEntityBean(this.beanType);
        this.namedQueries = deploy.getNamedQueries();
        this.namedUpdates = deploy.getNamedUpdates();
        this.inheritInfo = deploy.getInheritInfo();
        this.beanFinder = deploy.getBeanFinder();
        this.persistController = deploy.getPersistController();
        this.persistListener = deploy.getPersistListener();
        this.beanPostLoad = deploy.getPostLoad();
        this.queryAdapter = deploy.getQueryAdapter();
        this.changeLogFilter = deploy.getChangeLogFilter();
        this.defaultSelectClause = deploy.getDefaultSelectClause();
        this.defaultSelectClauseSet = deploy.parseDefaultSelectClause(this.defaultSelectClause);
        this.idType = deploy.getIdType();
        this.idTypePlatformDefault = deploy.isIdTypePlatformDefault();
        this.idGenerator = deploy.getIdGenerator();
        this.sequenceName = deploy.getSequenceName();
        this.sequenceInitialValue = deploy.getSequenceInitialValue();
        this.sequenceAllocationSize = deploy.getSequenceAllocationSize();
        this.selectLastInsertedId = deploy.getSelectLastInsertedId();
        this.concurrencyMode = deploy.getConcurrencyMode();
        this.updateChangesOnly = deploy.isUpdateChangesOnly();
        this.compoundUniqueConstraints = deploy.getCompoundUniqueConstraints();
        this.readAuditing = deploy.isReadAuditing();
        this.historySupport = deploy.isHistorySupport();
        this.baseTable = InternString.intern(deploy.getBaseTable());
        this.baseTableAsOf = deploy.getBaseTableAsOf();
        this.baseTableVersionsBetween = deploy.getBaseTableVersionsBetween();
        this.autoTunable = EntityType.ORM.equals((Object)this.entityType) && this.beanFinder == null;
        DeployBeanPropertyLists listHelper = new DeployBeanPropertyLists(owner, this, deploy);
        this.idProperty = listHelper.getId();
        this.versionProperty = listHelper.getVersionProperty();
        this.propMap = listHelper.getPropertyMap();
        this.propertiesTransient = listHelper.getTransients();
        this.propertiesNonTransient = listHelper.getNonTransients();
        this.propertiesBaseScalar = listHelper.getBaseScalar();
        this.propertiesBaseCompound = listHelper.getBaseCompound();
        this.propertiesEmbedded = listHelper.getEmbedded();
        this.propertiesLocal = listHelper.getLocal();
        this.propertiesMutable = listHelper.getMutable();
        this.unidirectional = listHelper.getUnidirectional();
        this.propertiesOne = listHelper.getOnes();
        this.propertiesOneExportedSave = listHelper.getOneExportedSave();
        this.propertiesOneExportedDelete = listHelper.getOneExportedDelete();
        this.propertiesOneImported = listHelper.getOneImported();
        this.propertiesOneImportedSave = listHelper.getOneImportedSave();
        this.propertiesOneImportedDelete = listHelper.getOneImportedDelete();
        this.propertiesMany = listHelper.getMany();
        this.propertiesNonMany = listHelper.getNonMany();
        this.propertiesManySave = listHelper.getManySave();
        this.propertiesManyDelete = listHelper.getManyDelete();
        this.propertiesManyToMany = listHelper.getManyToMany();
        this.derivedTableJoins = listHelper.getTableJoin();
        boolean noRelationships = this.propertiesOne.length + this.propertiesMany.length == 0;
        this.cacheSharableBeans = noRelationships && deploy.getCacheOptions().isReadOnly();
        this.cacheHelp = new BeanDescriptorCacheHelp(this, owner.getCacheManager(), deploy.getCacheOptions(), this.cacheSharableBeans, this.propertiesOneImported);
        this.jsonHelp = new BeanDescriptorJsonHelp(this);
        this.saveRecurseSkippable = 0 == this.propertiesOneExportedSave.length + this.propertiesOneImportedSave.length + this.propertiesManySave.length;
        this.deleteRecurseSkippable = 0 == this.propertiesOneExportedDelete.length + this.propertiesOneImportedDelete.length + this.propertiesManyDelete.length;
        this.idBinder = owner.createIdBinder(this.idProperty);
        if (Modifier.isAbstract(this.beanType.getModifiers())) {
            this.idPropertyIndex = -1;
            this.versionPropertyIndex = -1;
            this.unloadProperties = new int[0];
        } else {
            EntityBeanIntercept ebi = this.prototypeEntityBean._ebean_getIntercept();
            this.idPropertyIndex = this.idProperty == null ? -1 : ebi.findProperty(this.idProperty.getName());
            this.versionPropertyIndex = this.versionProperty == null ? -1 : ebi.findProperty(this.versionProperty.getName());
            this.unloadProperties = this.derivePropertiesToUnload(this.prototypeEntityBean);
        }
    }

    private int[] derivePropertiesToUnload(EntityBean prototypeEntityBean) {
        boolean[] loaded = prototypeEntityBean._ebean_getIntercept().getLoaded();
        int[] props = new int[loaded.length];
        int pos = 0;
        for (int i = 0; i < loaded.length; ++i) {
            if (!loaded[i]) continue;
            props[pos++] = i;
        }
        if (pos == 0) {
            return new int[0];
        }
        int[] unload = new int[pos];
        System.arraycopy(props, 0, unload, 0, pos);
        return unload;
    }

    private EntityBean createPrototypeEntityBean(Class<T> beanType) {
        if (Modifier.isAbstract(beanType.getModifiers())) {
            return null;
        }
        try {
            return (EntityBean)beanType.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error trying to create the prototypeEntityBean for " + beanType, e);
        }
    }

    public void setEbeanServer(SpiEbeanServer ebeanServer) {
        this.ebeanServer = ebeanServer;
        for (int i = 0; i < this.propertiesMany.length; ++i) {
            this.propertiesMany[i].setLoader(ebeanServer);
        }
    }

    public SpiEbeanServer getEbeanServer() {
        return this.ebeanServer;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public int getPropertyCount() {
        return this.propertyCount;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public void initialiseId(Map<String, String> withHistoryTables) {
        if (logger.isTraceEnabled()) {
            logger.trace("BeanDescriptor initialise " + this.fullName);
        }
        if (this.historySupport) {
            withHistoryTables.put(this.baseTable, this.baseTableAsOf);
        }
        if (this.inheritInfo != null) {
            this.inheritInfo.setDescriptor(this);
        }
        if (this.isEmbedded()) {
            for (BeanProperty prop : this.propertiesAll()) {
                prop.initialise();
            }
        } else if (this.idProperty != null) {
            this.idProperty.initialise();
        }
    }

    public void initialiseOther(Map<String, String> asOfTableMap, String asOfViewSuffix) {
        if (this.historySupport) {
            for (int i = 0; i < this.propertiesManyToMany.length; ++i) {
                if (this.propertiesManyToMany[i].isExcludedFromHistory()) continue;
                TableJoin intersectionTableJoin = this.propertiesManyToMany[i].getIntersectionTableJoin();
                String intersectionTableName = intersectionTableJoin.getTable();
                asOfTableMap.put(intersectionTableName, intersectionTableName + asOfViewSuffix);
            }
        }
        if (!this.isEmbedded()) {
            for (BeanProperty prop : this.propertiesAll()) {
                if (prop.isId()) continue;
                prop.initialise();
            }
        }
        if (this.unidirectional != null) {
            this.unidirectional.initialise();
        }
        this.idBinder.initialise();
        this.idBinderInLHSSql = this.idBinder.getBindIdInSql(this.baseTableAlias);
        this.idBinderIdSql = this.idBinder.getBindIdSql(this.baseTableAlias);
        String idBinderInLHSSqlNoAlias = this.idBinder.getBindIdInSql(null);
        String idEqualsSql = this.idBinder.getBindIdSql(null);
        this.deleteByIdSql = "delete from " + this.baseTable + " where " + idEqualsSql;
        this.deleteByIdInSql = "delete from " + this.baseTable + " where " + idBinderInLHSSqlNoAlias + " ";
        if (!this.isEmbedded()) {
            for (DeployNamedUpdate namedUpdate : this.namedUpdates.values()) {
                DeployUpdateParser parser = new DeployUpdateParser(this);
                namedUpdate.initialise(parser);
            }
        }
    }

    public void initInheritInfo() {
        if (this.inheritInfo != null) {
            if (this.saveRecurseSkippable) {
                this.saveRecurseSkippable = this.inheritInfo.isSaveRecurseSkippable();
            }
            if (this.deleteRecurseSkippable) {
                this.deleteRecurseSkippable = this.inheritInfo.isDeleteRecurseSkippable();
            }
        }
    }

    public ReadAuditLogger getReadAuditLogger() {
        return this.ebeanServer.getReadAuditLogger();
    }

    public ReadAuditPrepare getReadAuditPrepare() {
        return this.ebeanServer.getReadAuditPrepare();
    }

    public BeanChange getChangeLogBean(PersistRequestBean<T> request) {
        if (this.changeLogFilter == null) {
            return null;
        }
        PersistRequest.Type type = request.getType();
        switch (type) {
            case INSERT: {
                return this.changeLogFilter.includeInsert(request) ? this.insertBeanChange(request) : null;
            }
            case UPDATE: {
                return this.changeLogFilter.includeUpdate(request) ? this.updateBeanChange(request) : null;
            }
            case DELETE: {
                return this.changeLogFilter.includeDelete(request) ? this.deleteBeanChange(request) : null;
            }
        }
        throw new IllegalStateException("Unhandled request type " + (Object)((Object)type));
    }

    private BeanChange deleteBeanChange(PersistRequestBean<T> request) {
        return this.newBeanChange(request.getBeanId(), ChangeType.DELETE, Collections.EMPTY_MAP);
    }

    private BeanChange updateBeanChange(PersistRequestBean<T> request) {
        return this.newBeanChange(request.getBeanId(), ChangeType.UPDATE, this.diffFlatten(request.getEntityBeanIntercept().getDirtyValues()));
    }

    private BeanChange insertBeanChange(PersistRequestBean<T> request) {
        return this.newBeanChange(request.getBeanId(), ChangeType.INSERT, this.diffForInsert(request.getEntityBean()));
    }

    private BeanChange newBeanChange(Object id, ChangeType changeType, Map<String, ValuePair> values) {
        return new BeanChange(this.getBaseTable(), id, changeType, values);
    }

    public void cacheInitialise() {
        this.cacheHelp.initialise();
    }

    public SqlUpdate deleteById(Object id, List<Object> idList) {
        if (id != null) {
            return this.deleteById(id);
        }
        return this.deleteByIdList(idList);
    }

    public String getDeleteByIdInSql() {
        return this.deleteByIdInSql;
    }

    private SqlUpdate deleteByIdList(List<Object> idList) {
        StringBuilder sb = new StringBuilder(this.deleteByIdInSql);
        String inClause = this.idBinder.getIdInValueExprDelete(idList.size());
        sb.append(inClause);
        DefaultSqlUpdate delete = new DefaultSqlUpdate(sb.toString());
        for (int i = 0; i < idList.size(); ++i) {
            this.idBinder.bindId(delete, idList.get(i));
        }
        return delete;
    }

    private SqlUpdate deleteById(Object id) {
        DefaultSqlUpdate sqlDelete = new DefaultSqlUpdate(this.deleteByIdSql);
        Object[] bindValues = this.idBinder.getBindValues(id);
        for (int i = 0; i < bindValues.length; ++i) {
            sqlDelete.addParameter(bindValues[i]);
        }
        return sqlDelete;
    }

    public void add(BeanFkeyProperty fkey) {
        this.elDeployCache.put(fkey.getName(), fkey);
    }

    public void initialiseFkeys() {
        for (int i = 0; i < this.propertiesOneImported.length; ++i) {
            this.propertiesOneImported[i].addFkey();
        }
    }

    public boolean calculateUseCache(Boolean queryUseCache) {
        return queryUseCache != null ? queryUseCache.booleanValue() : this.isBeanCaching();
    }

    public CacheOptions getCacheOptions() {
        return this.cacheHelp.getCacheOptions();
    }

    public EncryptKey getEncryptKey(BeanProperty p) {
        return this.owner.getEncryptKey(this.baseTable, p.getDbColumn());
    }

    public EncryptKey getEncryptKey(String tableName, String columnName) {
        return this.owner.getEncryptKey(tableName, columnName);
    }

    public void runCacheWarming() {
        this.cacheHelp.runCacheWarming(this.ebeanServer);
    }

    public boolean hasDefaultSelectClause() {
        return this.defaultSelectClause != null;
    }

    public String getDefaultSelectClause() {
        return this.defaultSelectClause;
    }

    public Set<String> getDefaultSelectClauseSet() {
        return this.defaultSelectClauseSet;
    }

    public boolean isInheritanceRoot() {
        return this.inheritInfo == null || this.inheritInfo.isRoot();
    }

    public void setUseCache(boolean useCache) {
        this.cacheHelp.setUseCache(useCache);
    }

    public boolean isBeanCaching() {
        return this.cacheHelp.isBeanCaching();
    }

    public boolean isManyPropCaching() {
        return this.isBeanCaching();
    }

    public boolean isCacheNotify() {
        return this.cacheHelp.isCacheNotify();
    }

    public void queryCacheClear() {
        this.cacheHelp.queryCacheClear();
    }

    public BeanCollection<T> queryCacheGet(Object id) {
        return this.cacheHelp.queryCacheGet(id);
    }

    public void queryCachePut(Object id, BeanCollection<T> query) {
        this.cacheHelp.queryCachePut(id, query);
    }

    public boolean cacheManyPropLoad(BeanPropertyAssocMany<?> many, BeanCollection<?> bc, Object parentId, Boolean readOnly) {
        return this.cacheHelp.manyPropLoad(many, bc, parentId, readOnly);
    }

    public void cacheManyPropPut(BeanPropertyAssocMany<?> many, BeanCollection<?> bc, Object parentId) {
        this.cacheHelp.manyPropPut(many, bc, parentId);
    }

    public void cacheManyPropRemove(Object parentId, String propertyName) {
        this.cacheHelp.manyPropRemove(parentId, propertyName);
    }

    public void cacheManyPropClear(String propertyName) {
        this.cacheHelp.manyPropClear(propertyName);
    }

    public void cacheBeanPut(T bean) {
        this.cacheBeanPutData((EntityBean)bean);
    }

    public CachedBeanData cacheBeanExtractData(EntityBean bean) {
        return this.cacheHelp.beanExtractData(bean);
    }

    public void cacheBeanLoadData(EntityBean bean, CachedBeanData data) {
        this.cacheHelp.beanLoadData(bean, data);
    }

    public void cacheBeanPutData(EntityBean bean) {
        this.cacheHelp.beanCachePut(bean);
    }

    public T cacheBeanGet(SpiQuery<T> query, PersistenceContext context) {
        return this.cacheHelp.beanCacheGet(query, context);
    }

    public void cacheBeanRemove(Object id) {
        this.cacheHelp.beanCacheRemove(id);
    }

    public boolean cacheBeanLoad(EntityBean bean, EntityBeanIntercept ebi, Object id) {
        return this.cacheHelp.beanCacheLoad(bean, ebi, id);
    }

    public boolean cacheBeanLoad(EntityBeanIntercept ebi) {
        EntityBean bean = ebi.getOwner();
        Object id = this.getId(bean);
        return this.cacheBeanLoad(bean, ebi, id);
    }

    public T cacheNaturalKeyLookup(SpiQuery<T> query, SpiTransaction t) {
        return this.cacheHelp.naturalKeyLookup(query, t);
    }

    public void cacheHandleBulkUpdate(TransactionEventTable.TableIUD tableIUD) {
        this.cacheHelp.handleBulkUpdate(tableIUD);
    }

    public void cacheHandleDelete(Object id, PersistRequestBean<T> deleteRequest) {
        this.cacheHelp.handleDelete(id, deleteRequest);
    }

    public void cacheHandleInsert(PersistRequestBean<T> insertRequest) {
        this.cacheHelp.handleInsert(insertRequest);
    }

    public void cacheHandleUpdate(Object id, PersistRequestBean<T> updateRequest) {
        this.cacheHelp.handleUpdate(id, updateRequest);
    }

    public void readAuditFutureList(SpiQuery<T> spiQuery) {
        if (this.isReadAuditing()) {
            ReadEvent event = new ReadEvent(this.fullName);
            this.readAuditPrepare(event);
            spiQuery.setFutureFetchAudit(event);
        }
    }

    public void readAuditBean(String queryKey, String bindLog, Object bean) {
        ReadEvent event = new ReadEvent(this.fullName, queryKey, bindLog, this.getIdForJson(bean));
        this.readAuditPrepare(event);
        this.getReadAuditLogger().auditBean(event);
    }

    private void readAuditPrepare(ReadEvent event) {
        ReadAuditPrepare prepare = this.getReadAuditPrepare();
        if (prepare != null) {
            prepare.prepare(event);
        }
    }

    public void readAuditMany(String queryKey, String bindLog, List<Object> ids) {
        ReadEvent event = new ReadEvent(this.fullName, queryKey, bindLog, ids);
        this.readAuditPrepare(event);
        this.getReadAuditLogger().auditMany(event);
    }

    public void readAuditFutureMany(ReadEvent event) {
        this.getReadAuditLogger().auditMany(event);
    }

    public String getBaseTableAlias() {
        return this.baseTableAlias;
    }

    public void preAllocateIds(int batchSize) {
        if (this.idGenerator != null) {
            this.idGenerator.preAllocateIds(batchSize);
        }
    }

    public Object nextId(Transaction t) {
        if (this.idGenerator != null) {
            return this.idGenerator.nextId(t);
        }
        return null;
    }

    public DeployPropertyParser createDeployPropertyParser() {
        return new DeployPropertyParser(this);
    }

    public String convertOrmUpdateToSql(String ormUpdateStatement) {
        return new DeployUpdateParser(this).parse(ormUpdateStatement);
    }

    @Override
    public List<MetaQueryPlanStatistic> collectQueryPlanStatistics(boolean reset) {
        return this.collectQueryPlanStatisticsInternal(reset, false);
    }

    @Override
    public List<MetaQueryPlanStatistic> collectAllQueryPlanStatistics(boolean reset) {
        return this.collectQueryPlanStatisticsInternal(reset, false);
    }

    public List<MetaQueryPlanStatistic> collectQueryPlanStatisticsInternal(boolean reset, boolean collectAll) {
        ArrayList<MetaQueryPlanStatistic> list = new ArrayList<MetaQueryPlanStatistic>(this.queryPlanCache.size());
        for (CQueryPlan queryPlan : this.queryPlanCache.values()) {
            CQueryPlanStats.Snapshot snapshot = queryPlan.getSnapshot(reset);
            if (!collectAll && snapshot.getExecutionCount() <= 0L) continue;
            list.add(snapshot);
        }
        return list;
    }

    public void clearQueryStatistics() {
        for (CQueryPlan queryPlan : this.queryPlanCache.values()) {
            queryPlan.resetStatistics();
        }
    }

    public void postLoad(Object bean) {
        if (this.beanPostLoad != null) {
            this.beanPostLoad.postLoad(bean);
        }
    }

    public CQueryPlan getQueryPlan(HashQueryPlan key) {
        return this.queryPlanCache.get(key);
    }

    public void putQueryPlan(HashQueryPlan key, CQueryPlan plan) {
        this.queryPlanCache.put(key, plan);
    }

    public SpiUpdatePlan getUpdatePlan(Integer key) {
        return this.updatePlanCache.get(key);
    }

    public void putUpdatePlan(Integer key, SpiUpdatePlan plan) {
        this.updatePlanCache.put(key, plan);
    }

    public boolean isUpdateChangesOnly() {
        return this.updateChangesOnly;
    }

    public boolean isSaveRecurseSkippable() {
        return this.saveRecurseSkippable;
    }

    public boolean isDeleteRecurseSkippable() {
        return this.deleteRecurseSkippable;
    }

    public BeanProperty findWhenCreatedProperty() {
        for (int i = 0; i < this.propertiesBaseScalar.length; ++i) {
            if (!this.propertiesBaseScalar[i].isGeneratedWhenCreated()) continue;
            return this.propertiesBaseScalar[i];
        }
        return null;
    }

    public BeanProperty findWhenModifiedProperty() {
        for (int i = 0; i < this.propertiesBaseScalar.length; ++i) {
            if (!this.propertiesBaseScalar[i].isGeneratedWhenModified()) continue;
            return this.propertiesBaseScalar[i];
        }
        return null;
    }

    public BeanPropertyAssocMany<?> getManyProperty(SpiQuery<?> query) {
        OrmQueryDetail detail = query.getDetail();
        for (int i = 0; i < this.propertiesMany.length; ++i) {
            if (!detail.includes(this.propertiesMany[i].getName())) continue;
            return this.propertiesMany[i];
        }
        return null;
    }

    public String getParentIdInExpr(int parentIdSize, String rawWhere) {
        String inClause = this.idBinder.getIdInValueExpr(parentIdSize);
        return this.idBinder.isIdInExpandedForm() ? inClause : rawWhere + inClause;
    }

    public IdBinder getIdBinder() {
        return this.idBinder;
    }

    public String getIdBinderIdSql() {
        return this.idBinderIdSql;
    }

    public String getIdBinderInLHSSql() {
        return this.idBinderInLHSSql;
    }

    public void bindId(DataBind dataBind, Object idValue) throws SQLException {
        this.idBinder.bindId(dataBind, idValue);
    }

    public Object[] getBindIdValues(Object idValue) {
        return this.idBinder.getBindValues(idValue);
    }

    public DeployNamedQuery getNamedQuery(String name) {
        return this.namedQueries.get(name);
    }

    public void addNamedQuery(DeployNamedQuery deployNamedQuery) {
        this.namedQueries.put(deployNamedQuery.getName(), deployNamedQuery);
    }

    public DeployNamedUpdate getNamedUpdate(String name) {
        return this.namedUpdates.get(name);
    }

    public EntityBean createEntityBean() {
        try {
            EntityBean bean = (EntityBean)this.prototypeEntityBean._ebean_newInstance();
            if (this.unloadProperties.length > 0) {
                EntityBeanIntercept ebi = bean._ebean_getIntercept();
                for (int i = 0; i < this.unloadProperties.length; ++i) {
                    ebi.setPropertyUnloaded(this.unloadProperties[i]);
                }
            }
            return bean;
        }
        catch (Exception ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    public T createReference(Boolean readOnly, Object id) {
        Object shareableBean;
        CachedBeanData d;
        if (this.cacheSharableBeans && !Boolean.FALSE.equals(readOnly) && (d = this.cacheHelp.beanCacheGetData(id)) != null && (shareableBean = d.getSharableBean()) != null) {
            if (this.isReadAuditing()) {
                this.readAuditBean("ref", "", shareableBean);
            }
            return (T)shareableBean;
        }
        try {
            EntityBean eb = this.createEntityBean();
            this.convertSetId(id, eb);
            EntityBeanIntercept ebi = eb._ebean_getIntercept();
            ebi.setBeanLoader(this.ebeanServer);
            ebi.setReference(this.idPropertyIndex);
            return (T)eb;
        }
        catch (Exception ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    public BeanProperty getBeanPropertyFromPath(String path) {
        String[] split = SplitName.splitBegin(path);
        if (split[1] == null) {
            return this._findBeanProperty(split[0]);
        }
        BeanPropertyAssoc assocProp = (BeanPropertyAssoc)this._findBeanProperty(split[0]);
        BeanDescriptor targetDesc = assocProp.getTargetDescriptor();
        return targetDesc.getBeanPropertyFromPath(split[1]);
    }

    public BeanDescriptor<?> getBeanDescriptor(String path) {
        if (path == null) {
            return this;
        }
        String[] splitBegin = SplitName.splitBegin(path);
        BeanProperty beanProperty = this.propMap.get(splitBegin[0]);
        if (beanProperty instanceof BeanPropertyAssoc) {
            BeanPropertyAssoc assocProp = (BeanPropertyAssoc)beanProperty;
            return assocProp.getTargetDescriptor().getBeanDescriptor(splitBegin[1]);
        }
        throw new RuntimeException("Error getting BeanDescriptor for path " + path + " from " + this.getFullName());
    }

    public <U> BeanDescriptor<U> getBeanDescriptor(Class<U> otherType) {
        return this.owner.getBeanDescriptor(otherType);
    }

    public BeanPropertyAssocOne<?> getUnidirectional() {
        if (this.unidirectional != null) {
            return this.unidirectional;
        }
        if (this.inheritInfo != null && !this.inheritInfo.isRoot()) {
            return this.inheritInfo.getParent().getBeanDescriptor().getUnidirectional();
        }
        return null;
    }

    public Object getValue(EntityBean bean, String property) {
        return this.getBeanProperty(property).getValue(bean);
    }

    public boolean isUseIdGenerator() {
        return this.idGenerator != null;
    }

    public String getDescriptorId() {
        return this.fullName;
    }

    @Override
    public Class<T> getBeanType() {
        return this.beanType;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.fullName;
    }

    public Object getId(EntityBean bean) {
        return this.idProperty == null ? null : this.idProperty.getValue(bean);
    }

    @Override
    public Object getBeanId(T bean) {
        return this.getId((EntityBean)bean);
    }

    public Object getIdForJson(Object bean) {
        return this.idBinder.getIdForJson((EntityBean)bean);
    }

    public Object convertIdFromJson(Object idValue) {
        return this.idBinder.convertIdFromJson(idValue);
    }

    public String getDefaultOrderBy() {
        return this.idBinder.getDefaultOrderBy();
    }

    public Object convertId(Object idValue) {
        return this.idBinder.convertId(idValue);
    }

    public Object convertSetId(Object idValue, EntityBean bean) {
        return this.idBinder.convertSetId(idValue, bean);
    }

    public BeanProperty getBeanProperty(String propName) {
        return this.propMap.get(propName);
    }

    public void sort(List<T> list, String sortByClause) {
        ElComparator<T> comparator = this.getElComparator(sortByClause);
        Collections.sort(list, comparator);
    }

    public ElComparator<T> getElComparator(String propNameOrSortBy) {
        ElComparator<T> c = this.comparatorCache.get(propNameOrSortBy);
        if (c == null) {
            c = this.createComparator(propNameOrSortBy);
            this.comparatorCache.put(propNameOrSortBy, c);
        }
        return c;
    }

    public boolean lazyLoadMany(EntityBeanIntercept ebi) {
        int lazyLoadProperty = ebi.getLazyLoadPropertyIndex();
        if (lazyLoadProperty == -1) {
            return false;
        }
        String lazyLoadPropertyName = ebi.getProperty(lazyLoadProperty);
        BeanProperty lazyLoadBeanProp = this.getBeanProperty(lazyLoadPropertyName);
        if (lazyLoadBeanProp instanceof BeanPropertyAssocMany) {
            BeanPropertyAssocMany manyProp = (BeanPropertyAssocMany)lazyLoadBeanProp;
            manyProp.createReference(ebi.getOwner());
            ebi.setLoadedLazy();
            return true;
        }
        return false;
    }

    private ElComparator<T> createComparator(String sortByClause) {
        SortByClause sortBy = SortByClauseParser.parse(sortByClause);
        if (sortBy.size() == 1) {
            return this.createPropertyComparator(sortBy.getProperties().get(0));
        }
        ElComparator[] comparators = new ElComparator[sortBy.size()];
        List<SortByClause.Property> sortProps = sortBy.getProperties();
        for (int i = 0; i < sortProps.size(); ++i) {
            SortByClause.Property sortProperty = sortProps.get(i);
            comparators[i] = this.createPropertyComparator(sortProperty);
        }
        return new ElComparatorCompound(comparators);
    }

    private ElComparator<T> createPropertyComparator(SortByClause.Property sortProp) {
        ElPropertyValue elGetValue = this.getElGetValue(sortProp.getName());
        Boolean nullsHigh = sortProp.getNullsHigh();
        if (nullsHigh == null) {
            nullsHigh = Boolean.TRUE;
        }
        return new ElComparatorProperty(elGetValue, sortProp.isAscending(), nullsHigh);
    }

    public ElPropertyValue getElGetValue(String propName) {
        ElPropertyValue elGetValue = this.elCache.get(propName);
        if (elGetValue != null) {
            return elGetValue;
        }
        elGetValue = this.buildElGetValue(propName, null, false);
        if (elGetValue != null) {
            this.elCache.put(propName, elGetValue);
        }
        return elGetValue;
    }

    public ElPropertyDeploy getElPropertyDeploy(String propName) {
        ElPropertyDeploy elProp = this.elDeployCache.get(propName);
        if (elProp != null) {
            return elProp;
        }
        elProp = !propName.contains(".") ? this.getElGetValue(propName) : this.buildElGetValue(propName, null, true);
        if (elProp != null) {
            this.elDeployCache.put(propName, elProp);
        }
        return elProp;
    }

    protected ElPropertyValue buildElGetValue(String propName, ElPropertyChainBuilder chain, boolean propertyDeploy) {
        ElPropertyDeploy fk;
        if (propertyDeploy && chain != null && (fk = this.elDeployCache.get(propName)) != null && fk instanceof BeanFkeyProperty) {
            return ((BeanFkeyProperty)fk).create(chain.getExpression(), chain.isContainsMany());
        }
        int basePos = propName.indexOf(46);
        if (basePos > -1) {
            String baseName = propName.substring(0, basePos);
            String remainder = propName.substring(basePos + 1);
            BeanProperty assocProp = this._findBeanProperty(baseName);
            if (assocProp == null) {
                return null;
            }
            return assocProp.buildElPropertyValue(propName, remainder, chain, propertyDeploy);
        }
        BeanProperty property = this._findBeanProperty(propName);
        if (chain == null) {
            return property;
        }
        if (property == null) {
            throw new PersistenceException("No property found for [" + propName + "] in expression " + chain.getExpression());
        }
        if (property.containsMany()) {
            chain.setContainsMany();
        }
        return chain.add(property).build();
    }

    public BeanProperty findBeanProperty(String propName) {
        int basePos = propName.indexOf(46);
        if (basePos > -1) {
            String baseName = propName.substring(0, basePos);
            return this._findBeanProperty(baseName);
        }
        return this._findBeanProperty(propName);
    }

    private BeanProperty _findBeanProperty(String propName) {
        BeanProperty prop = this.propMap.get(propName);
        if (prop == null && this.inheritInfo != null) {
            return this.inheritInfo.findSubTypeProperty(propName);
        }
        return prop;
    }

    public void resetManyProperties(Object dbBean) {
        EntityBean bean = (EntityBean)dbBean;
        for (int i = 0; i < this.propertiesMany.length; ++i) {
            this.propertiesMany[i].resetMany(bean);
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean isCacheSharableBeans() {
        return this.cacheSharableBeans;
    }

    public boolean isAutoTunable() {
        return this.autoTunable;
    }

    public InheritInfo getInheritInfo() {
        return this.inheritInfo;
    }

    public boolean isEmbedded() {
        return EntityType.EMBEDDED.equals((Object)this.entityType);
    }

    public CompoundUniqueConstraint[] getCompoundUniqueConstraints() {
        return this.compoundUniqueConstraints;
    }

    @Override
    public BeanPersistListener getPersistListener() {
        return this.persistListener;
    }

    public BeanFindController getBeanFinder() {
        return this.beanFinder;
    }

    @Override
    public BeanFindController getFindController() {
        return this.beanFinder;
    }

    @Override
    public BeanQueryAdapter getQueryAdapter() {
        return this.queryAdapter;
    }

    public void deregister(BeanPersistListener listener) {
        BeanPersistListener currentListener = this.persistListener;
        if (currentListener != null) {
            if (currentListener instanceof ChainedBeanPersistListener) {
                this.persistListener = ((ChainedBeanPersistListener)currentListener).deregister(listener);
            } else if (currentListener.equals(listener)) {
                this.persistListener = null;
            }
        }
    }

    public void deregister(BeanPersistController controller) {
        BeanPersistController currentController = this.persistController;
        if (currentController != null) {
            if (currentController instanceof ChainedBeanPersistController) {
                this.persistController = ((ChainedBeanPersistController)currentController).deregister(controller);
            } else if (currentController.equals(controller)) {
                this.persistController = null;
            }
        }
    }

    public void register(BeanPersistListener newPersistListener) {
        if (newPersistListener.isRegisterFor(this.beanType)) {
            BeanPersistListener currentListener = this.persistListener;
            this.persistListener = currentListener == null ? newPersistListener : (currentListener instanceof ChainedBeanPersistListener ? ((ChainedBeanPersistListener)currentListener).register(newPersistListener) : new ChainedBeanPersistListener(currentListener, newPersistListener));
        }
    }

    public void register(BeanPersistController newController) {
        if (newController.isRegisterFor(this.beanType)) {
            BeanPersistController currentController = this.persistController;
            this.persistController = currentController == null ? newController : (currentController instanceof ChainedBeanPersistController ? ((ChainedBeanPersistController)currentController).register(newController) : new ChainedBeanPersistController(currentController, newController));
        }
    }

    @Override
    public BeanPersistController getPersistController() {
        return this.persistController;
    }

    public boolean isSqlSelectBased() {
        return EntityType.SQL.equals((Object)this.entityType);
    }

    @Override
    public String getBaseTable() {
        return this.baseTable;
    }

    public String getBaseTable(SpiQuery.TemporalMode mode) {
        switch (mode) {
            case VERSIONS: {
                return this.baseTableVersionsBetween;
            }
            case AS_OF: {
                return this.baseTableAsOf;
            }
        }
        return this.baseTable;
    }

    public boolean isReadAuditing() {
        return this.readAuditing;
    }

    public boolean isHistorySupport() {
        return this.historySupport;
    }

    @Override
    public IdType getIdType() {
        return this.idType;
    }

    public boolean isIdTypePlatformDefault() {
        return this.idTypePlatformDefault;
    }

    @Override
    public String getSequenceName() {
        return this.sequenceName;
    }

    public int getSequenceInitialValue() {
        return this.sequenceInitialValue;
    }

    public int getSequenceAllocationSize() {
        return this.sequenceAllocationSize;
    }

    public String getSelectLastInsertedId() {
        return this.selectLastInsertedId;
    }

    public TableJoin[] tableJoins() {
        return this.derivedTableJoins;
    }

    public Collection<BeanProperty> propertiesAll() {
        return this.propMap.values();
    }

    public BeanProperty[] propertiesNonTransient() {
        return this.propertiesNonTransient;
    }

    public BeanProperty[] propertiesTransient() {
        return this.propertiesTransient;
    }

    public BeanPropertyAssocOne<?>[] propertiesEmbedded() {
        return this.propertiesEmbedded;
    }

    public BeanProperty getIdProperty() {
        return this.idProperty;
    }

    public boolean isInsertMode(EntityBeanIntercept ebi, boolean insertMode) {
        if (ebi.isLoaded()) {
            return false;
        }
        if (this.idProperty.isEmbedded()) {
            return !ebi.isLoaded();
        }
        if (!this.hasIdValue(ebi.getOwner())) {
            return true;
        }
        return insertMode;
    }

    public boolean isReference(EntityBeanIntercept ebi) {
        return ebi.isReference() || this.hasIdPropertyOnly(ebi);
    }

    public boolean hasIdPropertyOnly(EntityBeanIntercept ebi) {
        return ebi.hasIdOnly(this.idPropertyIndex);
    }

    public boolean hasIdValue(EntityBean bean) {
        return this.idProperty != null && !DmlUtil.isNullOrZero(this.idProperty.getValue(bean));
    }

    public boolean hasVersionProperty(EntityBeanIntercept ebi) {
        return this.versionPropertyIndex > -1 && ebi.isLoadedProperty(this.versionPropertyIndex);
    }

    public void checkMutableProperties(EntityBeanIntercept ebi) {
        for (int i = 0; i < this.propertiesMutable.length; ++i) {
            Object value;
            BeanProperty beanProperty = this.propertiesMutable[i];
            int propertyIndex = beanProperty.getPropertyIndex();
            if (ebi.isDirtyProperty(propertyIndex) || !ebi.isLoadedProperty(propertyIndex) || (value = beanProperty.getValue(ebi.getOwner())) != null && !beanProperty.isDirtyValue(value)) continue;
            ebi.markPropertyAsChanged(propertyIndex);
        }
    }

    public ConcurrencyMode getConcurrencyMode(EntityBeanIntercept ebi) {
        if (!this.hasVersionProperty(ebi)) {
            return ConcurrencyMode.NONE;
        }
        return this.concurrencyMode;
    }

    Map<String, ValuePair> diffFlatten(Map<String, ValuePair> diff) {
        return DiffHelp.flatten(diff, this);
    }

    public Map<String, ValuePair> diffForInsert(EntityBean newBean) {
        LinkedHashMap<String, ValuePair> map = new LinkedHashMap<String, ValuePair>();
        this.diffForInsert(null, map, newBean);
        return map;
    }

    public void diffForInsert(String prefix, Map<String, ValuePair> map, EntityBean newBean) {
        int i;
        for (i = 0; i < this.propertiesBaseScalar.length; ++i) {
            this.propertiesBaseScalar[i].diffForInsert(prefix, map, newBean);
        }
        for (i = 0; i < this.propertiesOne.length; ++i) {
            this.propertiesOne[i].diffForInsert(prefix, map, newBean);
        }
        for (i = 0; i < this.propertiesEmbedded.length; ++i) {
            this.propertiesEmbedded[i].diffForInsert(prefix, map, newBean);
        }
    }

    public Map<String, ValuePair> diff(EntityBean newBean, EntityBean oldBean) {
        LinkedHashMap<String, ValuePair> map = new LinkedHashMap<String, ValuePair>();
        this.diff(null, map, newBean, oldBean);
        return map;
    }

    public void diff(String prefix, Map<String, ValuePair> map, EntityBean newBean, EntityBean oldBean) {
        int i;
        for (i = 0; i < this.propertiesBaseScalar.length; ++i) {
            this.propertiesBaseScalar[i].diff(prefix, map, newBean, oldBean);
        }
        for (i = 0; i < this.propertiesOne.length; ++i) {
            this.propertiesOne[i].diff(prefix, map, newBean, oldBean);
        }
        for (i = 0; i < this.propertiesEmbedded.length; ++i) {
            this.propertiesEmbedded[i].diff(prefix, map, newBean, oldBean);
        }
    }

    public void appendOrderById(SpiQuery<T> query) {
        if (this.idProperty != null) {
            OrderBy<T> orderBy = query.getOrderBy();
            if (orderBy == null || orderBy.isEmpty()) {
                query.order().asc(this.idProperty.getName());
            } else if (!orderBy.containsProperty(this.idProperty.getName())) {
                query.order().asc(this.idProperty.getName());
            }
        }
    }

    public BeanPropertyAssocOne<?>[] propertiesOne() {
        return this.propertiesOne;
    }

    public BeanPropertyAssocOne<?>[] propertiesOneImported() {
        return this.propertiesOneImported;
    }

    public BeanPropertyAssocOne<?>[] propertiesOneImportedSave() {
        return this.propertiesOneImportedSave;
    }

    public BeanPropertyAssocOne<?>[] propertiesOneImportedDelete() {
        return this.propertiesOneImportedDelete;
    }

    public BeanPropertyAssocOne<?>[] propertiesOneExportedSave() {
        return this.propertiesOneExportedSave;
    }

    public BeanPropertyAssocOne<?>[] propertiesOneExportedDelete() {
        return this.propertiesOneExportedDelete;
    }

    public BeanProperty[] propertiesNonMany() {
        return this.propertiesNonMany;
    }

    public BeanPropertyAssocMany<?>[] propertiesMany() {
        return this.propertiesMany;
    }

    public BeanPropertyAssocMany<?>[] propertiesManySave() {
        return this.propertiesManySave;
    }

    public BeanPropertyAssocMany<?>[] propertiesManyDelete() {
        return this.propertiesManyDelete;
    }

    public BeanPropertyAssocMany<?>[] propertiesManyToMany() {
        return this.propertiesManyToMany;
    }

    public BeanProperty getVersionProperty() {
        return this.versionProperty;
    }

    public BeanProperty[] propertiesBaseScalar() {
        return this.propertiesBaseScalar;
    }

    public BeanPropertyCompound[] propertiesBaseCompound() {
        return this.propertiesBaseCompound;
    }

    public BeanProperty[] propertiesLocal() {
        return this.propertiesLocal;
    }

    public void jsonWrite(WriteJson writeJson, EntityBean bean) throws IOException {
        this.jsonHelp.jsonWrite(writeJson, bean, null);
    }

    public void jsonWrite(WriteJson writeJson, EntityBean bean, String key) throws IOException {
        this.jsonHelp.jsonWrite(writeJson, bean, key);
    }

    protected void jsonWriteProperties(WriteJson writeJson, EntityBean bean) throws IOException {
        this.jsonHelp.jsonWriteProperties(writeJson, bean);
    }

    public T jsonRead(ReadJson jsonRead, String path) throws IOException {
        return this.jsonHelp.jsonRead(jsonRead, path);
    }

    protected T jsonReadObject(ReadJson jsonRead, String path) throws IOException {
        return this.jsonHelp.jsonReadObject(jsonRead, path);
    }

    public static enum EntityType {
        ORM,
        EMBEDDED,
        SQL;

    }
}

