/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.text.json.EJson;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.InheritInfo;
import com.avaje.ebeaninternal.server.text.json.ReadJson;
import com.avaje.ebeaninternal.server.text.json.WriteJson;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.LinkedHashMap;

public class BeanDescriptorJsonHelp<T> {
    private final BeanDescriptor<T> desc;
    private final InheritInfo inheritInfo;

    public BeanDescriptorJsonHelp(BeanDescriptor<T> desc) {
        this.desc = desc;
        this.inheritInfo = desc.inheritInfo;
    }

    public void jsonWrite(WriteJson writeJson, EntityBean bean, String key) throws IOException {
        writeJson.writeStartObject(key);
        if (this.inheritInfo == null) {
            this.jsonWriteProperties(writeJson, bean);
        } else {
            InheritInfo localInheritInfo = this.inheritInfo.readType(bean.getClass());
            String discValue = localInheritInfo.getDiscriminatorStringValue();
            String discColumn = localInheritInfo.getDiscriminatorColumn();
            writeJson.gen().writeStringField(discColumn, discValue);
            BeanDescriptor<?> localDescriptor = localInheritInfo.getBeanDescriptor();
            localDescriptor.jsonWriteProperties(writeJson, bean);
        }
        writeJson.writeEndObject();
    }

    protected void jsonWriteProperties(WriteJson writeJson, EntityBean bean) throws IOException {
        WriteJson.WriteBean writeBean = writeJson.createWriteBean(this.desc, bean);
        writeBean.write(writeJson);
    }

    public T jsonRead(ReadJson jsonRead, String path) throws IOException {
        JsonParser parser = jsonRead.getParser();
        if (parser.getCurrentToken() != JsonToken.START_OBJECT) {
            JsonToken token = parser.nextToken();
            if (JsonToken.VALUE_NULL == token || JsonToken.END_ARRAY == token) {
                return null;
            }
            if (JsonToken.START_OBJECT != token) {
                throw new JsonParseException("Unexpected token " + token + " - expecting start_object", parser.getCurrentLocation());
            }
        }
        if (this.desc.inheritInfo == null) {
            return this.jsonReadObject(jsonRead, path);
        }
        String discColumn = this.inheritInfo.getRoot().getDiscriminatorColumn();
        if (parser.nextToken() != JsonToken.FIELD_NAME) {
            String msg = "Error reading inheritance discriminator - expected [" + discColumn + "] but no json key?";
            throw new JsonParseException(msg, parser.getCurrentLocation());
        }
        String propName = parser.getCurrentName();
        if (!propName.equalsIgnoreCase(discColumn)) {
            BeanProperty property = this.desc.getBeanProperty(propName);
            if (property != null) {
                EntityBean bean = this.desc.createEntityBean();
                property.jsonRead(jsonRead, bean);
                return this.jsonReadProperties(jsonRead, bean, path);
            }
            String msg = "Error reading inheritance discriminator, expected property [" + discColumn + "] but got [" + propName + "] ?";
            throw new JsonParseException(msg, parser.getCurrentLocation());
        }
        String discValue = parser.nextTextValue();
        InheritInfo localInheritInfo = this.inheritInfo.readType(discValue);
        BeanDescriptor<?> localDescriptor = localInheritInfo.getBeanDescriptor();
        return (T)localDescriptor.jsonReadObject(jsonRead, path);
    }

    protected T jsonReadObject(ReadJson readJson, String path) throws IOException {
        EntityBean bean = this.desc.createEntityBean();
        return this.jsonReadProperties(readJson, bean, path);
    }

    protected T jsonReadProperties(ReadJson readJson, EntityBean bean, String path) throws IOException {
        JsonParser parser;
        JsonToken event;
        if (path != null) {
            readJson.pushPath(path);
        }
        LinkedHashMap<String, Object> unmappedProperties = null;
        while (JsonToken.FIELD_NAME == (event = (parser = readJson.getParser()).nextToken())) {
            String key = parser.getCurrentName();
            BeanProperty p = this.desc.getBeanProperty(key);
            if (p != null) {
                p.jsonRead(readJson, bean);
                continue;
            }
            if (unmappedProperties == null) {
                unmappedProperties = new LinkedHashMap<String, Object>();
            }
            unmappedProperties.put(key, EJson.parse(parser));
        }
        if (JsonToken.END_OBJECT != event) {
            throw new RuntimeException("Unexpected token " + event + " - expecting key or end_object at: " + parser.getCurrentLocation());
        }
        readJson.beanVisitor(bean, unmappedProperties);
        if (path != null) {
            readJson.popPath();
        }
        return (T)bean;
    }
}

