/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.event.BeanPersistAdapter;
import com.avaje.ebean.event.BeanPersistRequest;
import com.avaje.ebean.event.BeanPostLoad;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.PersistenceException;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;

public class BeanLifecycleAdapterFactory {
    public void addLifecycleMethods(DeployBeanDescriptor<?> deployDesc) {
        Method[] methods = deployDesc.getBeanType().getMethods();
        MethodsHolder methodHolder = new MethodsHolder();
        for (Method m : methods) {
            methodHolder.checkMethod(m);
        }
        if (methodHolder.hasPersistMethods()) {
            deployDesc.addPersistController(new PersistAdapter(new PersistMethodsHolder(methodHolder)));
        }
        if (!methodHolder.postLoads.isEmpty()) {
            deployDesc.addPostLoad(new PostLoadAdapter(methodHolder.postLoads));
        }
    }

    static Method[] toArray(List<Method> methodList) {
        return methodList.toArray(new Method[methodList.size()]);
    }

    private static class PostLoadAdapter
    implements BeanPostLoad {
        private final Method[] postLoadMethods;

        private PostLoadAdapter(List<Method> postLoadMethods) {
            this.postLoadMethods = BeanLifecycleAdapterFactory.toArray(postLoadMethods);
        }

        @Override
        public boolean isRegisterFor(Class<?> cls) {
            return false;
        }

        private void invoke(Method method, Object bean) {
            try {
                method.invoke(bean, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new PersistenceException("Error invoking lifecycle method", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new PersistenceException("Error invoking lifecycle method", (Throwable)e);
            }
        }

        @Override
        public void postLoad(Object bean) {
            for (int i = 0; i < this.postLoadMethods.length; ++i) {
                this.invoke(this.postLoadMethods[i], bean);
            }
        }
    }

    private static class PersistAdapter
    extends BeanPersistAdapter {
        private final PersistMethodsHolder methodHolder;

        private PersistAdapter(PersistMethodsHolder methodHolder) {
            this.methodHolder = methodHolder;
        }

        @Override
        public boolean isRegisterFor(Class<?> cls) {
            return false;
        }

        private void invoke(Method method, Object bean) {
            try {
                method.invoke(bean, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new PersistenceException("Error invoking lifecycle method", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new PersistenceException("Error invoking lifecycle method", (Throwable)e);
            }
        }

        private void invoke(Method[] methods, BeanPersistRequest<?> request) {
            for (int i = 0; i < methods.length; ++i) {
                this.invoke(methods[i], request.getBean());
            }
        }

        @Override
        public boolean preDelete(BeanPersistRequest<?> request) {
            this.invoke(this.methodHolder.preDeletes, request);
            return true;
        }

        @Override
        public boolean preInsert(BeanPersistRequest<?> request) {
            this.invoke(this.methodHolder.preInserts, request);
            return true;
        }

        @Override
        public boolean preUpdate(BeanPersistRequest<?> request) {
            this.invoke(this.methodHolder.preUpdates, request);
            return true;
        }

        @Override
        public void postDelete(BeanPersistRequest<?> request) {
            this.invoke(this.methodHolder.postDeletes, request);
        }

        @Override
        public void postInsert(BeanPersistRequest<?> request) {
            this.invoke(this.methodHolder.postInserts, request);
        }

        @Override
        public void postUpdate(BeanPersistRequest<?> request) {
            this.invoke(this.methodHolder.postUpdates, request);
        }
    }

    private static class PersistMethodsHolder {
        private final Method[] preInserts;
        private final Method[] postInserts;
        private final Method[] preUpdates;
        private final Method[] postUpdates;
        private final Method[] preDeletes;
        private final Method[] postDeletes;

        PersistMethodsHolder(MethodsHolder methodsHolder) {
            this.preInserts = BeanLifecycleAdapterFactory.toArray(methodsHolder.preInserts);
            this.preUpdates = BeanLifecycleAdapterFactory.toArray(methodsHolder.preUpdates);
            this.preDeletes = BeanLifecycleAdapterFactory.toArray(methodsHolder.preDeletes);
            this.postInserts = BeanLifecycleAdapterFactory.toArray(methodsHolder.postInserts);
            this.postUpdates = BeanLifecycleAdapterFactory.toArray(methodsHolder.postUpdates);
            this.postDeletes = BeanLifecycleAdapterFactory.toArray(methodsHolder.postDeletes);
        }
    }

    private static class MethodsHolder {
        private boolean hasPersistMethods;
        private final List<Method> preInserts = new ArrayList<Method>();
        private final List<Method> postInserts = new ArrayList<Method>();
        private final List<Method> preUpdates = new ArrayList<Method>();
        private final List<Method> postUpdates = new ArrayList<Method>();
        private final List<Method> preDeletes = new ArrayList<Method>();
        private final List<Method> postDeletes = new ArrayList<Method>();
        private final List<Method> postLoads = new ArrayList<Method>();

        private MethodsHolder() {
        }

        private boolean hasPersistMethods() {
            return this.hasPersistMethods;
        }

        private void checkMethod(Method method) {
            if (method.isAnnotationPresent(PrePersist.class)) {
                this.preInserts.add(method);
                this.hasPersistMethods = true;
            }
            if (method.isAnnotationPresent(PostPersist.class)) {
                this.postInserts.add(method);
                this.hasPersistMethods = true;
            }
            if (method.isAnnotationPresent(PreUpdate.class)) {
                this.preUpdates.add(method);
                this.hasPersistMethods = true;
            }
            if (method.isAnnotationPresent(PostUpdate.class)) {
                this.postUpdates.add(method);
                this.hasPersistMethods = true;
            }
            if (method.isAnnotationPresent(PreRemove.class)) {
                this.preDeletes.add(method);
                this.hasPersistMethods = true;
            }
            if (method.isAnnotationPresent(PostRemove.class)) {
                this.postDeletes.add(method);
                this.hasPersistMethods = true;
            }
            if (method.isAnnotationPresent(PostLoad.class)) {
                this.postLoads.add(method);
            }
        }
    }
}

