/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.ValuePair;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.config.EncryptKey;
import com.avaje.ebean.config.dbplatform.DbEncryptFunction;
import com.avaje.ebean.config.dbplatform.DbType;
import com.avaje.ebean.text.StringParser;
import com.avaje.ebeaninternal.server.core.InternString;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyOverride;
import com.avaje.ebeaninternal.server.deploy.DbReadContext;
import com.avaje.ebeaninternal.server.deploy.DbSqlContext;
import com.avaje.ebeaninternal.server.deploy.TableJoin;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedProperty;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedWhenCreated;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedWhenModified;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import com.avaje.ebeaninternal.server.el.ElPropertyChainBuilder;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.lib.util.StringHelper;
import com.avaje.ebeaninternal.server.properties.BeanPropertyGetter;
import com.avaje.ebeaninternal.server.properties.BeanPropertySetter;
import com.avaje.ebeaninternal.server.query.SqlBeanLoad;
import com.avaje.ebeaninternal.server.query.SqlJoinType;
import com.avaje.ebeaninternal.server.text.json.ReadJson;
import com.avaje.ebeaninternal.server.text.json.WriteJson;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.ScalarType;
import com.avaje.ebeaninternal.util.ValueUtil;
import com.fasterxml.jackson.core.JsonToken;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanProperty
implements ElPropertyValue {
    private static final Logger logger = LoggerFactory.getLogger(BeanProperty.class);
    final boolean id;
    final boolean unidirectionalShadow;
    final boolean discriminator;
    final boolean embedded;
    final boolean version;
    final boolean naturalKey;
    final boolean nullable;
    final boolean unique;
    final boolean dbRead;
    final boolean dbInsertable;
    final boolean dbUpdatable;
    final boolean secondaryTable;
    final TableJoin secondaryTableJoin;
    final String secondaryTableJoinPrefix;
    final boolean inherited;
    final Class<?> owningType;
    final boolean local;
    final boolean lob;
    final boolean fetchEager;
    final boolean isTransient;
    final String name;
    final int propertyIndex;
    final Field field;
    final Class<?> propertyType;
    final String dbBind;
    final String dbColumn;
    final String elPlaceHolder;
    final String elPlaceHolderEncrypted;
    final String sqlFormulaSelect;
    final String sqlFormulaJoin;
    final boolean formula;
    final boolean dbEncrypted;
    final boolean localEncrypted;
    final int dbEncryptedType;
    final int dbType;
    final boolean excludedFromHistory;
    final GeneratedProperty generatedProperty;
    final BeanPropertyGetter getter;
    final BeanPropertySetter setter;
    final BeanDescriptor<?> descriptor;
    final ScalarType scalarType;
    final int dbLength;
    final int dbScale;
    final String dbColumnDefn;
    final String dbConstraintExpression;
    final DbEncryptFunction dbEncryptFunction;
    int deployOrder;
    final boolean jsonSerialize;
    final boolean jsonDeserialize;
    final boolean indexed;
    final String indexName;

    public BeanProperty(DeployBeanProperty deploy) {
        this(null, deploy);
    }

    public BeanProperty(BeanDescriptor<?> descriptor, DeployBeanProperty deploy) {
        this.descriptor = descriptor;
        this.name = InternString.intern(deploy.getName());
        this.propertyIndex = deploy.getPropertyIndex();
        this.indexed = deploy.isIndexed();
        this.indexName = deploy.getIndexName();
        this.unidirectionalShadow = deploy.isUndirectionalShadow();
        this.discriminator = deploy.isDiscriminator();
        this.localEncrypted = deploy.isLocalEncrypted();
        this.dbEncrypted = deploy.isDbEncrypted();
        this.dbEncryptedType = deploy.getDbEncryptedType();
        this.dbEncryptFunction = deploy.getDbEncryptFunction();
        this.dbBind = deploy.getDbBind();
        this.dbRead = deploy.isDbRead();
        this.dbInsertable = deploy.isDbInsertable();
        this.dbUpdatable = deploy.isDbUpdateable();
        this.excludedFromHistory = deploy.isExcludedFromHistory();
        this.secondaryTable = deploy.isSecondaryTable();
        if (this.secondaryTable) {
            this.secondaryTableJoin = new TableJoin(deploy.getSecondaryTableJoin());
            this.secondaryTableJoinPrefix = deploy.getSecondaryTableJoinPrefix();
        } else {
            this.secondaryTableJoin = null;
            this.secondaryTableJoinPrefix = null;
        }
        this.fetchEager = deploy.isFetchEager();
        this.isTransient = deploy.isTransient();
        this.nullable = deploy.isNullable();
        this.unique = deploy.isUnique();
        this.naturalKey = deploy.isNaturalKey();
        this.dbLength = deploy.getDbLength();
        this.dbScale = deploy.getDbScale();
        this.dbColumnDefn = InternString.intern(deploy.getDbColumnDefn());
        this.dbConstraintExpression = InternString.intern(deploy.getDbConstraintExpression());
        this.inherited = false;
        this.owningType = deploy.getOwningType();
        this.local = deploy.isLocal();
        this.version = deploy.isVersionColumn();
        this.embedded = deploy.isEmbedded();
        this.id = deploy.isId();
        this.generatedProperty = deploy.getGeneratedProperty();
        this.getter = deploy.getGetter();
        this.setter = deploy.getSetter();
        this.dbColumn = this.tableAliasIntern(descriptor, deploy.getDbColumn(), false, null);
        this.sqlFormulaJoin = InternString.intern(deploy.getSqlFormulaJoin());
        this.sqlFormulaSelect = InternString.intern(deploy.getSqlFormulaSelect());
        this.formula = this.sqlFormulaSelect != null;
        this.dbType = deploy.getDbType();
        this.scalarType = deploy.getScalarType();
        this.lob = this.isLobType(this.dbType);
        this.propertyType = deploy.getPropertyType();
        this.field = deploy.getField();
        this.elPlaceHolder = this.tableAliasIntern(descriptor, deploy.getElPlaceHolder(), false, null);
        this.elPlaceHolderEncrypted = this.tableAliasIntern(descriptor, deploy.getElPlaceHolder(), this.dbEncrypted, this.dbColumn);
        this.jsonSerialize = deploy.isJsonSerialize();
        this.jsonDeserialize = deploy.isJsonDeserialize();
    }

    private String tableAliasIntern(BeanDescriptor<?> descriptor, String s, boolean dbEncrypted, String dbColumn) {
        if (descriptor != null) {
            s = StringHelper.replaceString(s, "${ta}.", "${}");
            s = StringHelper.replaceString(s, "${ta}", "${}");
            if (dbEncrypted) {
                s = this.dbEncryptFunction.getDecryptSql(s);
                String namedParam = ":encryptkey_" + descriptor.getBaseTable() + "___" + dbColumn;
                s = StringHelper.replaceString(s, "?", namedParam);
            }
        }
        return InternString.intern(s);
    }

    public BeanProperty(BeanProperty source, BeanPropertyOverride override) {
        this.descriptor = source.descriptor;
        this.name = InternString.intern(source.getName());
        this.propertyIndex = source.propertyIndex;
        this.indexed = source.isIndexed();
        this.indexName = source.getIndexName();
        this.dbColumn = InternString.intern(override.getDbColumn());
        this.sqlFormulaJoin = null;
        this.sqlFormulaSelect = null;
        this.formula = false;
        this.excludedFromHistory = source.excludedFromHistory;
        this.fetchEager = source.fetchEager;
        this.unidirectionalShadow = source.unidirectionalShadow;
        this.discriminator = source.discriminator;
        this.localEncrypted = source.isLocalEncrypted();
        this.isTransient = source.isTransient();
        this.secondaryTable = source.isSecondaryTable();
        this.secondaryTableJoin = source.secondaryTableJoin;
        this.secondaryTableJoinPrefix = source.secondaryTableJoinPrefix;
        this.dbBind = source.getDbBind();
        this.dbEncrypted = source.isDbEncrypted();
        this.dbEncryptedType = source.getDbEncryptedType();
        this.dbEncryptFunction = source.dbEncryptFunction;
        this.dbRead = source.isDbRead();
        this.dbInsertable = source.isDbInsertable();
        this.dbUpdatable = source.isDbUpdatable();
        this.nullable = source.isNullable();
        this.unique = source.isUnique();
        this.naturalKey = source.isNaturalKey();
        this.dbLength = source.getDbLength();
        this.dbScale = source.getDbScale();
        this.dbColumnDefn = InternString.intern(source.getDbColumnDefn());
        this.dbConstraintExpression = InternString.intern(source.getDbConstraintExpression());
        this.inherited = source.isInherited();
        this.owningType = source.owningType;
        this.local = this.owningType.equals(this.descriptor.getBeanType());
        this.version = source.isVersion();
        this.embedded = source.isEmbedded();
        this.id = source.isId();
        this.generatedProperty = source.getGeneratedProperty();
        this.getter = source.getter;
        this.setter = source.setter;
        this.dbType = source.getDbType();
        this.scalarType = source.scalarType;
        this.lob = this.isLobType(this.dbType);
        this.propertyType = source.getPropertyType();
        this.field = source.getField();
        this.elPlaceHolder = override.replace(source.elPlaceHolder, source.dbColumn);
        this.elPlaceHolderEncrypted = override.replace(source.elPlaceHolderEncrypted, source.dbColumn);
        this.jsonSerialize = source.jsonSerialize;
        this.jsonDeserialize = source.jsonDeserialize;
    }

    public void initialise() {
        if (!this.isTransient && this.scalarType == null) {
            String msg = "No ScalarType assigned to " + this.descriptor.getFullName() + "." + this.getName();
            throw new RuntimeException(msg);
        }
    }

    @Override
    public int getDeployOrder() {
        return this.deployOrder;
    }

    public void setDeployOrder(int deployOrder) {
        this.deployOrder = deployOrder;
    }

    public ElPropertyValue buildElPropertyValue(String propName, String remainder, ElPropertyChainBuilder chain, boolean propertyDeploy) {
        throw new PersistenceException("Not valid on scalar bean property " + this.getFullBeanName());
    }

    public BeanDescriptor<?> getBeanDescriptor() {
        return this.descriptor;
    }

    public boolean isScalar() {
        return true;
    }

    public boolean isFormula() {
        return this.formula;
    }

    public boolean isDiscriminator() {
        return this.discriminator;
    }

    public boolean isMutableScalarType() {
        return this.scalarType != null && this.scalarType.isMutable();
    }

    public EncryptKey getEncryptKey() {
        return this.descriptor.getEncryptKey(this);
    }

    public String getDecryptProperty(String propertyName) {
        return this.dbEncryptFunction.getDecryptSql(propertyName);
    }

    public String getDecryptSql() {
        return this.dbEncryptFunction.getDecryptSql(this.getDbColumn());
    }

    public String getDecryptSql(String tableAlias) {
        return this.dbEncryptFunction.getDecryptSql(tableAlias + "." + this.getDbColumn());
    }

    public void appendFrom(DbSqlContext ctx, SqlJoinType joinType) {
        if (this.formula && this.sqlFormulaJoin != null) {
            ctx.appendFormulaJoin(this.sqlFormulaJoin, joinType);
        } else if (this.secondaryTableJoin != null) {
            String relativePrefix = ctx.getRelativePrefix(this.secondaryTableJoinPrefix);
            this.secondaryTableJoin.addJoin(joinType, relativePrefix, ctx);
        }
    }

    public String getSecondaryTableJoinPrefix() {
        return this.secondaryTableJoinPrefix;
    }

    public void appendSelect(DbSqlContext ctx, boolean subQuery) {
        if (this.formula) {
            ctx.appendFormulaSelect(this.sqlFormulaSelect);
        } else if (!this.isTransient) {
            if (this.secondaryTableJoin != null) {
                String relativePrefix = ctx.getRelativePrefix(this.secondaryTableJoinPrefix);
                ctx.pushTableAlias(relativePrefix);
            }
            if (this.dbEncrypted) {
                String decryptSql = this.getDecryptSql(ctx.peekTableAlias());
                ctx.appendRawColumn(decryptSql);
                ctx.addEncryptedProp(this);
            } else {
                ctx.appendColumn(this.dbColumn);
            }
            if (this.secondaryTableJoin != null) {
                ctx.popTableAlias();
            }
        }
    }

    public boolean isAssignableFrom(Class<?> type) {
        return this.owningType.isAssignableFrom(type);
    }

    public void loadIgnore(DbReadContext ctx) {
        this.scalarType.loadIgnore(ctx.getDataReader());
    }

    public void load(SqlBeanLoad sqlBeanLoad) {
        sqlBeanLoad.load(this);
    }

    public void buildRawSqlSelectChain(String prefix, List<String> selectChain) {
        if (prefix == null) {
            selectChain.add(this.name);
        } else {
            selectChain.add(prefix + "." + this.name);
        }
    }

    public Object read(DbReadContext ctx) throws SQLException {
        return this.scalarType.read(ctx.getDataReader());
    }

    public Object readSet(DbReadContext ctx, EntityBean bean) throws SQLException {
        try {
            Object value = this.scalarType.read(ctx.getDataReader());
            if (bean != null) {
                this.setValue(bean, value);
            }
            return value;
        }
        catch (Exception e) {
            throw new PersistenceException("Error readSet on " + this.descriptor + "." + this.name, (Throwable)e);
        }
    }

    public void bind(DataBind b, Object value) throws SQLException {
        this.scalarType.bind(b, value);
    }

    public void writeData(DataOutput dataOutput, Object value) throws IOException {
        this.scalarType.writeData(dataOutput, value);
    }

    public Object readData(DataInput dataInput) throws IOException {
        return this.scalarType.readData(dataInput);
    }

    @Override
    public BeanProperty getBeanProperty() {
        return this;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setValue(EntityBean bean, Object value) {
        try {
            this.setter.set(bean, value);
        }
        catch (Exception ex) {
            String beanType = bean == null ? "null" : bean.getClass().getName();
            String msg = "set " + this.name + " on [" + this.descriptor + "] arg[" + value + "] type[" + beanType + "] threw error";
            throw new RuntimeException(msg, ex);
        }
    }

    public void setValueIntercept(EntityBean bean, Object value) {
        try {
            this.setter.setIntercept(bean, value);
        }
        catch (Exception ex) {
            String beanType = bean == null ? "null" : bean.getClass().getName();
            String msg = "setIntercept " + this.name + " on [" + this.descriptor + "] arg[" + value + "] type[" + beanType + "] threw error";
            throw new RuntimeException(msg, ex);
        }
    }

    public Object getCacheDataValue(EntityBean bean) {
        return this.getValue(bean);
    }

    public void setCacheDataValue(EntityBean bean, Object cacheData) {
        this.setValue(bean, cacheData);
    }

    public Object getValueObject(Object bean) {
        throw new RuntimeException("Expected to be called only on BeanPropertyCompoundScalar");
    }

    public Object getValue(EntityBean bean) {
        try {
            return this.getter.get(bean);
        }
        catch (Exception ex) {
            String beanType = bean == null ? "null" : bean.getClass().getName();
            String msg = "get " + this.name + " on [" + this.descriptor + "] type[" + beanType + "] threw error.";
            throw new RuntimeException(msg, ex);
        }
    }

    public Object getValueIntercept(EntityBean bean) {
        try {
            return this.getter.getIntercept(bean);
        }
        catch (Exception ex) {
            String beanType = bean == null ? "null" : bean.getClass().getName();
            String msg = "getIntercept " + this.name + " on [" + this.descriptor + "] type[" + beanType + "] threw error.";
            throw new RuntimeException(msg, ex);
        }
    }

    @Override
    public Object elConvertType(Object value) {
        if (value == null) {
            return null;
        }
        return this.convertToLogicalType(value);
    }

    @Override
    public void elSetValue(EntityBean bean, Object value, boolean populate) {
        if (bean != null) {
            this.setValue(bean, value);
        }
    }

    @Override
    public Object elGetValue(EntityBean bean) {
        if (bean == null) {
            return null;
        }
        return this.getValueIntercept(bean);
    }

    @Override
    public Object elGetReference(EntityBean bean) {
        throw new RuntimeException("Not expected to call this");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getPropertyIndex() {
        return this.propertyIndex;
    }

    @Override
    public String getElName() {
        return this.name;
    }

    @Override
    public boolean containsFormulaWithJoin() {
        return this.formula && this.sqlFormulaJoin != null;
    }

    @Override
    public boolean containsManySince(String sinceProperty) {
        return this.containsMany();
    }

    @Override
    public boolean containsMany() {
        return false;
    }

    @Override
    public Object[] getAssocOneIdValues(EntityBean bean) {
        return null;
    }

    @Override
    public String getAssocOneIdExpr(String prefix, String operator) {
        return null;
    }

    @Override
    public String getAssocIdInExpr(String prefix) {
        return null;
    }

    @Override
    public String getAssocIdInValueExpr(int size) {
        return null;
    }

    @Override
    public boolean isAssocId() {
        return false;
    }

    @Override
    public boolean isAssocProperty() {
        return false;
    }

    @Override
    public String getElPlaceholder(boolean encrypted) {
        return encrypted ? this.elPlaceHolderEncrypted : this.elPlaceHolder;
    }

    @Override
    public String getElPrefix() {
        return this.secondaryTableJoinPrefix;
    }

    public String getFullBeanName() {
        return this.descriptor.getFullName() + "." + this.name;
    }

    public boolean isDirtyValue(Object value) {
        return this.scalarType.isDirty(value);
    }

    public ScalarType<Object> getScalarType() {
        return this.scalarType;
    }

    @Override
    public StringParser getStringParser() {
        return this.scalarType;
    }

    @Override
    public boolean isDateTimeCapable() {
        return this.scalarType != null && this.scalarType.isDateTimeCapable();
    }

    @Override
    public int getJdbcType() {
        return this.scalarType == null ? 0 : this.scalarType.getJdbcType();
    }

    @Override
    public Object parseDateTime(long systemTimeMillis) {
        return this.scalarType.convertFromMillis(systemTimeMillis);
    }

    public int getDbLength() {
        return this.dbLength;
    }

    public int getDbScale() {
        return this.dbScale;
    }

    public String getDbColumnDefn() {
        return this.dbColumnDefn;
    }

    public String getDbConstraintExpression() {
        return this.dbConstraintExpression;
    }

    public String renderDbType(DbType dbType) {
        if (this.dbColumnDefn != null) {
            return this.dbColumnDefn;
        }
        return dbType.renderType(this.dbLength, this.dbScale);
    }

    public Field getField() {
        return this.field;
    }

    public GeneratedProperty getGeneratedProperty() {
        return this.generatedProperty;
    }

    public boolean isNaturalKey() {
        return this.naturalKey;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isDDLNotNull() {
        return this.isVersion() || this.generatedProperty != null && this.generatedProperty.isDDLNotNullable();
    }

    public boolean isGeneratedWhenCreated() {
        return this.generatedProperty instanceof GeneratedWhenCreated;
    }

    public boolean isGeneratedWhenModified() {
        return this.generatedProperty instanceof GeneratedWhenModified;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isLoadProperty() {
        return !this.isTransient || this.formula;
    }

    public boolean isVersion() {
        return this.version;
    }

    @Override
    public String getDbColumn() {
        return this.dbColumn;
    }

    public int getDbType() {
        return this.dbType;
    }

    public Object convertToLogicalType(Object value) {
        if (this.scalarType != null) {
            return this.scalarType.toBeanType(value);
        }
        return value;
    }

    public boolean isFetchEager() {
        return this.fetchEager;
    }

    public boolean isLob() {
        return this.lob;
    }

    private boolean isLobType(int type) {
        switch (type) {
            case 2005: {
                return true;
            }
            case 2004: {
                return true;
            }
            case -4: {
                return true;
            }
            case -1: {
                return true;
            }
        }
        return false;
    }

    public String getDbBind() {
        return this.dbBind;
    }

    @Override
    public boolean isLocalEncrypted() {
        return this.localEncrypted;
    }

    @Override
    public boolean isDbEncrypted() {
        return this.dbEncrypted;
    }

    public int getDbEncryptedType() {
        return this.dbEncryptedType;
    }

    public boolean isExcludedFromHistory() {
        return this.excludedFromHistory;
    }

    public boolean isDbInsertable() {
        return this.dbInsertable;
    }

    public boolean isDbUpdatable() {
        return this.dbUpdatable;
    }

    public boolean isDbRead() {
        return this.dbRead;
    }

    public boolean isSecondaryTable() {
        return this.secondaryTable;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public boolean isId() {
        return this.id;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public String toString() {
        return this.name;
    }

    public void jsonWrite(WriteJson writeJson, EntityBean bean) throws IOException {
        if (!this.jsonSerialize) {
            return;
        }
        Object value = this.getValueIntercept(bean);
        if (value == null) {
            writeJson.writeNullField(this.name);
        } else if (this.scalarType != null) {
            this.scalarType.jsonWrite(writeJson, this.name, value);
        } else {
            writeJson.writeValueUsingObjectMapper(this.name, value);
        }
    }

    public void jsonRead(ReadJson ctx, EntityBean bean) throws IOException {
        JsonToken event = ctx.nextToken();
        if (JsonToken.VALUE_NULL == event) {
            if (this.jsonDeserialize) {
                this.setValue(bean, null);
            }
        } else {
            Object objValue;
            if (this.scalarType != null) {
                objValue = this.scalarType.jsonRead(ctx.getParser(), event);
            } else {
                try {
                    objValue = ctx.readValueUsingObjectMapper(this.propertyType);
                }
                catch (IOException e) {
                    objValue = null;
                    String msg = "Error trying to use Jackson ObjectMapper to read transient property " + this.getFullBeanName() + " - consider marking this property with @JsonIgnore";
                    logger.error(msg, (Throwable)e);
                }
            }
            if (this.jsonDeserialize) {
                this.setValue(bean, objValue);
            }
        }
    }

    public void diffForInsert(String prefix, Map<String, ValuePair> map, EntityBean newBean) {
        Object newVal;
        Object object = newVal = newBean == null ? null : this.getValue(newBean);
        if (newVal != null) {
            String propName = prefix == null ? this.name : prefix + "." + this.name;
            map.put(propName, new ValuePair(newVal, null));
        }
    }

    public void diff(String prefix, Map<String, ValuePair> map, EntityBean newBean, EntityBean oldBean) {
        Object newVal = newBean == null ? null : this.getValue(newBean);
        Object oldVal = oldBean == null ? null : this.getValue(oldBean);
        this.diffVal(prefix, map, newVal, oldVal);
    }

    public void diffVal(String prefix, Map<String, ValuePair> map, Object newVal, Object oldVal) {
        if (!ValueUtil.areEqual(newVal, oldVal)) {
            String propName = prefix == null ? this.name : prefix + "." + this.name;
            map.put(propName, new ValuePair(newVal, oldVal));
        }
    }
}

