/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.Query;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.BeanCollectionAdd;
import com.avaje.ebean.bean.BeanCollectionLoader;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.common.BeanSet;
import com.avaje.ebeaninternal.server.deploy.BeanCollectionHelp;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.text.json.WriteJson;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;

public final class BeanSetHelp<T>
implements BeanCollectionHelp<T> {
    private final BeanPropertyAssocMany<T> many;
    private final BeanDescriptor<T> targetDescriptor;
    private final String propertyName;
    private BeanCollectionLoader loader;

    public BeanSetHelp(BeanPropertyAssocMany<T> many) {
        this.many = many;
        this.targetDescriptor = many.getTargetDescriptor();
        this.propertyName = many.getName();
    }

    public BeanSetHelp() {
        this.many = null;
        this.targetDescriptor = null;
        this.propertyName = null;
    }

    @Override
    public void setLoader(BeanCollectionLoader loader) {
        this.loader = loader;
    }

    @Override
    public BeanCollectionAdd getBeanCollectionAdd(Object bc, String mapKey) {
        if (bc instanceof BeanSet) {
            BeanSet beanSet = (BeanSet)bc;
            if (beanSet.getActualSet() == null) {
                beanSet.setActualSet(new LinkedHashSet());
            }
            return beanSet;
        }
        throw new RuntimeException("Unhandled type " + bc);
    }

    @Override
    public void add(BeanCollection<?> collection, EntityBean bean) {
        collection.internalAdd(bean);
    }

    @Override
    public BeanCollection<T> createEmptyNoParent() {
        return new BeanSet();
    }

    @Override
    public BeanCollection<T> createEmpty(EntityBean ownerBean) {
        BeanSet beanSet = new BeanSet(this.loader, ownerBean, this.propertyName);
        if (this.many != null) {
            beanSet.setModifyListening(this.many.getModifyListenMode());
        }
        return beanSet;
    }

    @Override
    public BeanCollection<T> createReference(EntityBean parentBean) {
        BeanSet beanSet = new BeanSet(this.loader, parentBean, this.propertyName);
        beanSet.setModifyListening(this.many.getModifyListenMode());
        return beanSet;
    }

    @Override
    public void refresh(EbeanServer server, Query<?> query, Transaction t, EntityBean parentBean) {
        BeanSet newBeanSet = (BeanSet)server.findSet(query, t);
        this.refresh(newBeanSet, parentBean);
    }

    @Override
    public void refresh(BeanCollection<?> bc, EntityBean parentBean) {
        BeanSet newBeanSet = (BeanSet)bc;
        Set current = (Set)this.many.getValue(parentBean);
        newBeanSet.setModifyListening(this.many.getModifyListenMode());
        if (current == null) {
            this.many.setValue(parentBean, newBeanSet);
        } else if (current instanceof BeanSet) {
            BeanSet currentBeanSet = (BeanSet)current;
            currentBeanSet.setActualSet(newBeanSet.getActualSet());
            currentBeanSet.setModifyListening(this.many.getModifyListenMode());
        } else {
            this.many.setValue(parentBean, newBeanSet);
        }
    }

    @Override
    public void jsonWrite(WriteJson ctx, String name, Object collection, boolean explicitInclude) throws IOException {
        Set set;
        if (collection instanceof BeanCollection) {
            BeanSet bc = (BeanSet)collection;
            if (!bc.isPopulated()) {
                if (explicitInclude) {
                    bc.size();
                } else {
                    return;
                }
            }
            set = bc.getActualSet();
        } else {
            set = (Set)collection;
        }
        if (!set.isEmpty() || ctx.isIncludeEmpty()) {
            ctx.beginAssocMany(name);
            for (Object bean : set) {
                this.targetDescriptor.jsonWrite(ctx, (EntityBean)bean);
            }
            ctx.endAssocMany();
        }
    }
}

