/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.event.BeanPersistListener;
import com.avaje.ebeaninternal.server.core.BootupClasses;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistListenerManager {
    private static final Logger logger = LoggerFactory.getLogger(PersistListenerManager.class);
    private final List<BeanPersistListener> list;

    public PersistListenerManager(BootupClasses bootupClasses) {
        this.list = bootupClasses.getBeanPersistListeners();
    }

    public int getRegisterCount() {
        return this.list.size();
    }

    public <T> void addPersistListeners(DeployBeanDescriptor<T> deployDesc) {
        for (int i = 0; i < this.list.size(); ++i) {
            BeanPersistListener listener = this.list.get(i);
            if (!listener.isRegisterFor(deployDesc.getBeanType())) continue;
            logger.debug("BeanPersistListener on[{}] {}", (Object)deployDesc.getFullName(), (Object)listener.getClass().getName());
            deployDesc.addPersistListener(listener);
        }
    }
}

