/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy.meta;

import com.avaje.ebean.annotation.ConcurrencyMode;
import com.avaje.ebean.config.TableName;
import com.avaje.ebean.config.dbplatform.IdGenerator;
import com.avaje.ebean.config.dbplatform.IdType;
import com.avaje.ebean.event.BeanFindController;
import com.avaje.ebean.event.BeanPersistController;
import com.avaje.ebean.event.BeanPersistListener;
import com.avaje.ebean.event.BeanPostLoad;
import com.avaje.ebean.event.BeanQueryAdapter;
import com.avaje.ebean.event.changelog.ChangeLogFilter;
import com.avaje.ebeaninternal.server.core.CacheOptions;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.ChainedBeanPersistController;
import com.avaje.ebeaninternal.server.deploy.ChainedBeanPersistListener;
import com.avaje.ebeaninternal.server.deploy.ChainedBeanPostLoad;
import com.avaje.ebeaninternal.server.deploy.ChainedBeanQueryAdapter;
import com.avaje.ebeaninternal.server.deploy.CompoundUniqueConstraint;
import com.avaje.ebeaninternal.server.deploy.DRawSqlMeta;
import com.avaje.ebeaninternal.server.deploy.DeployNamedQuery;
import com.avaje.ebeaninternal.server.deploy.DeployNamedUpdate;
import com.avaje.ebeaninternal.server.deploy.InheritInfo;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssoc;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanTable;
import com.avaje.ebeaninternal.server.deploy.meta.DeployTableJoin;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;

public class DeployBeanDescriptor<T> {
    private static final PropOrder PROP_ORDER = new PropOrder();
    private static final String I_SCALAOBJECT = "scala.ScalaObject";
    private LinkedHashMap<String, DeployBeanProperty> propMap = new LinkedHashMap();
    private BeanDescriptor.EntityType entityType;
    private final Map<String, DeployNamedQuery> namedQueries = new LinkedHashMap<String, DeployNamedQuery>();
    private final Map<String, DeployNamedUpdate> namedUpdates = new LinkedHashMap<String, DeployNamedUpdate>();
    private final Map<String, DRawSqlMeta> rawSqlMetas = new LinkedHashMap<String, DRawSqlMeta>();
    private DeployBeanPropertyAssocOne<?> unidirectional;
    private IdType idType;
    private boolean idTypePlatformDefault;
    private String idGeneratorName;
    private IdGenerator idGenerator;
    private String sequenceName;
    private int sequenceInitialValue;
    private int sequenceAllocationSize;
    private String selectLastInsertedId;
    private ConcurrencyMode concurrencyMode;
    private boolean updateChangesOnly;
    private List<CompoundUniqueConstraint> compoundUniqueConstraints;
    private String baseTable;
    private String baseTableAsOf;
    private String baseTableVersionsBetween;
    private boolean historySupport;
    private boolean readAuditing;
    private TableName baseTableFull;
    private String[] properties;
    private final Class<T> beanType;
    private final List<BeanPersistController> persistControllers = new ArrayList<BeanPersistController>();
    private final List<BeanPersistListener> persistListeners = new ArrayList<BeanPersistListener>();
    private final List<BeanQueryAdapter> queryAdapters = new ArrayList<BeanQueryAdapter>();
    private final List<BeanPostLoad> postLoaders = new ArrayList<BeanPostLoad>();
    private final CacheOptions cacheOptions = new CacheOptions();
    private BeanFindController beanFinder;
    private final ArrayList<DeployTableJoin> tableJoinList = new ArrayList(2);
    private InheritInfo inheritInfo;
    private String name;
    private boolean processedRawSqlExtend;
    private ChangeLogFilter changeLogFilter;

    public DeployBeanDescriptor(Class<T> beanType) {
        this.beanType = beanType;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.beanType.getModifiers());
    }

    public void setHistorySupport() {
        this.historySupport = true;
    }

    public boolean isHistorySupport() {
        return this.historySupport;
    }

    public void setReadAuditing() {
        this.readAuditing = true;
    }

    public boolean isReadAuditing() {
        return this.readAuditing;
    }

    public boolean isScalaObject() {
        Class<?>[] interfaces = this.beanType.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            String iname = interfaces[i].getName();
            if (!I_SCALAOBJECT.equals(iname)) continue;
            return true;
        }
        return false;
    }

    public Collection<DRawSqlMeta> getRawSqlMeta() {
        if (!this.processedRawSqlExtend) {
            this.rawSqlProcessExtend();
            this.processedRawSqlExtend = true;
        }
        return this.rawSqlMetas.values();
    }

    private void rawSqlProcessExtend() {
        for (DRawSqlMeta rawSqlMeta : this.rawSqlMetas.values()) {
            String extend = rawSqlMeta.getExtend();
            if (extend == null) continue;
            DRawSqlMeta parentQuery = this.rawSqlMetas.get(extend);
            if (parentQuery == null) {
                throw new RuntimeException("parent query [" + extend + "] not found for sql-select " + rawSqlMeta.getName());
            }
            rawSqlMeta.extend(parentQuery);
        }
    }

    public DeployBeanTable createDeployBeanTable() {
        DeployBeanTable beanTable = new DeployBeanTable(this.getBeanType());
        beanTable.setBaseTable(this.baseTable);
        beanTable.setIdProperties(this.propertiesId());
        return beanTable;
    }

    public void setEntityType(BeanDescriptor.EntityType entityType) {
        this.entityType = entityType;
    }

    public boolean isEmbedded() {
        return BeanDescriptor.EntityType.EMBEDDED.equals((Object)this.entityType);
    }

    public boolean isBaseTableType() {
        BeanDescriptor.EntityType et = this.getEntityType();
        return BeanDescriptor.EntityType.ORM.equals((Object)et);
    }

    public BeanDescriptor.EntityType getEntityType() {
        if (this.entityType == null) {
            this.entityType = BeanDescriptor.EntityType.ORM;
        }
        return this.entityType;
    }

    public void setSequenceInitialValue(int sequenceInitialValue) {
        this.sequenceInitialValue = sequenceInitialValue;
    }

    public void setSequenceAllocationSize(int sequenceAllocationSize) {
        this.sequenceAllocationSize = sequenceAllocationSize;
    }

    public int getSequenceInitialValue() {
        return this.sequenceInitialValue;
    }

    public int getSequenceAllocationSize() {
        return this.sequenceAllocationSize;
    }

    public void add(DRawSqlMeta rawSqlMeta) {
        this.rawSqlMetas.put(rawSqlMeta.getName(), rawSqlMeta);
        if ("default".equals(rawSqlMeta.getName())) {
            this.setEntityType(BeanDescriptor.EntityType.SQL);
        }
    }

    public void add(DeployNamedUpdate namedUpdate) {
        this.namedUpdates.put(namedUpdate.getName(), namedUpdate);
    }

    public void add(DeployNamedQuery namedQuery) {
        this.namedQueries.put(namedQuery.getName(), namedQuery);
        if ("default".equals(namedQuery.getName())) {
            this.setEntityType(BeanDescriptor.EntityType.SQL);
        }
    }

    public Map<String, DeployNamedQuery> getNamedQueries() {
        return this.namedQueries;
    }

    public Map<String, DeployNamedUpdate> getNamedUpdates() {
        return this.namedUpdates;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public void setProperties(String[] props) {
        this.properties = props;
    }

    public Class<T> getBeanType() {
        return this.beanType;
    }

    public void setChangeLogFilter(ChangeLogFilter changeLogFilter) {
        this.changeLogFilter = changeLogFilter;
    }

    public ChangeLogFilter getChangeLogFilter() {
        return this.changeLogFilter;
    }

    public InheritInfo getInheritInfo() {
        return this.inheritInfo;
    }

    public void setInheritInfo(InheritInfo inheritInfo) {
        this.inheritInfo = inheritInfo;
    }

    public CacheOptions getCacheOptions() {
        return this.cacheOptions;
    }

    public DeployBeanPropertyAssocOne<?> getUnidirectional() {
        return this.unidirectional;
    }

    public void setUnidirectional(DeployBeanPropertyAssocOne<?> unidirectional) {
        this.unidirectional = unidirectional;
    }

    public ConcurrencyMode getConcurrencyMode() {
        return this.concurrencyMode;
    }

    public void setConcurrencyMode(ConcurrencyMode concurrencyMode) {
        this.concurrencyMode = concurrencyMode;
    }

    public boolean isUpdateChangesOnly() {
        return this.updateChangesOnly;
    }

    public void setUpdateChangesOnly(boolean updateChangesOnly) {
        this.updateChangesOnly = updateChangesOnly;
    }

    public void addCompoundUniqueConstraint(CompoundUniqueConstraint c) {
        if (this.compoundUniqueConstraints == null) {
            this.compoundUniqueConstraints = new ArrayList<CompoundUniqueConstraint>();
        }
        this.compoundUniqueConstraints.add(c);
    }

    public CompoundUniqueConstraint[] getCompoundUniqueConstraints() {
        if (this.compoundUniqueConstraints == null) {
            return null;
        }
        return this.compoundUniqueConstraints.toArray(new CompoundUniqueConstraint[this.compoundUniqueConstraints.size()]);
    }

    public BeanFindController getBeanFinder() {
        return this.beanFinder;
    }

    public void setBeanFinder(BeanFindController beanFinder) {
        this.beanFinder = beanFinder;
    }

    public BeanPersistController getPersistController() {
        if (this.persistControllers.size() == 0) {
            return null;
        }
        if (this.persistControllers.size() == 1) {
            return this.persistControllers.get(0);
        }
        return new ChainedBeanPersistController(this.persistControllers);
    }

    public BeanPersistListener getPersistListener() {
        if (this.persistListeners.size() == 0) {
            return null;
        }
        if (this.persistListeners.size() == 1) {
            return this.persistListeners.get(0);
        }
        return new ChainedBeanPersistListener(this.persistListeners);
    }

    public BeanQueryAdapter getQueryAdapter() {
        if (this.queryAdapters.size() == 0) {
            return null;
        }
        if (this.queryAdapters.size() == 1) {
            return this.queryAdapters.get(0);
        }
        return new ChainedBeanQueryAdapter(this.queryAdapters);
    }

    public BeanPostLoad getPostLoad() {
        if (this.postLoaders.size() == 0) {
            return null;
        }
        if (this.postLoaders.size() == 1) {
            return this.postLoaders.get(0);
        }
        return new ChainedBeanPostLoad(this.postLoaders);
    }

    public void addPersistController(BeanPersistController controller) {
        this.persistControllers.add(controller);
    }

    public void addPersistListener(BeanPersistListener listener) {
        this.persistListeners.add(listener);
    }

    public void addQueryAdapter(BeanQueryAdapter queryAdapter) {
        this.queryAdapters.add(queryAdapter);
    }

    public void addPostLoad(BeanPostLoad postLoad) {
        this.postLoaders.add(postLoad);
    }

    public String getBaseTable() {
        return this.baseTable;
    }

    public String getBaseTableAsOf() {
        return this.baseTableAsOf;
    }

    public String getBaseTableVersionsBetween() {
        return this.baseTableVersionsBetween;
    }

    public TableName getBaseTableFull() {
        return this.baseTableFull;
    }

    public void setBaseTable(TableName baseTableFull, String asOfSuffix, String versionsBetweenSuffix) {
        this.baseTableFull = baseTableFull;
        this.baseTable = baseTableFull == null ? null : baseTableFull.getQualifiedName();
        this.baseTableAsOf = this.baseTable + asOfSuffix;
        this.baseTableVersionsBetween = this.baseTable + versionsBetweenSuffix;
    }

    public void sortProperties() {
        ArrayList<DeployBeanProperty> list = new ArrayList<DeployBeanProperty>();
        list.addAll(this.propMap.values());
        Collections.sort(list, PROP_ORDER);
        this.propMap = new LinkedHashMap(list.size());
        for (int i = 0; i < list.size(); ++i) {
            this.addBeanProperty((DeployBeanProperty)list.get(i));
        }
    }

    public DeployBeanProperty addBeanProperty(DeployBeanProperty prop) {
        return this.propMap.put(prop.getName(), prop);
    }

    public DeployBeanProperty getBeanProperty(String propName) {
        return this.propMap.get(propName);
    }

    public String getFullName() {
        return this.beanType.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public void setIdType(IdType idType) {
        this.idType = idType;
    }

    public void setIdTypePlatformDefault() {
        this.idTypePlatformDefault = true;
    }

    public boolean isIdTypePlatformDefault() {
        return this.idTypePlatformDefault;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public String getSelectLastInsertedId() {
        return this.selectLastInsertedId;
    }

    public void setSelectLastInsertedId(String selectLastInsertedId) {
        this.selectLastInsertedId = selectLastInsertedId;
    }

    public String getIdGeneratorName() {
        return this.idGeneratorName;
    }

    public void setIdGeneratorName(String idGeneratorName) {
        this.idGeneratorName = idGeneratorName;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
        if (idGenerator != null && idGenerator.isDbSequence()) {
            this.setSequenceName(idGenerator.getName());
        }
    }

    public String toString() {
        return this.getFullName();
    }

    public void addTableJoin(DeployTableJoin join) {
        this.tableJoinList.add(join);
    }

    public List<DeployTableJoin> getTableJoins() {
        return this.tableJoinList;
    }

    public Collection<DeployBeanProperty> propertiesAll() {
        return this.propMap.values();
    }

    public String getDefaultSelectClause() {
        StringBuilder sb = new StringBuilder();
        boolean hasLazyFetch = false;
        for (DeployBeanProperty prop : this.propMap.values()) {
            if (prop.isTransient() || prop instanceof DeployBeanPropertyAssocMany) continue;
            if (prop.isFetchEager()) {
                sb.append(prop.getName()).append(",");
                continue;
            }
            hasLazyFetch = true;
        }
        if (!hasLazyFetch) {
            return null;
        }
        String selectClause = sb.toString();
        if (selectClause.length() == 0) {
            throw new IllegalStateException("Bean " + this.getFullName() + " has no properties?");
        }
        return selectClause.substring(0, selectClause.length() - 1);
    }

    public Set<String> parseDefaultSelectClause(String rawList) {
        if (rawList == null) {
            return null;
        }
        String[] res = rawList.split(",");
        LinkedHashSet<String> set = new LinkedHashSet<String>(res.length + 3);
        for (int i = 0; i < res.length; ++i) {
            String temp = res[i].trim();
            if (temp.length() <= 0) continue;
            set.add(temp);
        }
        return Collections.unmodifiableSet(set);
    }

    public boolean isPrimaryKeyCompoundOrNonNumeric() {
        List<DeployBeanProperty> ids = this.propertiesId();
        if (ids.size() != 1) {
            return true;
        }
        DeployBeanProperty p = ids.get(0);
        if (p instanceof DeployBeanPropertyAssocOne) {
            return ((DeployBeanPropertyAssocOne)p).isCompound();
        }
        return !p.isDbNumberType();
    }

    public String getSinglePrimaryKeyColumn() {
        List<DeployBeanProperty> ids = this.propertiesId();
        if (ids.size() == 1) {
            DeployBeanProperty p = ids.get(0);
            if (p instanceof DeployBeanPropertyAssoc) {
                return null;
            }
            return p.getDbColumn();
        }
        return null;
    }

    public List<DeployBeanProperty> propertiesId() {
        ArrayList<DeployBeanProperty> list = new ArrayList<DeployBeanProperty>(2);
        for (DeployBeanProperty prop : this.propMap.values()) {
            if (!prop.isId()) continue;
            list.add(prop);
        }
        return list;
    }

    public DeployBeanPropertyAssocOne<?> findJoinToTable(String tableName) {
        List<DeployBeanPropertyAssocOne<?>> assocOne = this.propertiesAssocOne();
        for (DeployBeanPropertyAssocOne<?> prop : assocOne) {
            DeployTableJoin tableJoin = prop.getTableJoin();
            if (tableJoin == null || !tableJoin.getTable().equalsIgnoreCase(tableName)) continue;
            return prop;
        }
        return null;
    }

    public List<DeployBeanPropertyAssocOne<?>> propertiesAssocOne() {
        ArrayList list = new ArrayList();
        for (DeployBeanProperty prop : this.propMap.values()) {
            if (!(prop instanceof DeployBeanPropertyAssocOne) || prop.isEmbedded()) continue;
            list.add((DeployBeanPropertyAssocOne)prop);
        }
        return list;
    }

    public List<DeployBeanPropertyAssocMany<?>> propertiesAssocMany() {
        ArrayList list = new ArrayList();
        for (DeployBeanProperty prop : this.propMap.values()) {
            if (!(prop instanceof DeployBeanPropertyAssocMany)) continue;
            list.add((DeployBeanPropertyAssocMany)prop);
        }
        return list;
    }

    public List<DeployBeanProperty> propertiesBase() {
        ArrayList<DeployBeanProperty> list = new ArrayList<DeployBeanProperty>();
        for (DeployBeanProperty prop : this.propMap.values()) {
            if (prop instanceof DeployBeanPropertyAssoc || prop.isId()) continue;
            list.add(prop);
        }
        return list;
    }

    public void checkInheritanceMapping() {
        if (this.inheritInfo == null) {
            this.checkInheritance(this.getBeanType());
        }
    }

    private void checkInheritance(Class<?> beanType) {
        Class<?> parent = beanType.getSuperclass();
        if (parent == null || Object.class.equals(parent)) {
            return;
        }
        if (parent.isAnnotationPresent(Entity.class)) {
            String msg = "Checking " + this.getBeanType() + " and found " + parent + " that has @Entity annotation rather than MappedSuperclass?";
            throw new IllegalStateException(msg);
        }
        if (parent.isAnnotationPresent(MappedSuperclass.class)) {
            this.checkInheritance(parent);
        }
    }

    static class PropOrder
    implements Comparator<DeployBeanProperty> {
        PropOrder() {
        }

        @Override
        public int compare(DeployBeanProperty o1, DeployBeanProperty o2) {
            int v2 = o1.getSortOrder();
            int v1 = o2.getSortOrder();
            return v1 < v2 ? -1 : (v1 == v2 ? 0 : 1);
        }
    }
}

