/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy.parse;

import com.avaje.ebeaninternal.api.ClassUtil;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorManager;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedPropertyFactory;
import com.avaje.ebeaninternal.server.deploy.parse.AnnotationAssocManys;
import com.avaje.ebeaninternal.server.deploy.parse.AnnotationAssocOnes;
import com.avaje.ebeaninternal.server.deploy.parse.AnnotationClass;
import com.avaje.ebeaninternal.server.deploy.parse.AnnotationFields;
import com.avaje.ebeaninternal.server.deploy.parse.AnnotationSql;
import com.avaje.ebeaninternal.server.deploy.parse.DeployBeanInfo;

public class ReadAnnotations {
    private final GeneratedPropertyFactory generatedPropFactory;
    private final String asOfViewSuffix;
    private final String versionsBetweenSuffix;
    private final boolean javaxValidationAnnotations;
    private final boolean jacksonAnnotations;

    public ReadAnnotations(GeneratedPropertyFactory generatedPropFactory, String asOfViewSuffix, String versionsBetweenSuffix) {
        this.generatedPropFactory = generatedPropFactory;
        this.asOfViewSuffix = asOfViewSuffix;
        this.versionsBetweenSuffix = versionsBetweenSuffix;
        this.javaxValidationAnnotations = ClassUtil.isJavaxValidationAnnotationsPresent();
        this.jacksonAnnotations = ClassUtil.isJacksonAnnotationsPresent();
    }

    public void readInitial(DeployBeanInfo<?> info, boolean eagerFetchLobs) {
        try {
            new AnnotationClass(info, this.javaxValidationAnnotations, this.asOfViewSuffix, this.versionsBetweenSuffix).parse();
            new AnnotationFields(this.generatedPropFactory, info, this.javaxValidationAnnotations, this.jacksonAnnotations, eagerFetchLobs).parse();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error reading annotations for " + info, e);
        }
    }

    public void readAssociations(DeployBeanInfo<?> info, BeanDescriptorManager factory) {
        try {
            new AnnotationAssocOnes(info, this.javaxValidationAnnotations, factory).parse();
            new AnnotationAssocManys(info, this.javaxValidationAnnotations, factory).parse();
            new AnnotationSql(info, this.javaxValidationAnnotations).parse();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error reading annotations for " + info, e);
        }
    }
}

