/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.expression.AbstractExpression;
import java.util.Collection;

class InExpression
extends AbstractExpression {
    private static final long serialVersionUID = 3150665801693551260L;
    private final boolean not;
    private final Object[] values;

    InExpression(String propertyName, Collection<?> coll, boolean not) {
        super(propertyName);
        this.values = coll.toArray(new Object[coll.size()]);
        this.not = not;
    }

    InExpression(String propertyName, Object[] array, boolean not) {
        super(propertyName);
        this.values = array;
        this.not = not;
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && !prop.isAssocId()) {
            prop = null;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (prop == null) {
                request.addBindValue(this.values[i]);
                continue;
            }
            Object[] ids = prop.getAssocOneIdValues((EntityBean)this.values[i]);
            if (ids == null) continue;
            for (int j = 0; j < ids.length; ++j) {
                request.addBindValue(ids[j]);
            }
        }
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        if (this.values.length == 0) {
            if (!this.not) {
                request.append("1=0");
            }
            return;
        }
        String propertyName = this.getPropertyName();
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && !prop.isAssocId()) {
            prop = null;
        }
        if (prop != null) {
            request.append(prop.getAssocIdInExpr(propertyName));
            String inClause = prop.getAssocIdInValueExpr(this.values.length);
            request.append(inClause);
        } else {
            request.append(propertyName);
            if (this.not) {
                request.append(" not");
            }
            request.append(" in (?");
            for (int i = 1; i < this.values.length; ++i) {
                request.append(", ").append("?");
            }
            request.append(" ) ");
        }
    }

    @Override
    public void queryAutoTuneHash(HashQueryPlanBuilder builder) {
        builder.add(InExpression.class).add(this.propName).add(this.values.length).add(this.not);
        builder.bind(this.values.length);
    }

    @Override
    public void queryPlanHash(BeanQueryRequest<?> request, HashQueryPlanBuilder builder) {
        this.queryAutoTuneHash(builder);
    }

    @Override
    public int queryBindHash() {
        int hc = 31;
        for (int i = 0; i < this.values.length; ++i) {
            hc = 31 * hc + this.values[i].hashCode();
        }
        return hc;
    }
}

