/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.expression.AbstractExpression;
import com.avaje.ebeaninternal.server.expression.Op;

public class SimpleExpression
extends AbstractExpression {
    private static final long serialVersionUID = -382881395755603790L;
    private final Op type;
    private final Object value;

    public SimpleExpression(String propertyName, Op type, Object value) {
        super(propertyName);
        this.type = type;
        this.value = value;
    }

    public boolean isOpEquals() {
        return Op.EQ.equals((Object)this.type);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null) {
            if (prop.isAssocId()) {
                Object[] ids = prop.getAssocOneIdValues((EntityBean)this.value);
                if (ids != null) {
                    for (int i = 0; i < ids.length; ++i) {
                        request.addBindValue(ids[i]);
                    }
                }
                return;
            }
            if (prop.isDbEncrypted()) {
                String encryptKey = prop.getBeanProperty().getEncryptKey().getStringValue();
                request.addBindValue(encryptKey);
            }
        }
        request.addBindValue(this.value);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        String propertyName = this.getPropertyName();
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null) {
            if (prop.isAssocId()) {
                request.append(prop.getAssocOneIdExpr(propertyName, this.type.bind()));
                return;
            }
            if (prop.isDbEncrypted()) {
                String dsql = prop.getBeanProperty().getDecryptSql();
                request.append(dsql).append(this.type.bind());
                return;
            }
        }
        request.append(propertyName).append(this.type.bind());
    }

    @Override
    public void queryAutoTuneHash(HashQueryPlanBuilder builder) {
        builder.add(SimpleExpression.class).add(this.propName).add(this.type.name());
        builder.bind(1);
    }

    @Override
    public void queryPlanHash(BeanQueryRequest<?> request, HashQueryPlanBuilder builder) {
        this.queryAutoTuneHash(builder);
    }

    @Override
    public int queryBindHash() {
        return this.value.hashCode();
    }

    public Object getValue() {
        return this.value;
    }
}

