/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.lib.sql;

import com.avaje.ebeaninternal.server.lib.sql.PooledConnection;
import com.avaje.ebeaninternal.server.lib.sql.PooledConnectionStatistics;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BusyConnectionBuffer {
    private static final Logger logger = LoggerFactory.getLogger(BusyConnectionBuffer.class);
    private PooledConnection[] slots;
    private final int growBy;
    private int size;
    private int pos = -1;

    protected BusyConnectionBuffer(int capacity, int growBy) {
        this.slots = new PooledConnection[capacity];
        this.growBy = growBy;
    }

    protected void setCapacity(int newCapacity) {
        if (newCapacity > this.slots.length) {
            PooledConnection[] current = this.slots;
            this.slots = new PooledConnection[newCapacity];
            System.arraycopy(current, 0, this.slots, 0, current.length);
        }
    }

    public String toString() {
        return Arrays.toString(this.slots);
    }

    protected int getCapacity() {
        return this.slots.length;
    }

    protected int size() {
        return this.size;
    }

    protected boolean isEmpty() {
        return this.size == 0;
    }

    protected int add(PooledConnection pc) {
        if (this.size == this.slots.length) {
            this.setCapacity(this.slots.length + this.growBy);
        }
        int slot = this.nextEmptySlot();
        pc.setSlotId(slot);
        this.slots[slot] = pc;
        return ++this.size;
    }

    protected boolean remove(PooledConnection pc) {
        int slotId = pc.getSlotId();
        if (this.slots[slotId] != pc) {
            PooledConnection heldBy = this.slots[slotId];
            logger.warn("Failed to remove from slot[{}] PooledConnection[{}] - HeldBy[{}]", new Object[]{pc.getSlotId(), pc, heldBy});
            return false;
        }
        this.slots[slotId] = null;
        --this.size;
        return true;
    }

    protected void collectStatistics(PooledConnectionStatistics.LoadValues values, boolean reset) {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            values.plus(this.slots[i].getStatistics().getValues(reset));
        }
    }

    protected void closeBusyConnections(long leakTimeMinutes) {
        long olderThanTime = System.currentTimeMillis() - leakTimeMinutes * 60000L;
        logger.debug("Closing busy connections using leakTimeMinutes {}", (Object)leakTimeMinutes);
        for (int i = 0; i < this.slots.length; ++i) {
            PooledConnection pc;
            if (this.slots[i] == null || (pc = this.slots[i]).isLongRunning() || pc.getLastUsedTime() > olderThanTime) continue;
            this.slots[i] = null;
            --this.size;
            this.closeBusyConnection(pc);
        }
    }

    private void closeBusyConnection(PooledConnection pc) {
        try {
            logger.warn("DataSourcePool closing busy connection? " + pc.getFullDescription());
            System.out.println("CLOSING busy connection: " + pc.getFullDescription());
            pc.closeConnectionFully(false);
        }
        catch (Exception ex) {
            logger.error("Error when closing potentially leaked connection " + pc.getDescription(), (Throwable)ex);
        }
    }

    protected String getBusyConnectionInformation(boolean toLogger) {
        if (toLogger) {
            logger.info("Dumping [{}] busy connections: (Use datasource.xxx.capturestacktrace=true  ... to get stackTraces)", (Object)this.size());
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            PooledConnection pc = this.slots[i];
            if (toLogger) {
                logger.info("Busy Connection - {}", (Object)pc.getFullDescription());
                continue;
            }
            sb.append(pc.getFullDescription()).append("\r\n");
        }
        return sb.toString();
    }

    private int nextEmptySlot() {
        while (++this.pos < this.slots.length) {
            if (this.slots[this.pos] != null) continue;
            return this.pos;
        }
        this.pos = -1;
        while (++this.pos < this.slots.length) {
            if (this.slots[this.pos] != null) continue;
            return this.pos;
        }
        throw new RuntimeException("No Empty Slot Found?");
    }
}

