/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.Query;
import com.avaje.ebean.RawSql;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.SqlLimitResponse;
import com.avaje.ebean.config.dbplatform.SqlLimiter;
import com.avaje.ebean.event.readaudit.ReadAuditQueryPlan;
import com.avaje.ebean.text.PathProperties;
import com.avaje.ebeaninternal.api.ManyWhereJoins;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.persist.Binder;
import com.avaje.ebeaninternal.server.query.CQuery;
import com.avaje.ebeaninternal.server.query.CQueryBuilderRawSql;
import com.avaje.ebeaninternal.server.query.CQueryDelete;
import com.avaje.ebeaninternal.server.query.CQueryFetchIds;
import com.avaje.ebeaninternal.server.query.CQueryHistorySupport;
import com.avaje.ebeaninternal.server.query.CQueryPlan;
import com.avaje.ebeaninternal.server.query.CQueryPlanRawSql;
import com.avaje.ebeaninternal.server.query.CQueryPredicates;
import com.avaje.ebeaninternal.server.query.CQueryRowCount;
import com.avaje.ebeaninternal.server.query.RawSqlSelectClauseBuilder;
import com.avaje.ebeaninternal.server.query.SplitName;
import com.avaje.ebeaninternal.server.query.SqlTree;
import com.avaje.ebeaninternal.server.query.SqlTreeBuilder;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryDetail;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryLimitRequest;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.PersistenceException;

public class CQueryBuilder {
    private final String tableAliasPlaceHolder;
    private final String columnAliasPrefix;
    private final SqlLimiter sqlLimiter;
    private final RawSqlSelectClauseBuilder sqlSelectBuilder;
    private final CQueryBuilderRawSql rawSqlHandler;
    private final Binder binder;
    private final boolean selectCountWithAlias;
    private final CQueryHistorySupport historySupport;
    private final DatabasePlatform dbPlatform;

    public CQueryBuilder(DatabasePlatform dbPlatform, Binder binder, CQueryHistorySupport historySupport) {
        this.dbPlatform = dbPlatform;
        this.binder = binder;
        this.historySupport = historySupport;
        this.tableAliasPlaceHolder = dbPlatform.getTableAliasPlaceHolder();
        this.columnAliasPrefix = dbPlatform.getColumnAliasPrefix();
        this.sqlSelectBuilder = new RawSqlSelectClauseBuilder(dbPlatform, binder);
        this.sqlLimiter = dbPlatform.getSqlLimiter();
        this.rawSqlHandler = new CQueryBuilderRawSql(this.sqlLimiter, dbPlatform);
        this.selectCountWithAlias = dbPlatform.isSelectCountWithAlias();
    }

    public static String prefixOrderByFields(String name, String orderBy) {
        StringBuilder sb = new StringBuilder();
        for (String token : orderBy.split(",")) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(name);
            sb.append(".");
            sb.append(token.trim());
        }
        return sb.toString();
    }

    public <T> CQueryDelete buildDeleteQuery(OrmQueryRequest<T> request) {
        String sql;
        Query query = request.getQuery();
        query.setDelete();
        CQueryPredicates predicates = new CQueryPredicates(this.binder, request);
        CQueryPlan queryPlan = request.getQueryPlan();
        if (queryPlan != null) {
            predicates.prepare(false);
            String sql2 = queryPlan.getSql();
            return new CQueryDelete(request, predicates, sql2);
        }
        predicates.prepare(true);
        SqlTree sqlTree = this.createSqlTree(request, predicates, this.getHistorySupport((SpiQuery<T>)query));
        boolean includeJoins = sqlTree.isIncludeJoins();
        if (!includeJoins) {
            sql = this.buildSql("delete", request, predicates, sqlTree).getSql();
        } else {
            sql = this.buildSql(null, request, predicates, sqlTree).getSql();
            sql = request.getBeanDescriptor().getDeleteByIdInSql() + "in (" + sql + ")";
        }
        queryPlan = new CQueryPlan(request, sql, sqlTree, false, false, predicates.getLogWhereSql());
        request.putQueryPlan(queryPlan);
        return new CQueryDelete(request, predicates, sql);
    }

    public <T> CQueryFetchIds buildFetchIdsQuery(OrmQueryRequest<T> request) {
        Query query = request.getQuery();
        query.setSelectId();
        CQueryPredicates predicates = new CQueryPredicates(this.binder, request);
        CQueryPlan queryPlan = request.getQueryPlan();
        if (queryPlan != null) {
            predicates.prepare(false);
            String sql = queryPlan.getSql();
            return new CQueryFetchIds(request, predicates, sql);
        }
        predicates.prepare(true);
        SqlTree sqlTree = this.createSqlTree(request, predicates, this.getHistorySupport((SpiQuery<T>)query));
        SqlLimitResponse s = this.buildSql(null, request, predicates, sqlTree);
        String sql = s.getSql();
        queryPlan = new CQueryPlan(request, sql, sqlTree, false, s.isIncludesRowNumberColumn(), predicates.getLogWhereSql());
        request.putQueryPlan(queryPlan);
        return new CQueryFetchIds(request, predicates, sql);
    }

    private <T> CQueryHistorySupport getHistorySupport(SpiQuery<T> query) {
        return query.getTemporalMode() != SpiQuery.TemporalMode.CURRENT ? this.historySupport : null;
    }

    public <T> CQueryRowCount buildRowCountQuery(OrmQueryRequest<T> request) {
        Query query = request.getQuery();
        query.setOrder(null);
        query.setFirstRow(0);
        query.setMaxRows(0);
        ManyWhereJoins manyWhereJoins = query.getManyWhereJoins();
        boolean hasMany = manyWhereJoins.isHasMany();
        if (manyWhereJoins.isSelectId()) {
            query.setSelectId();
        } else {
            query.select(manyWhereJoins.getFormulaProperties());
        }
        String sqlSelect = "select count(*)";
        if (hasMany) {
            query.setSqlDistinct(true);
            sqlSelect = null;
        }
        CQueryPredicates predicates = new CQueryPredicates(this.binder, request);
        CQueryPlan queryPlan = request.getQueryPlan();
        if (queryPlan != null) {
            predicates.prepare(false);
            String sql = queryPlan.getSql();
            return new CQueryRowCount(request, predicates, sql);
        }
        predicates.prepare(true);
        SqlTree sqlTree = this.createSqlTree(request, predicates, this.getHistorySupport((SpiQuery<T>)query));
        SqlLimitResponse s = this.buildSql(sqlSelect, request, predicates, sqlTree);
        String sql = s.getSql();
        if (hasMany || query.isRawSql()) {
            sql = "select count(*) from ( " + sql + ")";
            if (this.selectCountWithAlias) {
                sql = sql + " as c";
            }
        }
        queryPlan = new CQueryPlan(request, sql, sqlTree, false, s.isIncludesRowNumberColumn(), predicates.getLogWhereSql());
        request.putQueryPlan(queryPlan);
        return new CQueryRowCount(request, predicates, sql);
    }

    public <T> CQuery<T> buildQuery(OrmQueryRequest<T> request) {
        if (request.isSqlSelect()) {
            return this.sqlSelectBuilder.build(request);
        }
        CQueryPredicates predicates = new CQueryPredicates(this.binder, request);
        CQueryPlan queryPlan = request.getQueryPlan();
        if (queryPlan != null) {
            predicates.prepare(false);
            return new CQuery<T>(request, predicates, queryPlan);
        }
        predicates.prepare(true);
        Query query = request.getQuery();
        SqlTree sqlTree = this.createSqlTree(request, predicates, this.getHistorySupport((SpiQuery<T>)query));
        if (query.isAsOfQuery()) {
            sqlTree.addAsOfTableAlias((SpiQuery<?>)query);
        }
        SqlLimitResponse res = this.buildSql(null, request, predicates, sqlTree);
        boolean rawSql = request.isRawSql();
        queryPlan = rawSql ? new CQueryPlanRawSql(request, res, sqlTree, predicates.getLogWhereSql()) : new CQueryPlan(request, res, sqlTree, false, predicates.getLogWhereSql());
        BeanDescriptor<T> desc = request.getBeanDescriptor();
        if (desc.isReadAuditing()) {
            desc.getReadAuditLogger().queryPlan(new ReadAuditQueryPlan(desc.getFullName(), queryPlan.getAuditQueryKey(), queryPlan.getSql()));
        }
        request.putQueryPlan(queryPlan);
        return new CQuery<T>(request, predicates, queryPlan);
    }

    private SqlTree createSqlTree(OrmQueryRequest<?> request, CQueryPredicates predicates, CQueryHistorySupport historySupport) {
        if (request.isRawSql()) {
            return this.createRawSqlSqlTree(request, predicates);
        }
        return new SqlTreeBuilder(this.tableAliasPlaceHolder, this.columnAliasPrefix, request, predicates, historySupport).build();
    }

    private SqlTree createRawSqlSqlTree(OrmQueryRequest<?> request, CQueryPredicates predicates) {
        BeanDescriptor<?> descriptor = request.getBeanDescriptor();
        RawSql.ColumnMapping columnMapping = request.getQuery().getRawSql().getColumnMapping();
        PathProperties pathProps = new PathProperties();
        Iterator<RawSql.ColumnMapping.Column> it = columnMapping.getColumns();
        while (it.hasNext()) {
            RawSql.ColumnMapping.Column column = it.next();
            Object propertyName = column.getPropertyName();
            if ("$$_IGNORE_COLUMN_$$".equals(propertyName)) continue;
            ElPropertyValue el = descriptor.getElGetValue((String)propertyName);
            if (el == null) {
                throw new PersistenceException("Property [" + (String)propertyName + "] not found on " + descriptor.getFullName());
            }
            BeanProperty beanProperty = el.getBeanProperty();
            if (beanProperty.isId() || beanProperty.isDiscriminator()) {
                propertyName = SplitName.parent((String)propertyName);
            } else if (beanProperty instanceof BeanPropertyAssocOne) {
                String msg = "Column [" + column.getDbColumn() + "] mapped to complex Property[" + (String)propertyName + "]";
                msg = msg + ". It should be mapped to a simple property (probably the Id property). ";
                throw new PersistenceException(msg);
            }
            if (propertyName == null) continue;
            String[] pathProp = SplitName.split((String)propertyName);
            pathProps.addToPath(pathProp[0], pathProp[1]);
        }
        OrmQueryDetail detail = new OrmQueryDetail();
        for (String path : pathProps.getPaths()) {
            Set<String> props = pathProps.get(path);
            detail.getChunk(path, true).setDefaultProperties(null, props);
        }
        boolean rawNoId = true;
        BeanProperty idProperty = descriptor.getIdProperty();
        if (idProperty != null && columnMapping.contains(idProperty.getName())) {
            rawNoId = false;
        }
        return new SqlTreeBuilder(request, predicates, detail, rawNoId).build();
    }

    private SqlLimitResponse buildSql(String selectClause, OrmQueryRequest<?> request, CQueryPredicates predicates, SqlTree select) {
        List<String> asOfTableAlias;
        String dbFilterMany;
        String dbWhere;
        Query query = request.getQuery();
        RawSql rawSql = query.getRawSql();
        if (rawSql != null) {
            return this.rawSqlHandler.buildSql(request, predicates, rawSql.getSql());
        }
        BeanPropertyAssocMany<?> manyProp = select.getManyProperty();
        boolean useSqlLimiter = false;
        StringBuilder sb = new StringBuilder(500);
        String dbOrderBy = predicates.getDbOrderBy();
        if (selectClause != null) {
            sb.append(selectClause);
        } else {
            boolean bl = useSqlLimiter = query.hasMaxRowsOrFirstRow() && manyProp == null;
            if (!useSqlLimiter) {
                sb.append("select ");
                if (query.isDistinctQuery()) {
                    sb.append("distinct ");
                }
            }
            sb.append(select.getSelectSql());
            if (query.isDistinctQuery() && dbOrderBy != null) {
                sb.append(", ").append(this.convertDbOrderByForSelect(dbOrderBy));
            }
        }
        sb.append(" from ");
        sb.append(select.getFromSql());
        String inheritanceWhere = select.getInheritanceWhereSql();
        boolean hasWhere = false;
        if (inheritanceWhere.length() > 0) {
            sb.append(" where");
            sb.append(inheritanceWhere);
            hasWhere = true;
        }
        if (request.isFindById() || query.getId() != null) {
            if (hasWhere) {
                sb.append(" and ");
            } else {
                sb.append(" where ");
            }
            BeanDescriptor<?> desc = request.getBeanDescriptor();
            String idSql = desc.getIdBinderIdSql();
            if (idSql.isEmpty()) {
                throw new IllegalStateException("Executing FindById query on entity bean " + desc.getName() + " that doesn't have an @Id property??");
            }
            sb.append(idSql).append(" ");
            hasWhere = true;
        }
        if (!this.isEmpty(dbWhere = predicates.getDbWhere())) {
            if (!hasWhere) {
                hasWhere = true;
                sb.append(" where ");
            } else {
                sb.append(" and ");
            }
            sb.append(dbWhere);
        }
        if (!this.isEmpty(dbFilterMany = predicates.getDbFilterMany())) {
            if (!hasWhere) {
                hasWhere = true;
                sb.append(" where ");
            } else {
                sb.append("and ");
            }
            sb.append(dbFilterMany);
        }
        if ((asOfTableAlias = query.getAsOfTableAlias()) != null && !this.historySupport.isBindAtFromClause()) {
            if (!hasWhere) {
                sb.append(" where ");
            } else {
                sb.append("and ");
            }
            for (int i = 0; i < asOfTableAlias.size(); ++i) {
                if (i > 0) {
                    sb.append(" and ");
                }
                sb.append(this.historySupport.getAsOfPredicate(asOfTableAlias.get(i)));
            }
        }
        if (dbOrderBy != null) {
            sb.append(" order by ").append(dbOrderBy);
        }
        if (useSqlLimiter) {
            OrmQueryLimitRequest r = new OrmQueryLimitRequest(sb.toString(), dbOrderBy, (SpiQuery<?>)query, this.dbPlatform);
            return this.sqlLimiter.limit(r);
        }
        return new SqlLimitResponse(this.dbPlatform.completeSql(sb.toString(), query), false);
    }

    private String convertDbOrderByForSelect(String dbOrderBy) {
        return dbOrderBy.replaceAll("(?i)\\b asc\\b|\\b desc\\b", "");
    }

    private boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

