/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.DbSqlContext;
import com.avaje.ebeaninternal.server.deploy.TableJoinColumn;
import com.avaje.ebeaninternal.server.lib.util.StringHelper;
import com.avaje.ebeaninternal.server.query.CQueryHistorySupport;
import com.avaje.ebeaninternal.server.query.SqlJoinType;
import com.avaje.ebeaninternal.server.query.SqlTreeAlias;
import com.avaje.ebeaninternal.server.util.ArrayStack;
import java.util.ArrayList;
import java.util.HashSet;

public class DefaultDbSqlContext
implements DbSqlContext {
    private static final String COMMA = ", ";
    private static final String PERIOD = ".";
    private static final int STRING_BUILDER_INITIAL_CAPACITY = 140;
    private final String tableAliasPlaceHolder;
    private final String columnAliasPrefix;
    private final ArrayStack<String> tableAliasStack = new ArrayStack();
    private final ArrayStack<String> joinStack = new ArrayStack();
    private final ArrayStack<String> prefixStack = new ArrayStack();
    private final boolean useColumnAlias;
    private int columnIndex;
    private StringBuilder sb = new StringBuilder(140);
    private HashSet<String> formulaJoins;
    private HashSet<String> tableJoins;
    private final SqlTreeAlias alias;
    private String currentPrefix;
    private ArrayList<BeanProperty> encryptedProps;
    private final CQueryHistorySupport historySupport;
    private final boolean historyQuery;

    public DefaultDbSqlContext(SqlTreeAlias alias, String tableAliasPlaceHolder, String columnAliasPrefix, boolean alwaysUseColumnAlias, CQueryHistorySupport historySupport) {
        this.alias = alias;
        this.tableAliasPlaceHolder = tableAliasPlaceHolder;
        this.columnAliasPrefix = columnAliasPrefix;
        this.useColumnAlias = alwaysUseColumnAlias;
        this.historySupport = historySupport;
        this.historyQuery = historySupport != null;
    }

    @Override
    public void addEncryptedProp(BeanProperty p) {
        if (this.encryptedProps == null) {
            this.encryptedProps = new ArrayList();
        }
        this.encryptedProps.add(p);
    }

    @Override
    public BeanProperty[] getEncryptedProps() {
        if (this.encryptedProps == null) {
            return null;
        }
        return this.encryptedProps.toArray(new BeanProperty[this.encryptedProps.size()]);
    }

    @Override
    public String peekJoin() {
        return this.joinStack.peek();
    }

    @Override
    public void popJoin() {
        this.joinStack.pop();
    }

    @Override
    public void pushJoin(String node) {
        this.joinStack.push(node);
    }

    @Override
    public void addJoin(String type, String table, TableJoinColumn[] cols, String a1, String a2, String inheritance) {
        String joinKey;
        if (this.tableJoins == null) {
            this.tableJoins = new HashSet();
        }
        if (this.tableJoins.contains(joinKey = table + "-" + a1 + "-" + a2)) {
            return;
        }
        this.tableJoins.add(joinKey);
        this.sb.append(" ");
        this.sb.append(type);
        if (!this.historyQuery) {
            this.sb.append(" ").append(table).append(" ");
        } else {
            String withHistoryTable = this.historySupport.getAsOfView(table);
            if (withHistoryTable != null) {
                this.sb.append(" ").append(withHistoryTable).append(" ");
            } else {
                this.sb.append(" ").append(table).append(" ");
            }
        }
        this.sb.append(a2);
        this.sb.append(" on ");
        for (int i = 0; i < cols.length; ++i) {
            TableJoinColumn pair = cols[i];
            if (i > 0) {
                this.sb.append(" and ");
            }
            this.sb.append(a2);
            this.sb.append(PERIOD).append(pair.getForeignDbColumn());
            this.sb.append(" = ");
            this.sb.append(a1);
            this.sb.append(PERIOD).append(pair.getLocalDbColumn());
        }
        if (inheritance != null && inheritance.length() > 0) {
            this.sb.append(" and ");
            this.sb.append(a2);
            this.sb.append(PERIOD);
            this.sb.append(inheritance);
        }
        this.sb.append(" ");
    }

    @Override
    public String getTableAlias(String prefix) {
        return this.alias.getTableAlias(prefix);
    }

    @Override
    public String getTableAliasManyWhere(String prefix) {
        return this.alias.getTableAliasManyWhere(prefix);
    }

    @Override
    public void pushSecondaryTableAlias(String alias) {
        this.tableAliasStack.push(alias);
    }

    @Override
    public String getRelativePrefix(String propName) {
        return this.currentPrefix == null ? propName : this.currentPrefix + PERIOD + propName;
    }

    @Override
    public void pushTableAlias(String prefix) {
        this.prefixStack.push(this.currentPrefix);
        this.currentPrefix = prefix;
        this.tableAliasStack.push(this.getTableAlias(prefix));
    }

    @Override
    public void popTableAlias() {
        this.tableAliasStack.pop();
        this.currentPrefix = this.prefixStack.pop();
    }

    @Override
    public DefaultDbSqlContext append(String s) {
        this.sb.append(s);
        return this;
    }

    @Override
    public DefaultDbSqlContext append(char s) {
        this.sb.append(s);
        return this;
    }

    @Override
    public void appendFormulaJoin(String sqlFormulaJoin, SqlJoinType joinType) {
        String tableAlias = this.tableAliasStack.peek();
        String converted = StringHelper.replaceString(sqlFormulaJoin, this.tableAliasPlaceHolder, tableAlias);
        if (this.formulaJoins == null) {
            this.formulaJoins = new HashSet();
        } else if (this.formulaJoins.contains(converted)) {
            return;
        }
        this.formulaJoins.add(converted);
        this.sb.append(" ");
        if (joinType == SqlJoinType.OUTER && "join".equals(sqlFormulaJoin.substring(0, 4).toLowerCase())) {
            this.append(" left outer ");
        }
        this.sb.append(converted);
        this.sb.append(" ");
    }

    @Override
    public void appendFormulaSelect(String sqlFormulaSelect) {
        String tableAlias = this.tableAliasStack.peek();
        String converted = StringHelper.replaceString(sqlFormulaSelect, this.tableAliasPlaceHolder, tableAlias);
        this.sb.append(COMMA);
        this.sb.append(converted);
    }

    @Override
    public void appendHistorySysPeriod() {
        String tableAlias = this.tableAliasStack.peek();
        this.sb.append(COMMA);
        this.sb.append(this.historySupport.getSysPeriodLower(tableAlias));
        this.appendColumnAlias();
        this.sb.append(COMMA);
        this.sb.append(this.historySupport.getSysPeriodUpper(tableAlias));
        this.appendColumnAlias();
    }

    private void appendColumnAlias() {
        if (this.useColumnAlias) {
            this.sb.append(" ");
            this.sb.append(this.columnAliasPrefix);
            this.sb.append(this.columnIndex);
        }
        ++this.columnIndex;
    }

    @Override
    public void appendColumn(String column) {
        this.appendColumn(this.tableAliasStack.peek(), column);
    }

    @Override
    public void appendColumn(String tableAlias, String column) {
        this.sb.append(COMMA);
        if (column.contains("${}")) {
            String x = StringHelper.replaceString(column, "${}", tableAlias);
            this.sb.append(x);
        } else {
            this.sb.append(tableAlias);
            this.sb.append(PERIOD);
            this.sb.append(column);
        }
        this.appendColumnAlias();
    }

    @Override
    public String peekTableAlias() {
        return this.tableAliasStack.peek();
    }

    @Override
    public void appendRawColumn(String rawcolumnWithTableAlias) {
        this.sb.append(COMMA);
        this.sb.append(rawcolumnWithTableAlias);
        this.appendColumnAlias();
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public String getContent() {
        String s = this.sb.toString();
        this.sb = new StringBuilder(140);
        return s;
    }

    public String toString() {
        return "DefaultDbSqlContext: " + this.sb.toString();
    }
}

