/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.TransactionEventTable;
import com.avaje.ebeaninternal.server.cluster.BinaryMessageList;
import com.avaje.ebeaninternal.server.transaction.BeanPersistIds;
import com.avaje.ebeaninternal.server.transaction.DeleteByIdMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RemoteTransactionEvent
implements Runnable {
    private final List<BeanPersistIds> beanPersistList = new ArrayList<BeanPersistIds>();
    private List<TransactionEventTable.TableIUD> tableList;
    private DeleteByIdMap deleteByIdMap;
    private String serverName;
    private transient SpiEbeanServer server;

    public RemoteTransactionEvent(String serverName) {
        this.serverName = serverName;
    }

    public RemoteTransactionEvent(SpiEbeanServer server) {
        this.server = server;
    }

    @Override
    public void run() {
        this.server.remoteTransactionEvent(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.beanPersistList);
        if (this.tableList != null) {
            sb.append(this.tableList);
        }
        return sb.toString();
    }

    public void writeBinaryMessage(BinaryMessageList msgList) throws IOException {
        int i;
        if (this.tableList != null) {
            for (i = 0; i < this.tableList.size(); ++i) {
                this.tableList.get(i).writeBinaryMessage(msgList);
            }
        }
        if (this.deleteByIdMap != null) {
            for (BeanPersistIds deleteIds : this.deleteByIdMap.values()) {
                deleteIds.writeBinaryMessage(msgList);
            }
        }
        if (this.beanPersistList != null) {
            for (i = 0; i < this.beanPersistList.size(); ++i) {
                this.beanPersistList.get(i).writeBinaryMessage(msgList);
            }
        }
    }

    public boolean isEmpty() {
        return this.beanPersistList.isEmpty() && (this.tableList == null || this.tableList.isEmpty());
    }

    public void addBeanPersistIds(BeanPersistIds beanPersist) {
        this.beanPersistList.add(beanPersist);
    }

    public void addTableIUD(TransactionEventTable.TableIUD tableIud) {
        if (this.tableList == null) {
            this.tableList = new ArrayList<TransactionEventTable.TableIUD>(4);
        }
        this.tableList.add(tableIud);
    }

    public String getServerName() {
        return this.serverName;
    }

    public SpiEbeanServer getServer() {
        return this.server;
    }

    public void setServer(SpiEbeanServer server) {
        this.server = server;
    }

    public DeleteByIdMap getDeleteByIdMap() {
        return this.deleteByIdMap;
    }

    public void setDeleteByIdMap(DeleteByIdMap deleteByIdMap) {
        this.deleteByIdMap = deleteByIdMap;
    }

    public List<TransactionEventTable.TableIUD> getTableIUDList() {
        return this.tableList;
    }

    public List<BeanPersistIds> getBeanPersistList() {
        return this.beanPersistList;
    }
}

