/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.config.PersistBatch;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.dbmigration.DbOffline;
import com.avaje.ebean.event.TransactionEventListener;
import com.avaje.ebean.event.changelog.ChangeLogListener;
import com.avaje.ebean.event.changelog.ChangeLogPrepare;
import com.avaje.ebean.event.changelog.ChangeSet;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.api.TransactionEvent;
import com.avaje.ebeaninternal.api.TransactionEventTable;
import com.avaje.ebeaninternal.server.cluster.ClusterManager;
import com.avaje.ebeaninternal.server.core.BootupClasses;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorManager;
import com.avaje.ebeaninternal.server.lib.sql.DataSourcePool;
import com.avaje.ebeaninternal.server.transaction.BeanPersistIds;
import com.avaje.ebeaninternal.server.transaction.BulkEventListenerMap;
import com.avaje.ebeaninternal.server.transaction.ExternalJdbcTransaction;
import com.avaje.ebeaninternal.server.transaction.JdbcTransaction;
import com.avaje.ebeaninternal.server.transaction.PostCommitProcessing;
import com.avaje.ebeaninternal.server.transaction.RemoteTransactionEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManager {
    private static final Logger logger = LoggerFactory.getLogger(TransactionManager.class);
    public static final Logger SQL_LOGGER = LoggerFactory.getLogger((String)"org.avaje.ebean.SQL");
    public static final Logger SUM_LOGGER = LoggerFactory.getLogger((String)"org.avaje.ebean.SUM");
    public static final Logger TXN_LOGGER = LoggerFactory.getLogger((String)"org.avaje.ebean.TXN");
    protected final BeanDescriptorManager beanDescriptorManager;
    protected final String prefix;
    protected final String externalTransPrefix;
    protected final DataSource dataSource;
    protected final DatabasePlatform.OnQueryOnly onQueryOnly;
    protected final BackgroundExecutor backgroundExecutor;
    protected final ClusterManager clusterManager;
    protected final String serverName;
    protected final PersistBatch persistBatch;
    protected final PersistBatch persistBatchOnCascade;
    protected final AtomicLong transactionCounter = new AtomicLong(1000L);
    protected final BulkEventListenerMap bulkEventListenerMap;
    protected final TransactionEventListener[] transactionEventListeners;
    private final ChangeLogPrepare changeLogPrepare;
    private final ChangeLogListener changeLogListener;

    public TransactionManager(ClusterManager clusterManager, BackgroundExecutor backgroundExecutor, ServerConfig config, BeanDescriptorManager descMgr, BootupClasses bootupClasses) {
        this.persistBatch = config.getPersistBatch();
        this.persistBatchOnCascade = config.appliedPersistBatchOnCascade();
        this.beanDescriptorManager = descMgr;
        this.changeLogPrepare = descMgr.getChangeLogPrepare();
        this.changeLogListener = descMgr.getChangeLogListener();
        this.clusterManager = clusterManager;
        this.serverName = config.getName();
        this.backgroundExecutor = backgroundExecutor;
        this.dataSource = config.getDataSource();
        this.bulkEventListenerMap = new BulkEventListenerMap(config.getBulkTableEventListeners());
        List<TransactionEventListener> transactionEventListeners = bootupClasses.getTransactionEventListeners();
        this.transactionEventListeners = transactionEventListeners.toArray(new TransactionEventListener[transactionEventListeners.size()]);
        this.prefix = "";
        this.externalTransPrefix = "e";
        this.onQueryOnly = this.initOnQueryOnly(config.getDatabasePlatform().getOnQueryOnly(), this.dataSource);
        this.initialiseHeartbeat();
    }

    private void initialiseHeartbeat() {
        if (this.dataSource instanceof DataSourcePool) {
            DataSourcePool ds = (DataSourcePool)this.dataSource;
            this.backgroundExecutor.executePeriodically(ds.getHeartbeatRunnable(), ds.getHeartbeatFreqSecs(), TimeUnit.SECONDS);
        }
    }

    public void shutdown(boolean shutdownDataSource, boolean deregisterDriver) {
        if (shutdownDataSource && this.dataSource instanceof DataSourcePool) {
            ((DataSourcePool)this.dataSource).shutdown(deregisterDriver);
        }
    }

    public BeanDescriptorManager getBeanDescriptorManager() {
        return this.beanDescriptorManager;
    }

    public BulkEventListenerMap getBulkEventListenerMap() {
        return this.bulkEventListenerMap;
    }

    public PersistBatch getPersistBatch() {
        return this.persistBatch;
    }

    public PersistBatch getPersistBatchOnCascade() {
        return this.persistBatchOnCascade;
    }

    private DatabasePlatform.OnQueryOnly initOnQueryOnly(DatabasePlatform.OnQueryOnly dbPlatformOnQueryOnly, DataSource ds) {
        String systemPropertyValue = System.getProperty("ebean.transaction.onqueryonly");
        if (systemPropertyValue != null) {
            return DatabasePlatform.OnQueryOnly.valueOf(systemPropertyValue.trim().toUpperCase());
        }
        if (DatabasePlatform.OnQueryOnly.CLOSE.equals((Object)dbPlatformOnQueryOnly)) {
            if (!this.isReadCommittedIsolation(ds)) {
                logger.warn("Ignoring DatabasePlatform.OnQueryOnly.CLOSE as the transaction Isolation Level is not READ_COMMITTED");
                return DatabasePlatform.OnQueryOnly.ROLLBACK;
            }
            return DatabasePlatform.OnQueryOnly.CLOSE;
        }
        return dbPlatformOnQueryOnly == null ? DatabasePlatform.OnQueryOnly.ROLLBACK : dbPlatformOnQueryOnly;
    }

    private boolean isReadCommittedIsolation(DataSource ds) {
        if (DbOffline.isSet()) {
            return true;
        }
        Connection c = null;
        try {
            c = ds.getConnection();
            int isolationLevel = c.getTransactionIsolation();
            boolean bl = isolationLevel == 2;
            return bl;
        }
        catch (SQLException ex) {
            String m = "Errored trying to determine the default Isolation Level";
            throw new PersistenceException(m, (Throwable)ex);
        }
        finally {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException ex) {
                logger.error("closing connection", (Throwable)ex);
            }
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DatabasePlatform.OnQueryOnly getOnQueryOnly() {
        return this.onQueryOnly;
    }

    public SpiTransaction wrapExternalConnection(Connection c) {
        return this.wrapExternalConnection(this.externalTransPrefix + c.hashCode(), c);
    }

    public SpiTransaction wrapExternalConnection(String id, Connection c) {
        ExternalJdbcTransaction t = new ExternalJdbcTransaction(id, true, c, this);
        t.setBatch(this.persistBatch);
        t.setBatchOnCascade(this.persistBatchOnCascade);
        return t;
    }

    public SpiTransaction createTransaction(boolean explicit, int isolationLevel) {
        Connection c = null;
        try {
            c = this.dataSource.getConnection();
            long id = this.transactionCounter.incrementAndGet();
            SpiTransaction t = this.createTransaction(explicit, c, id);
            if (isolationLevel > -1) {
                c.setTransactionIsolation(isolationLevel);
            }
            if (explicit && TXN_LOGGER.isTraceEnabled()) {
                TXN_LOGGER.trace(t.getLogPrefix() + "Begin");
            }
            return t;
        }
        catch (SQLException ex) {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException e) {
                logger.error("Error closing failed connection", (Throwable)e);
            }
            throw new PersistenceException((Throwable)ex);
        }
    }

    public SpiTransaction createQueryTransaction() {
        Connection c = null;
        try {
            c = this.dataSource.getConnection();
            long id = this.transactionCounter.incrementAndGet();
            return this.createTransaction(false, c, id);
        }
        catch (PersistenceException ex) {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException e) {
                logger.error("Error closing failed connection", (Throwable)e);
            }
            throw ex;
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    protected SpiTransaction createTransaction(boolean explicit, Connection c, long id) {
        return new JdbcTransaction(this.prefix + id, explicit, c, this);
    }

    /*
     * WARNING - void declaration
     */
    public void notifyOfRollback(SpiTransaction transaction, Throwable cause) {
        try {
            if (TXN_LOGGER.isInfoEnabled()) {
                void var3_5;
                String string = transaction.getLogPrefix() + "Rollback";
                if (cause != null) {
                    String string2 = string + " error: " + this.formatThrowable(cause);
                }
                TXN_LOGGER.info((String)var3_5);
            }
            for (TransactionEventListener listener : this.transactionEventListeners) {
                listener.postTransactionRollback(transaction, cause);
            }
        }
        catch (Exception exception) {
            logger.error("Error while notifying TransactionEventListener of rollback event", (Throwable)exception);
        }
    }

    public void notifyOfQueryOnly(SpiTransaction transaction) {
        if (TXN_LOGGER.isTraceEnabled()) {
            TXN_LOGGER.trace(transaction.getLogPrefix() + "Commit - query only");
        }
    }

    private String formatThrowable(Throwable e) {
        if (e == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.formatThrowable(e, sb);
        return sb.toString();
    }

    private void formatThrowable(Throwable e, StringBuilder sb) {
        Throwable cause;
        sb.append(e.toString());
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace.length > 0) {
            sb.append(" stack0: ");
            sb.append(stackTrace[0]);
        }
        if ((cause = e.getCause()) != null) {
            sb.append(" cause: ");
            this.formatThrowable(cause, sb);
        }
    }

    public void notifyOfCommit(SpiTransaction transaction) {
        try {
            if (transaction.isExplicit()) {
                if (TXN_LOGGER.isInfoEnabled()) {
                    TXN_LOGGER.info(transaction.getLogPrefix() + "Commit");
                }
            } else if (TXN_LOGGER.isDebugEnabled()) {
                TXN_LOGGER.debug(transaction.getLogPrefix() + "Commit");
            }
            PostCommitProcessing postCommit = new PostCommitProcessing(this.clusterManager, this, transaction.getEvent());
            postCommit.notifyLocalCacheIndex();
            postCommit.notifyCluster();
            this.backgroundExecutor.execute(postCommit.notifyPersistListeners());
            for (TransactionEventListener listener : this.transactionEventListeners) {
                listener.postTransactionCommit(transaction);
            }
        }
        catch (Exception ex) {
            logger.error("NotifyOfCommit failed. L2 Cache potentially not notified.", (Throwable)ex);
        }
    }

    public void externalModification(TransactionEventTable tableEvents) {
        TransactionEvent event = new TransactionEvent();
        event.add(tableEvents);
        PostCommitProcessing postCommit = new PostCommitProcessing(this.clusterManager, this, event);
        postCommit.notifyLocalCacheIndex();
        this.backgroundExecutor.execute(postCommit.notifyPersistListeners());
    }

    public void remoteTransactionEvent(RemoteTransactionEvent remoteEvent) {
        List<BeanPersistIds> beanPersistList;
        List<TransactionEventTable.TableIUD> tableIUDList;
        if (logger.isDebugEnabled()) {
            logger.debug("Cluster Received: " + remoteEvent.toString());
        }
        if ((tableIUDList = remoteEvent.getTableIUDList()) != null) {
            for (int i = 0; i < tableIUDList.size(); ++i) {
                TransactionEventTable.TableIUD tableIUD = tableIUDList.get(i);
                this.beanDescriptorManager.cacheNotify(tableIUD);
            }
        }
        if ((beanPersistList = remoteEvent.getBeanPersistList()) != null) {
            for (int i = 0; i < beanPersistList.size(); ++i) {
                BeanPersistIds beanPersist = beanPersistList.get(i);
                beanPersist.notifyCacheAndListener();
            }
        }
    }

    public void sendChangeLog(final ChangeSet changeSet) {
        if (this.changeLogPrepare.prepare(changeSet)) {
            this.backgroundExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    TransactionManager.this.changeLogListener.log(changeSet);
                }
            });
        }
    }
}

