/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.json.JsonWriter;
import com.avaje.ebeaninternal.server.type.CtCompoundTypeScalarList;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataEncryptSupport;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarType;
import com.avaje.ebeaninternal.server.type.ScalarTypeBytesBase;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class ScalarTypeBytesEncrypted
implements ScalarType<byte[]> {
    private final ScalarTypeBytesBase baseType;
    private final DataEncryptSupport dataEncryptSupport;

    public ScalarTypeBytesEncrypted(ScalarTypeBytesBase baseType, DataEncryptSupport dataEncryptSupport) {
        this.baseType = baseType;
        this.dataEncryptSupport = dataEncryptSupport;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isDirty(Object value) {
        return false;
    }

    @Override
    public void bind(DataBind b, byte[] value) throws SQLException {
        value = this.dataEncryptSupport.encrypt(value);
        this.baseType.bind(b, value);
    }

    @Override
    public int getJdbcType() {
        return this.baseType.getJdbcType();
    }

    @Override
    public int getLength() {
        return this.baseType.getLength();
    }

    @Override
    public Class<byte[]> getType() {
        return byte[].class;
    }

    @Override
    public boolean isDateTimeCapable() {
        return this.baseType.isDateTimeCapable();
    }

    @Override
    public boolean isJdbcNative() {
        return this.baseType.isJdbcNative();
    }

    @Override
    public void loadIgnore(DataReader dataReader) {
        this.baseType.loadIgnore(dataReader);
    }

    @Override
    public void jsonWrite(JsonWriter writer, String name, byte[] value) throws IOException {
        writer.writeBinaryField(name, value);
    }

    @Override
    public byte[] jsonRead(JsonParser parser, JsonToken event) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(500);
        parser.readBinaryValue((OutputStream)out);
        return out.toByteArray();
    }

    @Override
    public String format(Object v) {
        throw new RuntimeException("Not used");
    }

    @Override
    public String formatValue(byte[] v) {
        throw new RuntimeException("Not used");
    }

    @Override
    public byte[] parse(String value) {
        return this.baseType.parse(value);
    }

    @Override
    public byte[] convertFromMillis(long systemTimeMillis) {
        return this.baseType.convertFromMillis(systemTimeMillis);
    }

    @Override
    public byte[] read(DataReader dataReader) throws SQLException {
        byte[] data = (byte[])this.baseType.read(dataReader);
        data = this.dataEncryptSupport.decrypt(data);
        return data;
    }

    @Override
    public byte[] toBeanType(Object value) {
        return this.baseType.toBeanType(value);
    }

    @Override
    public Object toJdbcType(Object value) {
        return this.baseType.toJdbcType(value);
    }

    @Override
    public void accumulateScalarTypes(String propName, CtCompoundTypeScalarList list) {
        this.baseType.accumulateScalarTypes(propName, list);
    }

    @Override
    public byte[] readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        int len = dataInput.readInt();
        byte[] value = new byte[len];
        dataInput.readFully(value);
        return value;
    }

    @Override
    public void writeData(DataOutput dataOutput, byte[] value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeInt(value.length);
            dataOutput.write(value);
        }
    }
}

