/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.TextException;
import com.avaje.ebean.text.json.JsonWriter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalarTypeFile
extends ScalarTypeBase<File> {
    private static final Logger logger = LoggerFactory.getLogger(ScalarTypeFile.class);
    private final String prefix;
    private final String suffix;
    private final File directory;
    private final int bufferSize;

    public ScalarTypeFile() {
        this(-4, "db-", null, null, 8096);
    }

    public ScalarTypeFile(int jdbcType, String prefix, String suffix, File directory, int bufferSize) {
        super(File.class, false, jdbcType);
        this.prefix = prefix;
        this.suffix = suffix;
        this.directory = directory;
        this.bufferSize = bufferSize;
    }

    private InputStream getInputStream(File value) throws IOException {
        FileInputStream fi = new FileInputStream(value);
        return new BufferedInputStream(fi, this.bufferSize);
    }

    private OutputStream getOutputStream(File value) throws IOException {
        FileOutputStream fi = new FileOutputStream(value);
        return new BufferedOutputStream(fi, this.bufferSize);
    }

    @Override
    public File read(DataReader dataReader) throws SQLException {
        InputStream is = dataReader.getBinaryStream();
        if (is == null) {
            return null;
        }
        try {
            File tempFile = File.createTempFile(this.prefix, this.suffix, this.directory);
            OutputStream os = this.getOutputStream(tempFile);
            this.pump(is, os);
            return tempFile;
        }
        catch (IOException e) {
            throw new SQLException("Error reading db file inputStream", e);
        }
    }

    @Override
    public void bind(DataBind b, File value) throws SQLException {
        if (value == null) {
            b.setNull(this.jdbcType);
        } else {
            try {
                InputStream fi = this.getInputStream(value);
                b.setBinaryStream(fi, value.length());
            }
            catch (IOException e) {
                throw new SQLException("Error trying to set file inputStream", e);
            }
        }
    }

    @Override
    public Object toJdbcType(Object value) {
        return value;
    }

    @Override
    public File toBeanType(Object value) {
        return (File)value;
    }

    @Override
    public void jsonWrite(JsonWriter writer, String name, File value) throws IOException {
        writer.writeFieldName(name);
        InputStream is = this.getInputStream(value);
        writer.writeBinary(is, (int)value.length());
    }

    @Override
    public File jsonRead(JsonParser parser, JsonToken event) throws IOException {
        File tempFile = File.createTempFile(this.prefix, this.suffix, this.directory);
        OutputStream os = this.getOutputStream(tempFile);
        parser.readBinaryValue(os);
        os.flush();
        os.close();
        return tempFile;
    }

    @Override
    public String formatValue(File file) {
        throw new TextException("Not supported");
    }

    @Override
    public File parse(String value) {
        throw new TextException("Not supported");
    }

    @Override
    public File convertFromMillis(long systemTimeMillis) {
        throw new TextException("Not supported");
    }

    @Override
    public boolean isDateTimeCapable() {
        return false;
    }

    @Override
    public File readData(DataInput dataInput) throws IOException {
        return null;
    }

    @Override
    public void writeData(DataOutput dataOutput, File file) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long pump(InputStream is, OutputStream out) throws IOException {
        long totalBytes = 0L;
        BufferedInputStream input = null;
        OutputStream output = null;
        try {
            int length;
            input = new BufferedInputStream(is, this.bufferSize);
            output = new BufferedOutputStream(out, this.bufferSize);
            byte[] buffer = new byte[this.bufferSize];
            while ((length = ((InputStream)input).read(buffer)) > 0) {
                output.write(buffer, 0, length);
                totalBytes += (long)length;
            }
            output.flush();
            long l = totalBytes;
            return l;
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    logger.error("Error when closing outputstream", (Throwable)e);
                }
            }
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    logger.error("Error when closing inputstream ", (Throwable)e);
                }
            }
        }
    }
}

