/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.config.JsonConfig;
import com.avaje.ebeaninternal.server.core.BasicTypeConverter;
import com.avaje.ebeaninternal.server.type.ScalarTypeBaseDateTime;
import java.sql.Timestamp;
import java.util.Date;
import org.joda.time.DateTime;

public class ScalarTypeJodaDateTime
extends ScalarTypeBaseDateTime<DateTime> {
    public ScalarTypeJodaDateTime(JsonConfig.DateTime mode) {
        super(mode, DateTime.class, false, 93);
    }

    @Override
    public long convertToMillis(DateTime value) {
        return value.getMillis();
    }

    @Override
    protected String toJsonNanos(DateTime value) {
        return String.valueOf(value.toDateTime().getMillis());
    }

    @Override
    protected String toJsonISO8601(DateTime value) {
        return value.toString();
    }

    @Override
    public DateTime convertFromMillis(long systemTimeMillis) {
        return new DateTime(systemTimeMillis);
    }

    @Override
    public DateTime convertFromTimestamp(Timestamp ts) {
        return new DateTime(ts.getTime());
    }

    @Override
    public Timestamp convertToTimestamp(DateTime t) {
        return new Timestamp(t.getMillis());
    }

    @Override
    public Object toJdbcType(Object value) {
        if (value instanceof DateTime) {
            return new Timestamp(((DateTime)value).getMillis());
        }
        return BasicTypeConverter.toTimestamp(value);
    }

    @Override
    public DateTime toBeanType(Object value) {
        if (value instanceof Date) {
            return new DateTime(((Date)value).getTime());
        }
        return (DateTime)value;
    }
}

