/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.json.JsonWriter;
import com.avaje.ebeaninternal.server.core.BasicTypeConverter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Time;

public class ScalarTypeTime
extends ScalarTypeBase<Time> {
    public ScalarTypeTime() {
        super(Time.class, true, 92);
    }

    @Override
    public void bind(DataBind b, Time value) throws SQLException {
        if (value == null) {
            b.setNull(92);
        } else {
            b.setTime(value);
        }
    }

    @Override
    public Time read(DataReader dataReader) throws SQLException {
        return dataReader.getTime();
    }

    @Override
    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toTime(value);
    }

    @Override
    public Time toBeanType(Object value) {
        return BasicTypeConverter.toTime(value);
    }

    @Override
    public String formatValue(Time v) {
        return v.toString();
    }

    @Override
    public Time parse(String value) {
        return Time.valueOf(value);
    }

    @Override
    public Time convertFromMillis(long systemTimeMillis) {
        return new Time(systemTimeMillis);
    }

    @Override
    public boolean isDateTimeCapable() {
        return true;
    }

    @Override
    public Time readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        String val = dataInput.readUTF();
        return this.parse(val);
    }

    @Override
    public void writeData(DataOutput dataOutput, Time value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeUTF(this.format(value));
        }
    }

    @Override
    public Time jsonRead(JsonParser parser, JsonToken event) throws IOException {
        return this.parse(parser.getValueAsString());
    }

    @Override
    public void jsonWrite(JsonWriter writer, String name, Time value) throws IOException {
        writer.writeStringField(name, this.format(value));
    }
}

