/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.json.JsonWriter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;

public class ScalarTypeUUIDNative
extends ScalarTypeBase<UUID> {
    public ScalarTypeUUIDNative() {
        super(UUID.class, false, 5010);
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isDirty(Object value) {
        return true;
    }

    @Override
    public UUID read(DataReader dataReader) throws SQLException {
        Object value = dataReader.getObject();
        if (value == null) {
            return null;
        }
        return (UUID)value;
    }

    @Override
    public void bind(DataBind b, UUID value) throws SQLException {
        b.setObject(value);
    }

    @Override
    public Object toJdbcType(Object value) {
        return value;
    }

    @Override
    public UUID toBeanType(Object value) {
        return (UUID)value;
    }

    @Override
    public String formatValue(UUID v) {
        return v.toString();
    }

    @Override
    public UUID parse(String value) {
        return UUID.fromString(value);
    }

    @Override
    public UUID convertFromMillis(long dateTime) {
        throw new RuntimeException("Should never be called");
    }

    @Override
    public boolean isDateTimeCapable() {
        return false;
    }

    @Override
    public UUID readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        String json = dataInput.readUTF();
        return this.parse(json);
    }

    @Override
    public void writeData(DataOutput dataOutput, UUID v) throws IOException {
        if (v == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            String json = this.format(v);
            dataOutput.writeUTF(json);
        }
    }

    @Override
    public void jsonWrite(JsonWriter writer, String name, UUID value) throws IOException {
        if (value == null) {
            writer.writeNullField(name);
        } else {
            writer.writeStringField(name, this.formatValue(value));
        }
    }

    @Override
    public UUID jsonRead(JsonParser parser, JsonToken event) throws IOException {
        String strValue = parser.getValueAsString();
        return strValue == null ? null : this.parse(strValue);
    }
}

