/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config.dbplatform;

import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.config.dbplatform.DB2SequenceIdGenerator;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.Db2SqlLimiter;
import com.avaje.ebean.config.dbplatform.DbType;
import com.avaje.ebean.config.dbplatform.IdGenerator;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.DB2Ddl;
import javax.sql.DataSource;

public class DB2Platform
extends DatabasePlatform {
    public DB2Platform() {
        this.name = "db2";
        this.maxTableNameLength = 18;
        this.maxConstraintNameLength = 18;
        this.sqlLimiter = new Db2SqlLimiter();
        this.platformDdl = new DB2Ddl(this.dbTypeMap, this.dbIdentity);
        this.dbIdentity.setSupportsGetGeneratedKeys(true);
        this.dbIdentity.setSupportsSequence(true);
        this.booleanDbType = 16;
        this.dbTypeMap.put(7, new DbType("real"));
        this.dbTypeMap.put(-6, new DbType("smallint"));
        this.dbTypeMap.put(3, new DbType("decimal", 15));
    }

    @Override
    public IdGenerator createSequenceIdGenerator(BackgroundExecutor be, DataSource ds, String seqName, int batchSize) {
        return new DB2SequenceIdGenerator(be, ds, seqName, batchSize);
    }
}

