/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config.dbplatform;

import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.Query;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DbEncrypt;
import com.avaje.ebean.config.dbplatform.DbHistorySupport;
import com.avaje.ebean.config.dbplatform.DbIdentity;
import com.avaje.ebean.config.dbplatform.DbTypeMap;
import com.avaje.ebean.config.dbplatform.IdGenerator;
import com.avaje.ebean.config.dbplatform.LimitOffsetSqlLimiter;
import com.avaje.ebean.config.dbplatform.SqlLimiter;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlHandler;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.PlatformDdl;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabasePlatform {
    private static final Logger logger = LoggerFactory.getLogger(DatabasePlatform.class);
    protected boolean useExtraTransactionOnIterateSecondaryQueries;
    protected OnQueryOnly onQueryOnly = OnQueryOnly.ROLLBACK;
    protected String openQuote = "\"";
    protected String closeQuote = "\"";
    protected SqlLimiter sqlLimiter = new LimitOffsetSqlLimiter();
    protected DbTypeMap dbTypeMap = new DbTypeMap();
    protected boolean nativeUuidType;
    protected DbIdentity dbIdentity = new DbIdentity();
    protected DbHistorySupport historySupport;
    protected int booleanDbType = 16;
    protected int blobDbType = 2004;
    protected int clobDbType = 2005;
    protected boolean treatEmptyStringsAsNull;
    protected String name = "generic";
    protected String columnAliasPrefix = "c";
    protected String tableAliasPlaceHolder = "${ta}";
    private static final char BACK_TICK = '`';
    protected String likeClause = "like ?";
    protected DbEncrypt dbEncrypt;
    protected boolean idInExpandedForm;
    protected boolean selectCountWithAlias;
    protected boolean forwardOnlyHintOnFindIterate;
    protected boolean disallowBatchOnCascade;
    protected PlatformDdl platformDdl;
    protected int maxTableNameLength = 60;
    protected int maxConstraintNameLength = 60;

    public String getName() {
        return this.name;
    }

    public int getMaxTableNameLength() {
        return this.maxTableNameLength;
    }

    public int getMaxConstraintNameLength() {
        return this.maxConstraintNameLength;
    }

    public PlatformDdl getPlatformDdl() {
        return this.platformDdl;
    }

    public DdlHandler createDdlHandler(ServerConfig serverConfig) {
        return this.platformDdl.createDdlHandler(serverConfig);
    }

    public boolean useExtraTransactionOnIterateSecondaryQueries() {
        return this.useExtraTransactionOnIterateSecondaryQueries;
    }

    public IdGenerator createSequenceIdGenerator(BackgroundExecutor be, DataSource ds, String seqName, int batchSize) {
        return null;
    }

    public OnQueryOnly getOnQueryOnly() {
        return this.onQueryOnly;
    }

    public void setOnQueryOnly(OnQueryOnly onQueryOnly) {
        this.onQueryOnly = onQueryOnly;
    }

    public DbEncrypt getDbEncrypt() {
        return this.dbEncrypt;
    }

    public void setDbEncrypt(DbEncrypt dbEncrypt) {
        this.dbEncrypt = dbEncrypt;
    }

    public DbHistorySupport getHistorySupport() {
        return this.historySupport;
    }

    public void setHistorySupport(DbHistorySupport historySupport) {
        this.historySupport = historySupport;
    }

    public boolean isNativeUuidType() {
        return this.nativeUuidType;
    }

    public DbTypeMap getDbTypeMap() {
        return this.dbTypeMap;
    }

    public String getColumnAliasPrefix() {
        return this.columnAliasPrefix;
    }

    public void setColumnAliasPrefix(String columnAliasPrefix) {
        this.columnAliasPrefix = columnAliasPrefix;
    }

    public String getTableAliasPlaceHolder() {
        return this.tableAliasPlaceHolder;
    }

    public void setTableAliasPlaceHolder(String tableAliasPlaceHolder) {
        this.tableAliasPlaceHolder = tableAliasPlaceHolder;
    }

    public String getCloseQuote() {
        return this.closeQuote;
    }

    public String getOpenQuote() {
        return this.openQuote;
    }

    public int getBooleanDbType() {
        return this.booleanDbType;
    }

    public int getBlobDbType() {
        return this.blobDbType;
    }

    public int getClobDbType() {
        return this.clobDbType;
    }

    public boolean isTreatEmptyStringsAsNull() {
        return this.treatEmptyStringsAsNull;
    }

    public boolean isIdInExpandedForm() {
        return this.idInExpandedForm;
    }

    public boolean isForwardOnlyHintOnFindIterate() {
        return this.forwardOnlyHintOnFindIterate;
    }

    public void setForwardOnlyHintOnFindIterate(boolean forwardOnlyHintOnFindIterate) {
        this.forwardOnlyHintOnFindIterate = forwardOnlyHintOnFindIterate;
    }

    public DbIdentity getDbIdentity() {
        return this.dbIdentity;
    }

    public SqlLimiter getSqlLimiter() {
        return this.sqlLimiter;
    }

    public String convertQuotedIdentifiers(String dbName) {
        if (dbName != null && dbName.length() > 0 && dbName.charAt(0) == '`') {
            if (dbName.charAt(dbName.length() - 1) == '`') {
                String quotedName = this.getOpenQuote();
                quotedName = quotedName + dbName.substring(1, dbName.length() - 1);
                quotedName = quotedName + this.getCloseQuote();
                return quotedName;
            }
            logger.error("Missing backquote on [" + dbName + "]");
        }
        return dbName;
    }

    public boolean isSelectCountWithAlias() {
        return this.selectCountWithAlias;
    }

    public String completeSql(String sql, Query<?> query) {
        if (Boolean.TRUE.equals(query.isForUpdate())) {
            sql = this.withForUpdate(sql);
        }
        return sql;
    }

    protected String withForUpdate(String sql) {
        logger.info("it seems your database does not support the 'for update' clause");
        return sql;
    }

    public String getLikeClause() {
        return this.likeClause;
    }

    public boolean isDisallowBatchOnCascade() {
        return this.disallowBatchOnCascade;
    }

    public static enum OnQueryOnly {
        ROLLBACK,
        CLOSE,
        COMMIT;

    }
}

