/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration;

import com.avaje.ebean.Transaction;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.dbmigration.model.CurrentModel;
import com.avaje.ebeaninternal.api.SpiEbeanPlugin;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DdlGenerator
implements SpiEbeanPlugin {
    private static final Logger logger = LoggerFactory.getLogger(DdlGenerator.class);
    private SpiEbeanServer server;
    private boolean generateDdl;
    private boolean runDdl;
    private CurrentModel currentModel;
    private String dropContent;
    private String createContent;

    @Override
    public void setup(SpiEbeanServer server, ServerConfig serverConfig) {
        this.server = server;
        this.generateDdl = serverConfig.isDdlGenerate();
        this.runDdl = serverConfig.isDdlRun();
    }

    @Override
    public void execute(boolean online) {
        this.generateDdl();
        if (online) {
            this.runDdl();
        }
    }

    public void generateDdl() {
        if (this.generateDdl) {
            this.writeDrop(this.getDropFileName());
            this.writeCreate(this.getCreateFileName());
        }
    }

    public void runDdl() {
        if (this.runDdl) {
            try {
                if (this.dropContent == null) {
                    this.dropContent = this.readFile(this.getDropFileName());
                }
                if (this.createContent == null) {
                    this.createContent = this.readFile(this.getCreateFileName());
                }
                this.runScript(true, this.dropContent);
                this.runScript(false, this.createContent);
            }
            catch (IOException e) {
                String msg = "Error reading drop/create script from file system";
                throw new RuntimeException(msg, e);
            }
        }
    }

    protected void writeDrop(String dropFile) {
        try {
            String c = this.generateDropDdl();
            this.writeFile(dropFile, c);
        }
        catch (IOException e) {
            throw new PersistenceException("Error generating Drop DDL", (Throwable)e);
        }
    }

    protected void writeCreate(String createFile) {
        try {
            String c = this.generateCreateDdl();
            this.writeFile(createFile, c);
        }
        catch (IOException e) {
            throw new PersistenceException("Error generating Create DDL", (Throwable)e);
        }
    }

    public String generateDropDdl() {
        try {
            this.dropContent = this.currentModel().getDropDdl();
            return this.dropContent;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String generateCreateDdl() {
        try {
            this.createContent = this.currentModel().getCreateDdl();
            return this.createContent;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getDropFileName() {
        return this.server.getName() + "-drop-all.sql";
    }

    protected String getCreateFileName() {
        return this.server.getName() + "-create-all.sql";
    }

    protected CurrentModel currentModel() {
        if (this.currentModel == null) {
            this.currentModel = new CurrentModel(this.server);
        }
        return this.currentModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(String fileName, String fileContent) throws IOException {
        File f = new File(fileName);
        FileWriter fw = new FileWriter(f);
        try {
            fw.write(fileContent);
            fw.flush();
        }
        finally {
            fw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readFile(String fileName) throws IOException {
        File f = new File(fileName);
        if (!f.exists()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        FileReader fr = new FileReader(f);
        LineNumberReader lr = new LineNumberReader(fr);
        try {
            String s;
            while ((s = lr.readLine()) != null) {
                buf.append(s).append("\n");
            }
        }
        finally {
            lr.close();
        }
        return buf.toString();
    }

    public void runScript(boolean expectErrors, String content) {
        StringReader sr = new StringReader(content);
        List<String> statements = this.parseStatements(sr);
        Transaction t = this.server.createTransaction();
        try {
            Connection connection = t.getConnection();
            logger.info("Running DDL");
            this.runStatements(expectErrors, statements, connection);
            logger.info("Running DDL Complete");
            t.commit();
        }
        catch (Exception e) {
            throw new PersistenceException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            t.end();
        }
    }

    private void runStatements(boolean expectErrors, List<String> statements, Connection c) {
        ArrayList<String> noDuplicates = new ArrayList<String>();
        for (String statement : statements) {
            if (noDuplicates.contains(statement)) continue;
            noDuplicates.add(statement);
        }
        for (int i = 0; i < noDuplicates.size(); ++i) {
            String xOfy = i + 1 + " of " + noDuplicates.size();
            this.runStatement(expectErrors, xOfy, (String)noDuplicates.get(i), c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runStatement(boolean expectErrors, String oneOf, String stmt, Connection c) {
        block16: {
            Statement pstmt = null;
            try {
                stmt = stmt.trim();
                if (stmt.endsWith(";")) {
                    stmt = stmt.substring(0, stmt.length() - 1);
                } else if (stmt.endsWith("/")) {
                    stmt = stmt.substring(0, stmt.length() - 1);
                }
                logger.info("executing " + oneOf + " " + this.getSummary(stmt));
                pstmt = c.prepareStatement(stmt);
                pstmt.execute();
            }
            catch (Exception e) {
                if (expectErrors) {
                    logger.info(" ... ignoring error executing " + this.getSummary(stmt) + "  error: " + e.getMessage());
                    break block16;
                }
                String msg = "Error executing stmt[" + stmt + "] error[" + e.getMessage() + "]";
                throw new RuntimeException(msg, e);
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (SQLException e) {
                        logger.error("Error closing pstmt", (Throwable)e);
                    }
                }
            }
        }
    }

    protected List<String> parseStatements(StringReader reader) {
        try {
            String s;
            BufferedReader br = new BufferedReader(reader);
            StatementsSeparator statements = new StatementsSeparator();
            while ((s = br.readLine()) != null) {
                s = s.trim();
                statements.nextLine(s);
            }
            return statements.statements;
        }
        catch (IOException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private String getSummary(String s) {
        if (s.length() > 80) {
            return s.substring(0, 80).trim() + "...";
        }
        return s;
    }

    static class StatementsSeparator {
        ArrayList<String> statements = new ArrayList();
        boolean trimDelimiter;
        boolean inDbProcedure;
        StringBuilder sb = new StringBuilder();

        StatementsSeparator() {
        }

        void lineContainsDollars(String line) {
            if (this.inDbProcedure) {
                if (this.trimDelimiter) {
                    line = line.replace("$$", "");
                }
                this.endOfStatement(line);
            } else {
                this.trimDelimiter = line.equals("delimiter $$");
                if (!this.trimDelimiter) {
                    this.sb.append(line).append(" ");
                }
            }
            this.inDbProcedure = !this.inDbProcedure;
        }

        void endOfStatement(String line) {
            this.sb.append(line);
            this.statements.add(this.sb.toString().trim());
            this.sb = new StringBuilder();
        }

        void nextLine(String line) {
            if (line.contains("$$")) {
                this.lineContainsDollars(line);
                return;
            }
            if (this.inDbProcedure) {
                this.sb.append(line).append(" ");
                return;
            }
            int semiPos = line.indexOf(59);
            if (semiPos == -1) {
                this.sb.append(line).append(" ");
            } else if (semiPos == line.length() - 1) {
                this.endOfStatement(line);
            } else {
                String preSemi = line.substring(0, semiPos);
                this.endOfStatement(preSemi);
                this.sb.append(line.substring(semiPos + 1));
            }
        }
    }
}

