/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.ddlgeneration.platform;

import com.avaje.ebean.config.DbConstraintNaming;
import com.avaje.ebean.config.NamingConvention;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.IdType;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlBuffer;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlWrite;
import com.avaje.ebean.dbmigration.ddlgeneration.TableDdl;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.HistoryTableUpdate;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.PlatformDdl;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.util.IndexSet;
import com.avaje.ebean.dbmigration.migration.AddColumn;
import com.avaje.ebean.dbmigration.migration.AddHistoryTable;
import com.avaje.ebean.dbmigration.migration.AlterColumn;
import com.avaje.ebean.dbmigration.migration.Column;
import com.avaje.ebean.dbmigration.migration.CreateIndex;
import com.avaje.ebean.dbmigration.migration.CreateTable;
import com.avaje.ebean.dbmigration.migration.DropColumn;
import com.avaje.ebean.dbmigration.migration.DropHistoryTable;
import com.avaje.ebean.dbmigration.migration.DropIndex;
import com.avaje.ebean.dbmigration.migration.DropTable;
import com.avaje.ebean.dbmigration.migration.ForeignKey;
import com.avaje.ebean.dbmigration.migration.UniqueConstraint;
import com.avaje.ebean.dbmigration.model.MTable;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BaseTableDdl
implements TableDdl {
    protected final DbConstraintNaming naming;
    protected final NamingConvention namingConvention;
    protected final PlatformDdl platformDdl;
    protected final String historyTableSuffix;
    protected IndexSet indexSet = new IndexSet();
    protected List<Column> externalUnique = new ArrayList<Column>();
    protected int countCheck;
    protected int countUnique;
    protected int countForeignKey;
    protected int countIndex;
    protected Map<String, HistoryTableUpdate> regenerateHistoryTriggers = new LinkedHashMap<String, HistoryTableUpdate>();

    public BaseTableDdl(ServerConfig serverConfig, PlatformDdl platformDdl) {
        this.namingConvention = serverConfig.getNamingConvention();
        this.naming = serverConfig.getConstraintNaming();
        this.historyTableSuffix = serverConfig.getHistoryTableSuffix();
        this.platformDdl = platformDdl;
        this.platformDdl.configure(serverConfig);
    }

    protected void reset() {
        this.indexSet.clear();
        this.externalUnique.clear();
        this.countCheck = 0;
        this.countUnique = 0;
        this.countForeignKey = 0;
        this.countIndex = 0;
    }

    @Override
    public void generate(DdlWrite writer, CreateTable createTable) throws IOException {
        this.reset();
        String tableName = this.lowerTableName(createTable.getName());
        List<Column> columns = createTable.getColumn();
        List<Column> pk = this.determinePrimaryKeyColumns(columns);
        boolean singleColumnPrimaryKey = pk.size() == 1;
        boolean useIdentity = false;
        boolean useSequence = false;
        if (singleColumnPrimaryKey) {
            IdType useDbIdentityType = this.platformDdl.useIdentityType(createTable.getIdentityType());
            useIdentity = IdType.IDENTITY == useDbIdentityType;
            useSequence = IdType.SEQUENCE == useDbIdentityType;
        }
        DdlBuffer apply = writer.apply();
        apply.append("create table ").append(tableName).append(" (");
        this.writeTableColumns(apply, columns, useIdentity);
        this.writeCheckConstraints(apply, createTable);
        this.writeUniqueConstraints(apply, createTable);
        this.writeCompoundUniqueConstraints(apply, createTable);
        if (!pk.isEmpty()) {
            this.writePrimaryKeyConstraint(apply, createTable.getPkName(), this.toColumnNames(pk));
        }
        apply.newLine().append(")").endOfStatement();
        this.writeUniqueOneToOneConstraints(writer, createTable);
        if (this.isTrue(createTable.isWithHistory())) {
            this.createWithHistory(writer, createTable.getName());
        }
        this.dropTable(writer.rollback(), tableName);
        if (useSequence) {
            String pkCol = pk.get(0).getName();
            this.writeSequence(writer, createTable, pkCol);
        }
        apply.end();
        writer.rollback().end();
        this.writeAddForeignKeys(writer, createTable);
    }

    private void writeTableColumns(DdlBuffer apply, List<Column> columns, boolean useIdentity) throws IOException {
        this.platformDdl.writeTableColumns(apply, columns, useIdentity);
    }

    protected void writeUniqueOneToOneConstraints(DdlWrite write, CreateTable createTable) throws IOException {
        String tableName = createTable.getName();
        for (Column col : this.externalUnique) {
            String uqName = col.getUniqueOneToOne();
            String[] columnNames = new String[]{col.getName()};
            write.apply().append(this.platformDdl.alterTableAddUniqueConstraint(tableName, uqName, columnNames)).endOfStatement();
            write.rollbackForeignKeys().append(this.platformDdl.dropIndex(uqName, tableName)).endOfStatement();
        }
    }

    protected void writeSequence(DdlWrite writer, CreateTable createTable, String pk) throws IOException {
        String createSeq;
        String explicitSequenceName = createTable.getSequenceName();
        int initial = this.toInt(createTable.getSequenceInitial());
        int allocate = this.toInt(createTable.getSequenceAllocate());
        String seqName = explicitSequenceName;
        if (seqName == null) {
            seqName = this.namingConvention.getSequenceName(createTable.getName(), pk);
        }
        if ((createSeq = this.platformDdl.createSequence(seqName, initial, allocate)) != null) {
            writer.apply().append(createSeq).newLine();
            writer.rollback().append(this.platformDdl.dropSequence(seqName)).endOfStatement();
        }
    }

    protected void createWithHistory(DdlWrite writer, String name) throws IOException {
        MTable table = writer.getTable(name);
        this.platformDdl.createWithHistory(writer, table);
    }

    protected void writeAddForeignKeys(DdlWrite write, CreateTable createTable) throws IOException {
        String tableName = createTable.getName();
        List<Column> columns = createTable.getColumn();
        for (Column column : columns) {
            String references = column.getReferences();
            if (!this.hasValue(references)) continue;
            this.writeForeignKey(write, tableName, column);
        }
        this.writeAddCompoundForeignKeys(write, createTable);
    }

    protected void writeAddCompoundForeignKeys(DdlWrite write, CreateTable createTable) throws IOException {
        String tableName = createTable.getName();
        List<ForeignKey> foreignKey = createTable.getForeignKey();
        for (ForeignKey key : foreignKey) {
            String refTableName = key.getRefTableName();
            String fkName = key.getName();
            String[] cols = this.toColumnNamesSplit(key.getColumnNames());
            String[] refColumns = this.toColumnNamesSplit(key.getRefColumnNames());
            this.writeForeignKey(write, fkName, tableName, cols, refTableName, refColumns, key.getIndexName());
        }
    }

    protected void writeForeignKey(DdlWrite write, String tableName, Column column) throws IOException {
        String fkName = column.getForeignKeyName();
        String references = column.getReferences();
        int pos = references.lastIndexOf(46);
        if (pos == -1) {
            throw new IllegalStateException("Expecting period '.' character for table.column split but not found in [" + references + "]");
        }
        String refTableName = references.substring(0, pos);
        String refColumnName = references.substring(pos + 1);
        String[] cols = new String[]{column.getName()};
        String[] refCols = new String[]{refColumnName};
        this.writeForeignKey(write, fkName, tableName, cols, refTableName, refCols, column.getForeignKeyIndex());
    }

    protected void writeForeignKey(DdlWrite write, String fkName, String tableName, String[] columns, String refTable, String[] refColumns, String indexName) throws IOException {
        tableName = this.lowerTableName(tableName);
        DdlBuffer fkeyBuffer = write.applyForeignKeys();
        this.alterTableAddForeignKey(fkeyBuffer, fkName, tableName, columns, refTable, refColumns);
        if (indexName != null) {
            fkeyBuffer.append(this.platformDdl.createIndex(indexName, tableName, columns)).endOfStatement();
        }
        fkeyBuffer.end();
        write.rollbackForeignKeys().append(this.platformDdl.alterTableDropForeignKey(tableName, fkName)).endOfStatement();
        if (indexName != null) {
            write.rollbackForeignKeys().append(this.platformDdl.dropIndex(indexName, tableName)).endOfStatement();
        }
        write.rollbackForeignKeys().end();
    }

    protected void alterTableAddForeignKey(DdlBuffer buffer, String fkName, String tableName, String[] columns, String refTable, String[] refColumns) throws IOException {
        buffer.append(this.platformDdl.alterTableAddForeignKey(tableName, fkName, columns, refTable, refColumns)).endOfStatement();
    }

    protected void appendColumns(String[] columns, DdlBuffer buffer) throws IOException {
        buffer.append(" (");
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(this.lowerColumnName(columns[i].trim()));
        }
        buffer.append(")");
    }

    protected void dropTable(DdlBuffer buffer, String tableName) throws IOException {
        buffer.append(this.platformDdl.dropTable(tableName)).endOfStatement();
    }

    protected void writeCheckConstraints(DdlBuffer apply, CreateTable createTable) throws IOException {
        List<Column> columns = createTable.getColumn();
        for (Column column : columns) {
            String checkConstraint = column.getCheckConstraint();
            if (!this.hasValue(checkConstraint)) continue;
            this.writeCheckConstraint(apply, column, checkConstraint);
        }
    }

    protected void writeCheckConstraint(DdlBuffer buffer, Column column, String checkConstraint) throws IOException {
        String ckName = column.getCheckConstraintName();
        buffer.append(",").newLine();
        buffer.append("  constraint ").append(ckName);
        buffer.append(" ").append(checkConstraint);
    }

    protected void writeCompoundUniqueConstraints(DdlBuffer apply, CreateTable createTable) throws IOException {
        List<UniqueConstraint> uniqueConstraints = createTable.getUniqueConstraint();
        for (UniqueConstraint uniqueConstraint : uniqueConstraints) {
            String uqName = uniqueConstraint.getName();
            String[] columns = this.toColumnNamesSplit(uniqueConstraint.getColumnNames());
            apply.append(",").newLine();
            apply.append("  constraint ").append(uqName).append(" unique");
            this.appendColumns(columns, apply);
        }
    }

    protected void writeUniqueConstraints(DdlBuffer apply, CreateTable createTable) throws IOException {
        boolean inlineUniqueOneToOne = this.platformDdl.isInlineUniqueOneToOne();
        List<Column> columns = createTable.getColumn();
        for (Column column : columns) {
            if (this.hasValue(column.getUnique()) || inlineUniqueOneToOne && this.hasValue(column.getUniqueOneToOne())) {
                this.inlineUniqueConstraintSingle(apply, column);
                continue;
            }
            if (inlineUniqueOneToOne || !this.hasValue(column.getUniqueOneToOne())) continue;
            this.externalUnique.add(column);
        }
    }

    protected void inlineUniqueConstraintSingle(DdlBuffer buffer, Column column) throws IOException {
        String uqName = column.getUnique();
        if (uqName == null) {
            uqName = column.getUniqueOneToOne();
        }
        buffer.append(",").newLine();
        buffer.append("  constraint ").append(uqName).append(" unique ");
        buffer.append("(");
        buffer.append(this.lowerColumnName(column.getName()));
        buffer.append(")");
    }

    protected void writePrimaryKeyConstraint(DdlBuffer buffer, String pkName, String[] pkColumns) throws IOException {
        buffer.append(",").newLine();
        buffer.append("  constraint ").append(pkName).append(" primary key");
        this.appendColumns(pkColumns, buffer);
    }

    protected String[] toColumnNames(List<Column> columns) {
        String[] cols = new String[columns.size()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = columns.get(i).getName();
        }
        return cols;
    }

    protected String[] toColumnNamesSplit(String columns) {
        return columns.split(",");
    }

    protected String lowerTableName(String name) {
        return this.naming.lowerTableName(name);
    }

    protected String lowerColumnName(String name) {
        return this.naming.lowerColumnName(name);
    }

    protected List<Column> determinePrimaryKeyColumns(List<Column> columns) {
        ArrayList<Column> pk = new ArrayList<Column>(3);
        for (Column column : columns) {
            if (!this.isTrue(column.isPrimaryKey())) continue;
            pk.add(column);
        }
        return pk;
    }

    @Override
    public void generate(DdlWrite writer, CreateIndex createIndex) throws IOException {
        String[] cols = this.toColumnNamesSplit(createIndex.getColumns());
        writer.apply().append(this.platformDdl.createIndex(createIndex.getIndexName(), createIndex.getTableName(), cols)).endOfStatement();
        writer.rollback().append(this.platformDdl.dropIndex(createIndex.getIndexName(), createIndex.getTableName())).endOfStatement();
    }

    @Override
    public void generate(DdlWrite writer, DropIndex dropIndex) throws IOException {
        writer.apply().append(this.platformDdl.dropIndex(dropIndex.getIndexName(), dropIndex.getTableName())).endOfStatement();
    }

    @Override
    public void generate(DdlWrite writer, AddHistoryTable addHistoryTable) throws IOException {
        this.platformDdl.addHistoryTable(writer, addHistoryTable);
    }

    @Override
    public void generate(DdlWrite writer, DropHistoryTable dropHistoryTable) throws IOException {
        this.platformDdl.dropHistoryTable(writer, dropHistoryTable);
    }

    @Override
    public void generateExtra(DdlWrite write) throws IOException {
        for (HistoryTableUpdate update : this.regenerateHistoryTriggers.values()) {
            this.platformDdl.regenerateHistoryTriggers(write, update);
        }
    }

    @Override
    public void generate(DdlWrite writer, AddColumn addColumn) throws IOException {
        String tableName = addColumn.getTableName();
        List<Column> columns = addColumn.getColumn();
        for (Column column : columns) {
            this.alterTableAddColumn(writer.apply(), tableName, column, false);
            this.alterTableDropColumn(writer.rollback(), tableName, column.getName());
        }
        if (this.isTrue(addColumn.isWithHistory())) {
            String historyTable = this.historyTable(tableName);
            for (Column column : columns) {
                this.regenerateHistoryTriggers(tableName, HistoryTableUpdate.Change.ADD, column.getName());
                this.alterTableAddColumn(writer.apply(), historyTable, column, true);
                this.alterTableDropColumn(writer.rollback(), historyTable, column.getName());
            }
        }
        writer.apply().end();
        writer.rollback().end();
    }

    @Override
    public void generate(DdlWrite writer, DropTable dropTable) throws IOException {
        this.dropTable(writer.drop(), dropTable.getName());
    }

    @Override
    public void generate(DdlWrite writer, DropColumn dropColumn) throws IOException {
        String tableName = dropColumn.getTableName();
        this.alterTableDropColumn(writer.drop(), tableName, dropColumn.getColumnName());
        if (this.isTrue(dropColumn.isWithHistory())) {
            this.regenerateHistoryTriggers(tableName, HistoryTableUpdate.Change.DROP, dropColumn.getColumnName());
            this.alterTableDropColumn(writer.drop(), this.historyTable(tableName), dropColumn.getColumnName());
        }
        writer.drop().end();
    }

    @Override
    public void generate(DdlWrite writer, AlterColumn alterColumn) throws IOException {
        if (this.isTrue(alterColumn.isHistoryExclude())) {
            this.regenerateHistoryTriggers(alterColumn.getTableName(), HistoryTableUpdate.Change.EXCLUDE, alterColumn.getColumnName());
        } else if (this.isFalse(alterColumn.isHistoryExclude())) {
            this.regenerateHistoryTriggers(alterColumn.getTableName(), HistoryTableUpdate.Change.INCLUDE, alterColumn.getColumnName());
        }
        if (this.hasValue(alterColumn.getDropForeignKey())) {
            this.alterColumnDropForeignKey(writer, alterColumn);
        }
        if (this.hasValue(alterColumn.getReferences())) {
            this.alterColumnAddForeignKey(writer, alterColumn);
        }
        if (this.hasValue(alterColumn.getDropUnique())) {
            this.alterColumnDropUniqueConstraint(writer, alterColumn);
        }
        if (this.hasValue(alterColumn.getUnique())) {
            this.alterColumnAddUniqueConstraint(writer, alterColumn);
        }
        if (this.hasValue(alterColumn.getUniqueOneToOne())) {
            this.alterColumnAddUniqueOneToOneConstraint(writer, alterColumn);
        }
        boolean alterBaseAttributes = false;
        if (this.hasValue(alterColumn.getType())) {
            this.alterColumnType(writer, alterColumn);
            alterBaseAttributes = true;
        }
        if (this.hasValue(alterColumn.getDefaultValue())) {
            this.alterColumnDefaultValue(writer, alterColumn);
            alterBaseAttributes = true;
        }
        if (alterColumn.isNotnull() != null) {
            this.alterColumnNotnull(writer, alterColumn);
            alterBaseAttributes = true;
        }
        if (alterBaseAttributes) {
            this.alterColumnBaseAttributes(writer, alterColumn);
        }
    }

    protected String historyTable(String baseTable) {
        return baseTable + this.historyTableSuffix;
    }

    protected void regenerateHistoryTriggers(String baseTableName, HistoryTableUpdate.Change change, String column) {
        HistoryTableUpdate update = this.regenerateHistoryTriggers.get(baseTableName);
        if (update == null) {
            update = new HistoryTableUpdate(baseTableName);
            this.regenerateHistoryTriggers.put(baseTableName, update);
        }
        update.add(change, column);
    }

    protected void alterColumnBaseAttributes(DdlWrite writer, AlterColumn alter) throws IOException {
        String ddl = this.platformDdl.alterColumnBaseAttributes(alter);
        if (this.hasValue(ddl)) {
            writer.apply().append(ddl).endOfStatement();
            String currentType = alter.getCurrentType();
            String type = alter.getType();
            Boolean currentNotnull = alter.isCurrentNotnull();
            Boolean notnull = alter.isNotnull();
            alter.setCurrentType(type);
            alter.setType(currentType);
            alter.setNotnull(currentNotnull);
            alter.setCurrentNotnull(notnull);
            ddl = this.platformDdl.alterColumnBaseAttributes(alter);
            writer.rollback().append(ddl).endOfStatement();
            if (this.isTrue(alter.isWithHistory()) && alter.getType() != null) {
                AlterColumn alterHistoryColumn = new AlterColumn();
                alterHistoryColumn.setTableName(this.historyTable(alter.getTableName()));
                alterHistoryColumn.setColumnName(alter.getColumnName());
                alterHistoryColumn.setType(alter.getType());
                String histColumnDdl = this.platformDdl.alterColumnBaseAttributes(alterHistoryColumn);
                writer.apply().append(histColumnDdl).endOfStatement();
                alterHistoryColumn.setType(currentType);
                histColumnDdl = this.platformDdl.alterColumnBaseAttributes(alterHistoryColumn);
                writer.rollback().append(histColumnDdl).endOfStatement();
            }
        }
    }

    protected void alterColumnDefaultValue(DdlWrite writer, AlterColumn alter) throws IOException {
        String ddl = this.platformDdl.alterColumnDefaultValue(alter.getTableName(), alter.getColumnName(), alter.getDefaultValue());
        if (this.hasValue(ddl)) {
            writer.apply().append(ddl).endOfStatement();
        }
    }

    protected void alterColumnNotnull(DdlWrite writer, AlterColumn alter) throws IOException {
        String ddl = this.platformDdl.alterColumnNotnull(alter.getTableName(), alter.getColumnName(), alter.isNotnull());
        if (this.hasValue(ddl)) {
            writer.apply().append(ddl).endOfStatement();
            ddl = this.platformDdl.alterColumnNotnull(alter.getTableName(), alter.getColumnName(), alter.isCurrentNotnull());
            writer.rollback().append(ddl).endOfStatement();
        }
    }

    protected void alterColumnType(DdlWrite writer, AlterColumn alter) throws IOException {
        String ddl = this.platformDdl.alterColumnType(alter.getTableName(), alter.getColumnName(), alter.getType());
        if (this.hasValue(ddl)) {
            writer.apply().append(ddl).endOfStatement();
            ddl = this.platformDdl.alterColumnType(alter.getTableName(), alter.getColumnName(), alter.getCurrentType());
            writer.rollback().append(ddl).endOfStatement();
            if (this.isTrue(alter.isWithHistory())) {
                ddl = this.platformDdl.alterColumnType(this.historyTable(alter.getTableName()), alter.getColumnName(), alter.getType());
                writer.apply().append(ddl).endOfStatement();
                ddl = this.platformDdl.alterColumnType(this.historyTable(alter.getTableName()), alter.getColumnName(), alter.getCurrentType());
                writer.rollback().append(ddl).endOfStatement();
            }
        }
    }

    protected void alterColumnAddForeignKey(DdlWrite writer, AlterColumn alterColumn) throws IOException {
        String tableName = alterColumn.getTableName();
        String fkName = alterColumn.getForeignKeyName();
        String[] cols = new String[]{alterColumn.getColumnName()};
        String references = alterColumn.getReferences();
        int pos = references.lastIndexOf(46);
        if (pos == -1) {
            throw new IllegalStateException("Expecting period '.' character for table.column split but not found in [" + references + "]");
        }
        String refTableName = references.substring(0, pos);
        String refColumnName = references.substring(pos + 1);
        String[] refCols = new String[]{refColumnName};
        this.alterTableAddForeignKey(writer.apply(), fkName, tableName, cols, refTableName, refCols);
    }

    protected void alterColumnDropForeignKey(DdlWrite writer, AlterColumn alter) throws IOException {
        writer.apply().append(this.platformDdl.alterTableDropForeignKey(alter.getTableName(), alter.getDropForeignKey())).endOfStatement();
    }

    protected void alterColumnDropUniqueConstraint(DdlWrite writer, AlterColumn alter) throws IOException {
        writer.apply().append(this.platformDdl.alterTableDropUniqueConstraint(alter.getTableName(), alter.getDropUnique())).endOfStatement();
    }

    protected void alterColumnAddUniqueOneToOneConstraint(DdlWrite writer, AlterColumn alter) throws IOException {
        this.addUniqueConstraint(writer, alter, alter.getUniqueOneToOne());
    }

    protected void alterColumnAddUniqueConstraint(DdlWrite writer, AlterColumn alter) throws IOException {
        this.addUniqueConstraint(writer, alter, alter.getUnique());
    }

    protected void addUniqueConstraint(DdlWrite writer, AlterColumn alter, String uqName) throws IOException {
        String[] cols = new String[]{alter.getColumnName()};
        writer.apply().append(this.platformDdl.alterTableAddUniqueConstraint(alter.getTableName(), uqName, cols)).endOfStatement();
        writer.rollbackForeignKeys().append(this.platformDdl.dropIndex(uqName, alter.getTableName())).endOfStatement();
    }

    protected void alterTableDropColumn(DdlBuffer buffer, String tableName, String columnName) throws IOException {
        buffer.append("alter table ").append(tableName).append(" drop column ").append(columnName).endOfStatement();
    }

    protected void alterTableAddColumn(DdlBuffer buffer, String tableName, Column column, boolean onHistoryTable) throws IOException {
        buffer.append("alter table ").append(tableName).append(" add column ").append(column.getName()).append(" ").append(column.getType());
        if (!onHistoryTable) {
            if (this.isTrue(column.isNotnull())) {
                buffer.append(" not null");
            }
            if (this.hasValue(column.getCheckConstraint())) {
                buffer.append(" ").append(column.getCheckConstraint());
            }
        }
        buffer.endOfStatement();
    }

    protected boolean isFalse(Boolean value) {
        return value != null && value == false;
    }

    protected boolean hasValue(String value) {
        return value != null && !value.trim().isEmpty();
    }

    protected boolean isTrue(Boolean value) {
        return Boolean.TRUE.equals(value);
    }

    protected int toInt(BigInteger value) {
        return value == null ? 0 : value.intValue();
    }
}

