/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.ddlgeneration.platform;

import com.avaje.ebean.config.dbplatform.H2HistoryTrigger;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlBuffer;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlWrite;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.DbTriggerBasedHistoryDdl;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.HistoryTableUpdate;
import com.avaje.ebean.dbmigration.model.MTable;
import java.io.IOException;
import java.util.List;

public class H2HistoryDdl
extends DbTriggerBasedHistoryDdl {
    private static final String TRIGGER_CLASS = H2HistoryTrigger.class.getName();

    @Override
    protected void dropTriggers(DdlBuffer buffer, String baseTable) throws IOException {
        buffer.append("drop trigger ").append(this.updateTriggerName(baseTable)).endOfStatement();
    }

    @Override
    protected void createTriggers(DdlWrite writer, MTable table) throws IOException {
        String baseTableName = table.getName();
        String historyTableName = this.historyTableName(baseTableName);
        List<String> includedColumns = this.includedColumnNames(table);
        DdlBuffer apply = writer.applyHistory();
        this.addCreateTrigger(apply, this.updateTriggerName(baseTableName), baseTableName, historyTableName, includedColumns);
    }

    @Override
    protected void regenerateHistoryTriggers(DdlWrite writer, MTable table, HistoryTableUpdate update) throws IOException {
        String baseTableName = table.getName();
        String historyTableName = this.historyTableName(baseTableName);
        List<String> includedColumns = this.includedColumnNames(table);
        DdlBuffer apply = writer.applyHistory();
        apply.append("-- Regenerated ").newLine();
        apply.append("-- changes: ").append(update.description()).newLine();
        this.dropTriggers(apply, baseTableName);
        this.addCreateTrigger(apply, this.updateTriggerName(baseTableName), baseTableName, historyTableName, includedColumns);
        update.toRevertedColumns(includedColumns);
        DdlBuffer rollback = writer.rollback();
        rollback.append("-- Revert regenerated ").newLine();
        rollback.append("-- revert changes: ").append(update.description()).newLine();
        this.dropTriggers(rollback, baseTableName);
        this.addCreateTrigger(rollback, this.updateTriggerName(baseTableName), baseTableName, historyTableName, includedColumns);
    }

    private void addCreateTrigger(DdlBuffer apply, String triggerName, String baseTable, String historyTable, List<String> includedColumns) throws IOException {
        apply.append("create trigger ").append(triggerName).append(" before update,delete on ").append(baseTable).append(" for each row call \"" + TRIGGER_CLASS + "\";").newLine();
    }
}

