/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.ddlgeneration.platform;

import com.avaje.ebean.config.dbplatform.DbIdentity;
import com.avaje.ebean.config.dbplatform.DbTypeMap;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.MySqlHistoryDdl;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.PlatformDdl;
import com.avaje.ebean.dbmigration.migration.AlterColumn;

public class MySqlDdl
extends PlatformDdl {
    public MySqlDdl(DbTypeMap platformTypes, DbIdentity dbIdentity) {
        super(platformTypes, dbIdentity);
        this.alterColumn = "modify";
        this.dropUniqueConstraint = "drop index";
        this.historyDdl = new MySqlHistoryDdl();
    }

    @Override
    public String dropIndex(String indexName, String tableName) {
        return "drop index " + indexName + " on " + tableName;
    }

    @Override
    public String alterTableDropForeignKey(String tableName, String fkName) {
        return "alter table " + tableName + " drop foreign key " + fkName;
    }

    @Override
    public String alterColumnType(String tableName, String columnName, String type) {
        return null;
    }

    @Override
    public String alterColumnNotnull(String tableName, String columnName, boolean notnull) {
        return null;
    }

    @Override
    public String alterColumnDefaultValue(String tableName, String columnName, String defaultValue) {
        String suffix = this.isDropDefault(defaultValue) ? this.columnDropDefault : this.columnSetDefault + " " + defaultValue;
        return "alter table " + tableName + " alter " + columnName + " " + suffix;
    }

    @Override
    public String alterColumnBaseAttributes(AlterColumn alter) {
        String tableName = alter.getTableName();
        String columnName = alter.getColumnName();
        String type = alter.getType() != null ? alter.getType() : alter.getCurrentType();
        boolean notnull = alter.isNotnull() != null ? alter.isNotnull().booleanValue() : Boolean.TRUE.equals(alter.isCurrentNotnull());
        String notnullClause = notnull ? " not null" : "";
        return "alter table " + tableName + " modify " + columnName + " " + type + notnullClause;
    }
}

