/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.ddlgeneration.platform;

import com.avaje.ebean.dbmigration.ddlgeneration.DdlBuffer;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlWrite;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.DbTriggerBasedHistoryDdl;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.HistoryTableUpdate;
import com.avaje.ebean.dbmigration.model.MTable;
import java.io.IOException;
import java.util.List;

public class PostgresHistoryDdl
extends DbTriggerBasedHistoryDdl {
    public PostgresHistoryDdl() {
        this.currentTimestamp = "current_timestamp";
    }

    @Override
    protected void createHistoryTable(DdlBuffer apply, MTable table) throws IOException {
        String baseTable = table.getName();
        apply.append("create table ").append(baseTable).append(this.historySuffix).append("(like ").append(baseTable).append(")").endOfStatement();
    }

    @Override
    protected void addSysPeriodColumns(DdlBuffer apply, String baseTableName, String whenCreatedColumn) throws IOException {
        apply.append("alter table ").append(baseTableName).append(" add column ").append(this.sysPeriod).append(" tstzrange not null default tstzrange(").append(this.currentTimestamp).append(", null)").endOfStatement();
        if (whenCreatedColumn != null) {
            apply.append("update ").append(baseTableName).append(" set ").append(this.sysPeriod).append(" = tstzrange(").append(whenCreatedColumn).append(", null)").endOfStatement();
        }
    }

    @Override
    protected void dropSysPeriodColumns(DdlBuffer buffer, String baseTableName) throws IOException {
        buffer.append("alter table ").append(baseTableName).append(" drop column ").append(this.sysPeriod).endOfStatement();
    }

    @Override
    protected void createTriggers(DdlWrite writer, MTable table) throws IOException {
        String baseTableName = table.getName();
        String procedureName = this.procedureName(baseTableName);
        String triggerName = this.triggerName(baseTableName);
        DdlBuffer apply = writer.applyHistory();
        apply.append("create trigger ").append(triggerName).newLine().append("  before update or delete on ").append(baseTableName).newLine().append("  for each row execute procedure ").append(procedureName).append("();").newLine().newLine();
    }

    @Override
    protected void dropTriggers(DdlBuffer buffer, String baseTable) throws IOException {
        buffer.append("drop trigger if exists ").append(this.triggerName(baseTable)).append(" on ").append(baseTable).append(" cascade").endOfStatement();
        buffer.append("drop function if exists ").append(this.procedureName(baseTable)).append("()").endOfStatement();
        buffer.end();
    }

    protected void addFunction(DdlBuffer apply, String procedureName, String historyTable, List<String> includedColumns) throws IOException {
        apply.append("create or replace function ").append(procedureName).append("() returns trigger as $$").newLine().append("begin").newLine();
        apply.append("  if (TG_OP = 'UPDATE') then").newLine();
        this.appendInsertIntoHistory(apply, historyTable, includedColumns);
        apply.append("    NEW.").append(this.sysPeriod).append(" = tstzrange(CURRENT_TIMESTAMP,null);").newLine().append("    return new;").newLine();
        apply.append("  elsif (TG_OP = 'DELETE') then").newLine();
        this.appendInsertIntoHistory(apply, historyTable, includedColumns);
        apply.append("    return old;").newLine();
        apply.append("  end if;").newLine().append("end;").newLine().append("$$ LANGUAGE plpgsql;").newLine();
        apply.end();
    }

    @Override
    protected void regenerateHistoryTriggers(DdlWrite writer, MTable table, HistoryTableUpdate update) throws IOException {
        this.addStoredFunction(writer, table, update);
    }

    @Override
    protected void addStoredFunction(DdlWrite writer, MTable table, HistoryTableUpdate update) throws IOException {
        String procedureName = this.procedureName(table.getName());
        String historyTable = this.historyTableName(table.getName());
        List<String> includedColumns = this.includedColumnNames(table);
        DdlBuffer apply = writer.applyHistory();
        if (update != null) {
            apply.append("-- Regenerated ").append(procedureName).newLine();
            apply.append("-- changes: ").append(update.description()).newLine();
        }
        this.addFunction(apply, procedureName, historyTable, includedColumns);
        if (update != null) {
            update.toRevertedColumns(includedColumns);
            DdlBuffer rollback = writer.rollback();
            rollback.append("-- Revert regenerated ").append(procedureName).newLine();
            rollback.append("-- revert changes: ").append(update.description()).newLine();
            this.addFunction(rollback, procedureName, historyTable, includedColumns);
        }
    }

    @Override
    protected void appendInsertIntoHistory(DdlBuffer buffer, String historyTable, List<String> columns) throws IOException {
        buffer.append("    insert into ").append(historyTable).append(" (").append(this.sysPeriod).append(",");
        this.appendColumnNames(buffer, columns, "");
        buffer.append(") values (tstzrange(lower(OLD.").append(this.sysPeriod).append("), current_timestamp), ");
        this.appendColumnNames(buffer, columns, "OLD.");
        buffer.append(");").newLine();
    }
}

