/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.model;

import com.avaje.ebean.dbmigration.migration.Migration;
import com.avaje.ebean.dbmigration.migrationreader.MigrationXmlReader;
import com.avaje.ebean.dbmigration.model.ModelContainer;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationModel {
    private static final Logger logger = LoggerFactory.getLogger(MigrationModel.class);
    private final ModelContainer model = new ModelContainer();
    private final Set<String> readVersions = new LinkedHashSet<String>();
    private final String resourcePath;
    int nextMajorVersion;

    public MigrationModel(String resourcePath) {
        this.resourcePath = this.normaliseResourcePath(resourcePath);
    }

    private String normaliseResourcePath(String resourcePath) {
        if (resourcePath.endsWith("/")) {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        return resourcePath;
    }

    public ModelContainer read() {
        this.readMigrations();
        logger.info("read versions {}", this.readVersions);
        return this.model;
    }

    public Set<String> getReadVersions() {
        return this.readVersions;
    }

    public int getNextMajorVersion() {
        return this.nextMajorVersion;
    }

    private void readMigrations() {
        for (int majorVersion = 1; majorVersion < 100; ++majorVersion) {
            if (this.readMinorVersions(majorVersion)) continue;
            this.nextMajorVersion = majorVersion;
            return;
        }
    }

    private boolean readMinorVersions(int majorVersion) {
        for (int minorVersion = 0; minorVersion < 100; ++minorVersion) {
            if (this.readMigration(majorVersion, minorVersion)) continue;
            return minorVersion > 0;
        }
        return true;
    }

    private boolean readMigration(int majorVersion, int minorVersion) {
        String version = majorVersion + "." + minorVersion;
        String path = "/" + this.resourcePath + "/v" + version + ".xml";
        Migration migration = MigrationXmlReader.readMaybe(path);
        if (migration == null) {
            logger.debug("... no migration at path:{}", (Object)path);
            return false;
        }
        this.readVersions.add(version);
        logger.trace("... read migration v{}", (Object)version);
        this.model.apply(migration);
        return true;
    }
}

