/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.model.build;

import com.avaje.ebean.config.DbConstraintNaming;
import com.avaje.ebean.config.dbplatform.DbType;
import com.avaje.ebean.config.dbplatform.DbTypeMap;
import com.avaje.ebean.dbmigration.model.MTable;
import com.avaje.ebean.dbmigration.model.ModelContainer;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.type.ScalarType;

public class ModelBuildContext {
    private final DbTypeMap dbTypeMap = DbTypeMap.logicalTypes();
    private final ModelContainer model;
    private final DbConstraintNaming constraintNaming;
    private final DbConstraintNaming.MaxLength maxLength;

    public ModelBuildContext(ModelContainer model, DbConstraintNaming naming, DbConstraintNaming.MaxLength maxLength) {
        this.model = model;
        this.constraintNaming = naming;
        this.maxLength = maxLength;
    }

    public String primaryKeyName(String tableName) {
        return this.maxLength(this.constraintNaming.primaryKeyName(tableName), 0);
    }

    public String foreignKeyConstraintName(String tableName, String columnName, int foreignKeyCount) {
        return this.maxLength(this.constraintNaming.foreignKeyConstraintName(tableName, columnName), foreignKeyCount);
    }

    public String foreignKeyIndexName(String tableName, String[] columns, int indexCount) {
        return this.maxLength(this.constraintNaming.foreignKeyIndexName(tableName, columns), indexCount);
    }

    public String foreignKeyIndexName(String tableName, String column, int indexCount) {
        return this.maxLength(this.constraintNaming.foreignKeyIndexName(tableName, column), indexCount);
    }

    public String indexName(String tableName, String column, int indexCount) {
        return this.maxLength(this.constraintNaming.indexName(tableName, column), indexCount);
    }

    public String indexName(String tableName, String[] columns, int indexCount) {
        return this.maxLength(this.constraintNaming.indexName(tableName, columns), indexCount);
    }

    public String uniqueConstraintName(String tableName, String columnName, int indexCount) {
        return this.maxLength(this.constraintNaming.uniqueConstraintName(tableName, columnName), indexCount);
    }

    public String uniqueConstraintName(String tableName, String[] columnNames, int indexCount) {
        return this.maxLength(this.constraintNaming.uniqueConstraintName(tableName, columnNames), indexCount);
    }

    public String checkConstraintName(String tableName, String columnName, int checkCount) {
        return this.maxLength(this.constraintNaming.checkConstraintName(tableName, columnName), checkCount);
    }

    public MTable addTable(MTable table) {
        return this.model.addTable(table);
    }

    public void addIndex(String indexName, String tableName, String columnName) {
        this.model.addIndex(indexName, tableName, columnName);
    }

    public void addIndex(String indexName, String tableName, String[] columnNames) {
        this.model.addIndex(indexName, tableName, columnNames);
    }

    private String maxLength(String constraintName, int indexCount) {
        return this.maxLength.maxLength(constraintName, indexCount);
    }

    public DbTypeMap getDbTypeMap() {
        return this.dbTypeMap;
    }

    public String getColumnDefn(BeanProperty p) {
        DbType dbType = this.getDbType(p);
        if (dbType == null) {
            throw new IllegalStateException("Unknown DbType mapping for " + p.getFullBeanName());
        }
        return p.renderDbType(dbType);
    }

    private DbType getDbType(BeanProperty p) {
        if (p.isDbEncrypted()) {
            return this.dbTypeMap.get(p.getDbEncryptedType());
        }
        if (p.isLocalEncrypted()) {
            ScalarType<Object> scalarType = p.getScalarType();
            int jdbcType = scalarType.getJdbcType();
            return this.dbTypeMap.get(jdbcType);
        }
        int dbType = p.getDbType();
        if (dbType == 0) {
            throw new RuntimeException("No scalarType defined for " + p.getFullBeanName());
        }
        return this.dbTypeMap.get(dbType);
    }
}

