/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

public class ClassUtil {
    public static Object newInstance(String className) {
        try {
            Class<?> cls = Class.forName(className);
            return cls.newInstance();
        }
        catch (Exception e) {
            String msg = "Error constructing " + className;
            throw new IllegalArgumentException(msg, e);
        }
    }

    public static Class<?> getSecondArgumentType(Class<?> subclass) {
        Object[] typeArguments = ClassUtil.getSuperclassTypeParameter(subclass);
        if (typeArguments.length != 2) {
            throw new IllegalArgumentException("Expected type with 2 generic argument types but got " + typeArguments.length + " - " + Arrays.toString(typeArguments));
        }
        return ClassUtil.getRawType(typeArguments[1]);
    }

    static Type[] getSuperclassTypeParameter(Class<?> subclass) {
        Type superclass = subclass.getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("Missing generics type parameters on subclass " + subclass);
        }
        return ((ParameterizedType)superclass).getActualTypeArguments();
    }

    private static Class<?> getRawType(Type type) {
        ParameterizedType parameterizedType;
        Type rawType;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        throw new RuntimeException("Unable to obtain raw class type from " + type);
    }
}

