/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.autotune;

import com.avaje.ebean.bean.ObjectGraphOrigin;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryDetail;
import java.util.ArrayList;
import java.util.List;

public class AutoTuneCollection {
    List<Entry> entries = new ArrayList<Entry>();

    public Entry add(ObjectGraphOrigin origin, OrmQueryDetail detail, String sourceQuery) {
        Entry entry = new Entry(origin, detail, sourceQuery);
        this.entries.add(entry);
        return entry;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public static class EntryQuery {
        final String path;
        final long exeCount;
        final long totalBeanLoaded;
        final long totalMicros;

        public EntryQuery(String path, long exeCount, long totalBeanLoaded, long totalMicros) {
            this.path = path;
            this.exeCount = exeCount;
            this.totalBeanLoaded = totalBeanLoaded;
            this.totalMicros = totalMicros;
        }

        public String getPath() {
            return this.path;
        }

        public long getExeCount() {
            return this.exeCount;
        }

        public long getTotalBeanLoaded() {
            return this.totalBeanLoaded;
        }

        public long getTotalMicros() {
            return this.totalMicros;
        }
    }

    public static class Entry {
        private final ObjectGraphOrigin origin;
        private final OrmQueryDetail detail;
        private final String originalQuery;
        private final List<EntryQuery> queries = new ArrayList<EntryQuery>();

        public Entry(ObjectGraphOrigin origin, OrmQueryDetail detail, String originalQuery) {
            this.origin = origin;
            this.detail = detail;
            this.originalQuery = originalQuery;
        }

        public void addQuery(EntryQuery entryQuery) {
            this.queries.add(entryQuery);
        }

        public ObjectGraphOrigin getOrigin() {
            return this.origin;
        }

        public OrmQueryDetail getDetail() {
            return this.detail;
        }

        public String getOriginalQuery() {
            return this.originalQuery;
        }

        public List<EntryQuery> getQueries() {
            return this.queries;
        }
    }
}

