/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.autotune.service;

import com.avaje.ebean.bean.CallStack;
import com.avaje.ebean.bean.ObjectGraphNode;
import com.avaje.ebean.config.AutoTuneConfig;
import com.avaje.ebean.config.AutoTuneMode;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.autotune.ProfilingListener;
import com.avaje.ebeaninternal.server.autotune.service.TunedQueryInfo;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryDetail;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.PersistenceException;

public class BaseQueryTuner {
    private final boolean queryTuning;
    private final boolean profiling;
    private final AutoTuneMode mode;
    private final Map<String, TunedQueryInfo> tunedQueryInfoMap = new ConcurrentHashMap<String, TunedQueryInfo>();
    private final SpiEbeanServer server;
    private final ProfilingListener profilingListener;
    private final boolean skipAll;

    public BaseQueryTuner(AutoTuneConfig config, SpiEbeanServer server, ProfilingListener profilingListener) {
        this.server = server;
        this.profilingListener = profilingListener;
        this.mode = config.getMode();
        this.queryTuning = config.isQueryTuning();
        this.profiling = config.isProfiling();
        this.skipAll = !this.queryTuning && !this.profiling;
    }

    public void load(String key, TunedQueryInfo queryInfo) {
        this.tunedQueryInfoMap.put(key, queryInfo);
    }

    public OrmQueryDetail get(String key) {
        TunedQueryInfo info = this.tunedQueryInfoMap.get(key);
        return info == null ? null : info.getTunedDetail();
    }

    public boolean tuneQuery(SpiQuery<?> query) {
        if (this.skipAll || !this.tunableQuery(query)) {
            return false;
        }
        if (!this.useTuning(query)) {
            if (this.profiling) {
                this.profiling(query, this.server.createCallStack());
            }
            return false;
        }
        if (query.getParentNode() != null) {
            query.setProfilingListener(this.profilingListener);
            return true;
        }
        CallStack stack = this.server.createCallStack();
        ObjectGraphNode origin = query.setOrigin(stack);
        if (this.profiling && this.profilingListener.isProfileRequest(origin, query)) {
            query.setProfilingListener(this.profilingListener);
        }
        if (this.queryTuning) {
            TunedQueryInfo tuneInfo = this.tunedQueryInfoMap.get(origin.getOriginQueryPoint().getKey());
            return tuneInfo != null && tuneInfo.tuneQuery(query);
        }
        return false;
    }

    private boolean tunableQuery(SpiQuery<?> query) {
        SpiQuery.Type type = query.getType();
        switch (type) {
            case ROWCOUNT: 
            case ID_LIST: 
            case DELETE: 
            case SUBQUERY: {
                return false;
            }
        }
        return !query.isLoadBeanCache() && SpiQuery.TemporalMode.VERSIONS != query.getTemporalMode();
    }

    private void profiling(SpiQuery<?> query, CallStack stack) {
        ObjectGraphNode origin = query.setOrigin(stack);
        if (this.profilingListener.isProfileRequest(origin, query)) {
            query.setProfilingListener(this.profilingListener);
        }
    }

    private boolean useTuning(SpiQuery<?> query) {
        Boolean autoTune = query.isAutoTune();
        if (autoTune != null) {
            return autoTune;
        }
        switch (this.mode) {
            case DEFAULT_ON: {
                return true;
            }
            case DEFAULT_OFF: {
                return false;
            }
            case DEFAULT_ONIFEMPTY: {
                return query.isDetailEmpty();
            }
        }
        throw new PersistenceException("Invalid AutoTuneMode " + (Object)((Object)this.mode));
    }

    public Set<String> keySet() {
        return this.tunedQueryInfoMap.keySet();
    }
}

