/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.autotune.service;

import com.avaje.ebean.bean.ObjectGraphOrigin;
import com.avaje.ebean.config.AutoTuneConfig;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.autotune.AutoTuneCollection;
import com.avaje.ebeaninternal.server.autotune.AutoTuneService;
import com.avaje.ebeaninternal.server.autotune.model.Autotune;
import com.avaje.ebeaninternal.server.autotune.model.Origin;
import com.avaje.ebeaninternal.server.autotune.model.ProfileDiff;
import com.avaje.ebeaninternal.server.autotune.model.ProfileEmpty;
import com.avaje.ebeaninternal.server.autotune.model.ProfileNew;
import com.avaje.ebeaninternal.server.autotune.service.AutoTuneXmlReader;
import com.avaje.ebeaninternal.server.autotune.service.AutoTuneXmlWriter;
import com.avaje.ebeaninternal.server.autotune.service.BaseQueryTuner;
import com.avaje.ebeaninternal.server.autotune.service.ProfileManager;
import com.avaje.ebeaninternal.server.autotune.service.TunedQueryInfo;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryDetail;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryDetailParser;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAutoTuneService
implements AutoTuneService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAutoTuneService.class);
    private final long defaultGarbageCollectionWait;
    private final boolean skipCollectionOnShutdown;
    private final BaseQueryTuner queryTuner;
    private final ProfileManager profileManager;
    private final boolean profiling;
    private final boolean queryTuning;
    private final String tuningFile;
    private final String profilingFile;
    private final String serverName;

    public DefaultAutoTuneService(SpiEbeanServer server, ServerConfig serverConfig) {
        AutoTuneConfig config = serverConfig.getAutoTuneConfig();
        this.queryTuning = config.isQueryTuning();
        this.profiling = config.isProfiling();
        this.tuningFile = config.getQueryTuningFile();
        this.profilingFile = config.getProfilingFile();
        this.serverName = server.getName();
        this.profileManager = new ProfileManager(config, server);
        this.queryTuner = new BaseQueryTuner(config, server, this.profileManager);
        this.skipCollectionOnShutdown = config.isSkipCollectionOnShutdown();
        this.defaultGarbageCollectionWait = config.getGarbageCollectionWait();
    }

    @Override
    public void startup() {
        if (this.queryTuning) {
            File file = new File(this.tuningFile);
            if (!file.exists()) {
                logger.warn("AutoTune file {} not found - no automatic tuning will be applied", (Object)file.getAbsolutePath());
            } else {
                AutoTuneXmlReader reader = new AutoTuneXmlReader();
                Autotune profiling = reader.read(file);
                logger.info("AutoTune loading {} tuning entries", (Object)profiling.getOrigin().size());
                for (Origin origin : profiling.getOrigin()) {
                    this.queryTuner.load(origin.getKey(), this.createTunedQueryInfo(origin));
                }
            }
        }
    }

    @NotNull
    private TunedQueryInfo createTunedQueryInfo(Origin origin) {
        OrmQueryDetail detail = new OrmQueryDetailParser(origin.getDetail()).parse();
        return new TunedQueryInfo(detail);
    }

    private void saveProfiling(boolean reset) {
        Autotune document = new Autotune();
        AutoTuneCollection autoTuneCollection = this.profileManager.profilingCollection(reset);
        List<AutoTuneCollection.Entry> entries = autoTuneCollection.getEntries();
        AtomicInteger newCounter = new AtomicInteger();
        AtomicInteger diffCounter = new AtomicInteger();
        HashSet<String> profileKeys = new HashSet<String>();
        for (AutoTuneCollection.Entry entry : entries) {
            this.saveProfilingEntry(document, entry, newCounter, diffCounter);
            profileKeys.add(entry.getOrigin().getKey());
        }
        Set<String> tunerKeys = this.queryTuner.keySet();
        for (String tuneKey : tunerKeys) {
            if (profileKeys.contains(tuneKey)) continue;
            ProfileEmpty profileEmpty = document.getProfileEmpty();
            if (profileEmpty == null) {
                profileEmpty = new ProfileEmpty();
                document.setProfileEmpty(profileEmpty);
            }
            Origin emptyOrigin = new Origin();
            emptyOrigin.setKey(tuneKey);
            profileEmpty.getOrigin().add(emptyOrigin);
        }
        int n = newCounter.get();
        int totalDiff = diffCounter.get();
        if (n == 0 && totalDiff == 0) {
            logger.info("No new or diff entries for profiling server:{}", (Object)this.serverName);
        } else {
            this.sortDocument(document);
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
            String now = df.format(new Date());
            File file = new File(this.profilingFile + "-" + this.serverName + "-" + now + ".xml");
            AutoTuneXmlWriter writer = new AutoTuneXmlWriter();
            writer.write(document, file);
            logger.info("writing new:{} diff:{} profiling entries for server:{}", new Object[]{n, totalDiff, this.serverName});
        }
    }

    private void sortDocument(Autotune document) {
        ProfileEmpty profileEmpty;
        ProfileNew profileNew;
        ProfileDiff profileDiff = document.getProfileDiff();
        if (profileDiff != null) {
            Collections.sort(profileDiff.getOrigin(), new OriginNameKeySort());
        }
        if ((profileNew = document.getProfileNew()) != null) {
            Collections.sort(profileNew.getOrigin(), new OriginNameKeySort());
        }
        if ((profileEmpty = document.getProfileEmpty()) != null) {
            Collections.sort(profileEmpty.getOrigin(), new OriginKeySort());
        }
    }

    private void saveProfilingEntry(Autotune document, AutoTuneCollection.Entry entry, AtomicInteger newCount, AtomicInteger diffCount) {
        ObjectGraphOrigin point = entry.getOrigin();
        OrmQueryDetail profileDetail = entry.getDetail();
        OrmQueryDetail tuneDetail = this.queryTuner.get(point.getKey());
        if (tuneDetail == null) {
            newCount.incrementAndGet();
            ProfileNew profileNew = document.getProfileNew();
            if (profileNew == null) {
                profileNew = new ProfileNew();
                document.setProfileNew(profileNew);
            }
            Origin origin = this.createOrigin(entry, point);
            origin.setOriginal(entry.getOriginalQuery());
            profileNew.getOrigin().add(origin);
        } else if (!tuneDetail.isAutoTuneEqual(profileDetail)) {
            diffCount.incrementAndGet();
            Origin origin = this.createOrigin(entry, point);
            origin.setOriginal(tuneDetail.toString());
            ProfileDiff diff = document.getProfileDiff();
            if (diff == null) {
                diff = new ProfileDiff();
                document.setProfileDiff(diff);
            }
            diff.getOrigin().add(origin);
        }
    }

    @NotNull
    private Origin createOrigin(AutoTuneCollection.Entry entry, ObjectGraphOrigin point) {
        Origin origin = new Origin();
        origin.setKey(point.getKey());
        origin.setBeanType(point.getBeanType());
        origin.setDetail(entry.getDetail().toString());
        origin.setCallStack(point.getCallStack().description("\n"));
        return origin;
    }

    @Override
    public void shutdown() {
        if (this.profiling && !this.skipCollectionOnShutdown) {
            this.collectProfiling(-1L);
            this.saveProfiling(false);
        }
    }

    @Override
    public void collectProfiling() {
        this.collectProfiling(-1L);
    }

    public void collectProfiling(long waitMillis) {
        System.gc();
        try {
            if (waitMillis < 0L) {
                waitMillis = this.defaultGarbageCollectionWait;
            }
            Thread.sleep(waitMillis);
        }
        catch (InterruptedException e) {
            logger.warn("Error while sleeping after System.gc() request.", (Throwable)e);
        }
    }

    @Override
    public boolean tuneQuery(SpiQuery<?> query) {
        return this.queryTuner.tuneQuery(query);
    }

    class OriginKeySort
    implements Comparator<Origin> {
        OriginKeySort() {
        }

        @Override
        public int compare(Origin o1, Origin o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    }

    class OriginNameKeySort
    implements Comparator<Origin> {
        OriginNameKeySort() {
        }

        @Override
        public int compare(Origin o1, Origin o2) {
            int comp = o1.getBeanType().compareTo(o2.getBeanType());
            if (comp == 0) {
                comp = o1.getKey().compareTo(o2.getKey());
            }
            return comp;
        }
    }
}

