/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.autotune.service;

import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryDetail;
import java.io.Serializable;

public class TunedQueryInfo
implements Serializable {
    private final OrmQueryDetail tunedDetail;

    public TunedQueryInfo(OrmQueryDetail tunedDetail) {
        this.tunedDetail = tunedDetail;
    }

    public OrmQueryDetail getTunedDetail() {
        return this.tunedDetail;
    }

    public boolean tuneQuery(SpiQuery<?> query) {
        boolean tuned;
        if (this.tunedDetail == null) {
            return false;
        }
        if (query.isDetailEmpty()) {
            tuned = true;
            query.setDetail(this.tunedDetail.copy());
        } else {
            tuned = query.tuneFetchProperties(this.tunedDetail);
        }
        if (tuned) {
            query.setAutoTuned(true);
        }
        return tuned;
    }

    public String toString() {
        return this.tunedDetail.toString();
    }
}

